/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitContextFactory;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.PostRestoreStateEvent;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.lifecycle.RestoreViewSupport;
import org.apache.myfaces.shared.application.CheckedViewIdsCache;
import org.apache.myfaces.shared.application.FacesServletMapping;
import org.apache.myfaces.shared.application.InvalidViewIdException;
import org.apache.myfaces.shared.util.Assert;
import org.apache.myfaces.shared.util.ConcurrentLRUCache;
import org.apache.myfaces.shared.util.ExternalContextUtils;

public class DefaultRestoreViewSupport
implements RestoreViewSupport {
    private static final String JAVAX_SERVLET_INCLUDE_SERVLET_PATH = "jakarta.servlet.include.servlet_path";
    private static final String JAVAX_SERVLET_INCLUDE_PATH_INFO = "jakarta.servlet.include.path_info";
    private static final String PORTLET_LIFECYCLE_PHASE = "javax.portlet.faces.phase";
    private static final String CACHED_SERVLET_MAPPING = DefaultRestoreViewSupport.class.getName() + ".CACHED_SERVLET_MAPPING";
    private final Logger log = Logger.getLogger(DefaultRestoreViewSupport.class.getName());
    private static final String SKIP_ITERATION_HINT = "jakarta.faces.visit.SKIP_ITERATION";
    private static final Set<VisitHint> VISIT_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_ITERATION));
    private volatile ConcurrentLRUCache<String, Boolean> _checkedViewIdMap = null;
    private Boolean _checkedViewIdCacheEnabled = null;
    private RenderKitFactory _renderKitFactory = null;
    private VisitContextFactory _visitContextFactory = null;
    private final String[] _faceletsViewMappings;
    private final String[] _contextSuffixes;
    private final String _faceletsContextSufix;
    private final boolean _initialized;
    private CheckedViewIdsCache checkedViewIdsCache = null;

    public DefaultRestoreViewSupport() {
        this._faceletsViewMappings = null;
        this._contextSuffixes = null;
        this._faceletsContextSufix = null;
        this._initialized = false;
    }

    public DefaultRestoreViewSupport(FacesContext facesContext) {
        this._faceletsViewMappings = this.getFaceletsViewMappings(facesContext);
        this._contextSuffixes = this.getContextSuffix(facesContext);
        this._faceletsContextSufix = this.getFaceletsContextSuffix(facesContext);
        this._initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processComponentBinding(FacesContext facesContext, UIComponent component) {
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, Boolean.TRUE);
            VisitContext visitContext = this.getVisitContextFactory().getVisitContext(facesContext, null, VISIT_HINTS);
            component.visitTree(visitContext, (VisitCallback)new RestoreStateCallback());
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
    }

    @Override
    public String calculateViewId(FacesContext facesContext) {
        Assert.notNull(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        String viewId = null;
        boolean traceEnabled = this.log.isLoggable(Level.FINEST);
        if (requestMap.containsKey(PORTLET_LIFECYCLE_PHASE)) {
            viewId = externalContext.getRequestPathInfo();
        } else {
            viewId = (String)requestMap.get(JAVAX_SERVLET_INCLUDE_PATH_INFO);
            if (viewId != null) {
                if (traceEnabled) {
                    this.log.finest("Calculated viewId '" + viewId + "' from request param '" + JAVAX_SERVLET_INCLUDE_PATH_INFO + "'");
                }
            } else {
                viewId = externalContext.getRequestPathInfo();
                if (viewId != null && traceEnabled) {
                    this.log.finest("Calculated viewId '" + viewId + "' from request path info");
                }
            }
            if (viewId == null && (viewId = (String)requestMap.get(JAVAX_SERVLET_INCLUDE_SERVLET_PATH)) != null && traceEnabled) {
                this.log.finest("Calculated viewId '" + viewId + "' from request param '" + JAVAX_SERVLET_INCLUDE_SERVLET_PATH + "'");
            }
        }
        if (viewId == null && (viewId = externalContext.getRequestServletPath()) != null && traceEnabled) {
            this.log.finest("Calculated viewId '" + viewId + "' from request servlet path");
        }
        if (viewId == null) {
            throw new FacesException("Could not determine view id.");
        }
        return viewId;
    }

    @Override
    public boolean isPostback(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String renderkitId = viewHandler.calculateRenderKitId(facesContext);
        ResponseStateManager rsm = this.getRenderKitFactory().getRenderKit(facesContext, renderkitId).getResponseStateManager();
        return rsm.isPostback(facesContext);
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    protected VisitContextFactory getVisitContextFactory() {
        if (this._visitContextFactory == null) {
            this._visitContextFactory = (VisitContextFactory)FactoryFinder.getFactory((String)"jakarta.faces.component.visit.VisitContextFactory");
        }
        return this._visitContextFactory;
    }

    @Override
    @Deprecated
    public String deriveViewId(FacesContext context, String viewId) {
        if (viewId == null) {
            return null;
        }
        FacesServletMapping mapping = this.getFacesServletMapping(context);
        if (mapping == null || mapping.isExtensionMapping()) {
            viewId = this.handleSuffixMapping(context, viewId);
        } else if (mapping.isPrefixMapping()) {
            if ((viewId = this.handlePrefixMapping(viewId, mapping.getPrefix())) != null && viewId.equals(mapping.getPrefix()) && !ExternalContextUtils.isPortlet(context.getExternalContext())) {
                throw new InvalidViewIdException();
            }
        } else if (viewId != null && mapping.getUrlPattern().startsWith(viewId)) {
            throw new InvalidViewIdException(viewId);
        }
        return viewId;
    }

    protected String[] getContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("jakarta.faces.DEFAULT_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml .view.xml .jsp";
        }
        return defaultSuffix.split(" ");
    }

    protected String getFaceletsContextSuffix(FacesContext context) {
        String defaultSuffix = context.getExternalContext().getInitParameter("jakarta.faces.FACELETS_SUFFIX");
        if (defaultSuffix == null) {
            defaultSuffix = ".xhtml";
        }
        return defaultSuffix;
    }

    protected String[] getFaceletsViewMappings(FacesContext context) {
        String faceletsViewMappings = context.getExternalContext().getInitParameter("jakarta.faces.FACELETS_VIEW_MAPPINGS");
        if (faceletsViewMappings == null) {
            faceletsViewMappings = context.getExternalContext().getInitParameter("facelets.VIEW_MAPPINGS");
        }
        return faceletsViewMappings == null ? null : faceletsViewMappings.split(";");
    }

    protected String handlePrefixMapping(String viewId, String prefix) {
        String uri = viewId;
        prefix = "".equals(prefix) ? "//" : prefix + '/';
        while (uri.startsWith(prefix) || uri.startsWith("//")) {
            if (uri.startsWith(prefix)) {
                uri = uri.substring(prefix.length() - 1);
                continue;
            }
            uri = uri.substring(1);
        }
        return uri;
    }

    protected String handleSuffixMapping(FacesContext context, String requestViewId) {
        String faceletsDefaultSuffix;
        String[] faceletsViewMappings = this._initialized ? this._faceletsViewMappings : this.getFaceletsViewMappings(context);
        String[] jspDefaultSuffixes = this._initialized ? this._contextSuffixes : this.getContextSuffix(context);
        int slashPos = requestViewId.lastIndexOf(47);
        int extensionPos = requestViewId.lastIndexOf(46);
        for (String defaultSuffix : jspDefaultSuffixes) {
            StringBuilder builder = new StringBuilder(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), defaultSuffix);
            } else {
                builder.append(defaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (faceletsViewMappings != null && faceletsViewMappings.length > 0) {
                for (String mapping : faceletsViewMappings) {
                    if (mapping.startsWith("/")) continue;
                    if (mapping.equals(candidateViewId)) {
                        return candidateViewId;
                    }
                    if (!mapping.startsWith(".")) continue;
                    builder.setLength(0);
                    builder.append(candidateViewId);
                    builder.replace(candidateViewId.lastIndexOf(46), candidateViewId.length(), mapping);
                    String tempViewId = builder.toString();
                    if (!this.checkResourceExists(context, tempViewId)) continue;
                    return tempViewId;
                }
            }
            if (!this.checkResourceExists(context, candidateViewId)) continue;
            return candidateViewId;
        }
        String string = faceletsDefaultSuffix = this._initialized ? this._faceletsContextSufix : this.getFaceletsContextSuffix(context);
        if (faceletsDefaultSuffix != null) {
            for (String defaultSuffix : jspDefaultSuffixes) {
                if (!faceletsDefaultSuffix.equals(defaultSuffix)) continue;
                faceletsDefaultSuffix = null;
                break;
            }
        }
        if (faceletsDefaultSuffix != null) {
            StringBuilder builder = new StringBuilder(requestViewId);
            if (extensionPos > -1 && extensionPos > slashPos) {
                builder.replace(extensionPos, requestViewId.length(), faceletsDefaultSuffix);
            } else {
                builder.append(faceletsDefaultSuffix);
            }
            String candidateViewId = builder.toString();
            if (this.checkResourceExists(context, candidateViewId)) {
                return candidateViewId;
            }
        }
        if (this.checkResourceExists(context, requestViewId)) {
            return requestViewId;
        }
        return null;
    }

    protected boolean checkResourceExists(FacesContext facesContext, String viewId) {
        if (this.checkedViewIdsCache == null) {
            this.checkedViewIdsCache = CheckedViewIdsCache.getInstance(facesContext);
        }
        try {
            Boolean resourceExists = null;
            if (this.checkedViewIdsCache.isEnabled()) {
                resourceExists = this.checkedViewIdsCache.getCache().get(viewId);
            }
            if (resourceExists == null) {
                ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
                resourceExists = vdl != null ? Boolean.valueOf(vdl.viewExists(facesContext, viewId)) : Boolean.valueOf(facesContext.getExternalContext().getResource(viewId) != null);
                if (this.checkedViewIdsCache.isEnabled()) {
                    this.checkedViewIdsCache.getCache().put(viewId, resourceExists);
                }
            }
            return resourceExists;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    @Override
    public boolean checkViewExists(FacesContext facesContext, String viewId) {
        return this.checkResourceExists(facesContext, viewId);
    }

    protected FacesServletMapping getFacesServletMapping(FacesContext context) {
        Map attributes = context.getAttributes();
        FacesServletMapping mapping = (FacesServletMapping)attributes.get(CACHED_SERVLET_MAPPING);
        if (mapping == null) {
            ExternalContext externalContext = context.getExternalContext();
            mapping = DefaultRestoreViewSupport.calculateFacesServletMapping(externalContext.getRequestServletPath(), externalContext.getRequestPathInfo());
            attributes.put(CACHED_SERVLET_MAPPING, mapping);
        }
        return mapping;
    }

    protected static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    private static class RestoreStateCallback
    implements VisitCallback {
        private PostRestoreStateEvent event;

        private RestoreStateCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (this.event == null) {
                this.event = new PostRestoreStateEvent(target);
            } else {
                this.event.setComponent(target);
            }
            target.processEvent((ComponentSystemEvent)this.event);
            return VisitResult.ACCEPT;
        }
    }
}

