/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class HttpServletRequestFilter
extends HttpServletRequestWrapper {
    private Message m;
    private boolean isPostFormRequest;
    private MultivaluedMap<String, String> formParams;

    public HttpServletRequestFilter(HttpServletRequest request, Message message) {
        super(request);
        this.m = message;
        this.isPostFormRequest = FormUtils.isFormPostRequest(this.m);
    }

    public ServletInputStream getInputStream() throws IOException {
        InputStream is = (InputStream)this.m.getContent(InputStream.class);
        if (is instanceof DelegatingInputStream) {
            is = ((DelegatingInputStream)is).getInputStream();
        }
        if (is instanceof ServletInputStream) {
            return (ServletInputStream)is;
        }
        return super.getInputStream();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values == null || values.length == 0 ? null : values[0];
    }

    public String[] getParameterValues(String name) {
        String[] value = super.getParameterValues(name);
        if (value == null && this.isPostFormRequest) {
            this.readFromParamsIfNeeded();
            List values = (List)this.formParams.get((Object)name);
            if (values != null) {
                value = values.toArray(new String[0]);
            }
        }
        return value;
    }

    public Map<String, String[]> getParameterMap() {
        Map map1 = super.getParameterMap();
        if (this.isPostFormRequest) {
            this.readFromParamsIfNeeded();
            LinkedHashMap map2 = new LinkedHashMap();
            map2.putAll(map1);
            for (Map.Entry e : this.formParams.entrySet()) {
                map2.put(e.getKey(), ((List)e.getValue()).toArray(new String[0]));
            }
            return Collections.unmodifiableMap(map2);
        }
        return map1;
    }

    public Enumeration<String> getParameterNames() {
        Map<String, String[]> map = this.getParameterMap();
        final Iterator<String> it = map.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)it.next();
            }
        };
    }

    private void readFromParamsIfNeeded() {
        if (this.formParams == null) {
            if (this.m.containsKey((Object)"org.apache.cxf.form_data")) {
                this.formParams = (MultivaluedMap)this.m.get((Object)"org.apache.cxf.form_data");
            } else {
                this.formParams = new MetadataMap<String, String>();
                MediaType mt = JAXRSUtils.toMediaType((String)this.m.get((Object)"Content-Type"));
                String enc = HttpUtils.getEncoding(mt, StandardCharsets.UTF_8.name());
                String body = FormUtils.readBody((InputStream)this.m.getContent(InputStream.class), enc);
                FormUtils.populateMapFromString(this.formParams, this.m, body, enc, true);
            }
        }
    }
}

