/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.impl;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.geronimo.microprofile.opentracing.config.GeronimoOpenTracingConfig;

@ApplicationScoped
public class IdGenerator {
    @Inject
    protected GeronimoOpenTracingConfig config;
    private Supplier<Object> delegate;
    private boolean counter;

    @PostConstruct
    void createDelegate() {
        String type = this.config.read("id.generator", "counter");
        this.counter = "counter".equalsIgnoreCase(type);
        switch (type) {
            case "counter": {
                this.delegate = new Supplier<Object>(){
                    private final AtomicLong counter = new AtomicLong();

                    @Override
                    public Object get() {
                        return this.counter.incrementAndGet();
                    }
                };
                break;
            }
            case "uuid": {
                this.delegate = () -> UUID.randomUUID().toString();
                break;
            }
            default: {
                this.delegate = new Supplier<Object>(){
                    private final Random random = new Random(System.nanoTime());
                    private final char[] hexDigits = "0123456789abcdef".toCharArray();
                    private final String constantPart;
                    {
                        this.constantPart = IdGenerator.this.config.read("id.generator.hex.prefix", "");
                    }

                    @Override
                    public Object get() {
                        StringBuilder sb = new StringBuilder(16).append(this.constantPart);
                        for (int i = 0; i < 16 - this.constantPart.length(); ++i) {
                            sb.append(this.hexDigits[this.random.nextInt(16)]);
                        }
                        return sb.toString();
                    }
                };
            }
        }
    }

    public boolean isCounter() {
        return this.counter;
    }

    public Object next() {
        return this.delegate.get();
    }
}

