/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.webapp;

import jakarta.faces.application.Application;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.el.ValueBinding;
import jakarta.faces.webapp.UIComponentClassicTagBase;
import jakarta.faces.webapp.UIComponentTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;

public class ConverterTag
extends TagSupport {
    private static final long serialVersionUID = -6168345066829108081L;
    private String _converterId;
    private String _binding;

    public void setConverterId(String converterId) {
        this._converterId = converterId;
    }

    public int doStartTag() throws JspException {
        UIComponentClassicTagBase componentTag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase(this.pageContext);
        if (componentTag == null) {
            throw new JspException("no parent UIComponentTag found");
        }
        if (!componentTag.getCreated()) {
            return 0;
        }
        Converter converter = this.createConverter();
        UIComponent component = componentTag.getComponentInstance();
        if (component == null) {
            throw new JspException("parent UIComponentTag has no UIComponent");
        }
        if (!(component instanceof ValueHolder)) {
            throw new JspException("UIComponent is no ValueHolder");
        }
        ((ValueHolder)((Object)component)).setConverter(converter);
        return 0;
    }

    public void release() {
        super.release();
        this._converterId = null;
        this._binding = null;
    }

    protected Converter createConverter() throws JspException {
        Converter converter;
        ValueBinding vb;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (this._binding != null && (vb = application.createValueBinding(this._binding)) != null && (converter = (Converter)vb.getValue(facesContext)) != null) {
            return converter;
        }
        if (UIComponentTag.isValueReference(this._converterId)) {
            vb = facesContext.getApplication().createValueBinding(this._converterId);
            return application.createConverter((String)vb.getValue(facesContext));
        }
        return application.createConverter(this._converterId);
    }

    public void setBinding(String binding) throws JspException {
        this._binding = binding;
    }
}

