/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import jakarta.el.ValueExpression;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.myfaces.shared.util.ClassUtils;

public class LoadBundleTag
extends TagSupport {
    private static final long serialVersionUID = -8892145684062838928L;
    private ValueExpression _basename;
    private String _var;

    public void setBasename(ValueExpression basename) {
        this._basename = basename;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public int doStartTag() throws JspException {
        ResourceBundle bundle;
        if (null == this._var) {
            throw new NullPointerException("LoadBundle: 'var' must not be null");
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new JspException("No faces context?!");
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null) {
            throw new JspException("No view root! LoadBundle must be nested inside <f:view> action.");
        }
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            locale = facesContext.getApplication().getDefaultLocale();
        }
        String basename = null;
        if (this._basename != null) {
            basename = this._basename.isLiteralText() ? this._basename.getExpressionString() : (String)this._basename.getValue(facesContext.getELContext());
        }
        if (null == basename) {
            throw new NullPointerException("LoadBundle: 'basename' must not be null");
        }
        try {
            bundle = ResourceBundle.getBundle(basename, locale, ClassUtils.getContextClassLoader());
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle(basename, locale, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (MissingResourceException e1) {
                throw new JspException("Resource bundle '" + basename + "' could not be found.", (Throwable)e1);
            }
        }
        facesContext.getExternalContext().getRequestMap().put(this._var, new BundleMap(bundle));
        return 0;
    }

    private static class BundleMap
    implements Map<String, String> {
        private ResourceBundle _bundle;
        private List<String> _values;

        public BundleMap(ResourceBundle bundle) {
            this._bundle = bundle;
        }

        @Override
        public String get(Object key) {
            try {
                return (String)this._bundle.getObject(key.toString());
            }
            catch (Exception e) {
                return "???" + key + "???";
            }
        }

        @Override
        public boolean isEmpty() {
            return !this._bundle.getKeys().hasMoreElements();
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                return this._bundle.getObject(key.toString()) != null;
            }
            catch (MissingResourceException e) {
                return false;
            }
        }

        @Override
        public Collection<String> values() {
            if (this._values == null) {
                this._values = new ArrayList<String>();
                Enumeration<String> enumer = this._bundle.getKeys();
                while (enumer.hasMoreElements()) {
                    String v = this._bundle.getString(enumer.nextElement());
                    this._values.add(v);
                }
            }
            return this._values;
        }

        @Override
        public int size() {
            return this.values().size();
        }

        @Override
        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                final String k = enumer.nextElement();
                set.add(new Map.Entry<String, String>(){

                    @Override
                    public String getKey() {
                        return k;
                    }

                    @Override
                    public String getValue() {
                        return (String)_bundle.getObject(k);
                    }

                    @Override
                    public String setValue(String value) {
                        throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
                    }
                });
            }
            return set;
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> set = new HashSet<String>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                set.add(enumer.nextElement());
            }
            return set;
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> t) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    }
}

