/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.resource;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.shared.resource.AliasResourceMetaImpl;
import org.apache.myfaces.shared.resource.ContractResource;
import org.apache.myfaces.shared.resource.ResourceHandlerSupport;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.resource.ResourceLoaderUtils;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.resource.ValueExpressionFilterInputStream;

public class ResourceImpl
extends Resource
implements ContractResource {
    protected static final String JAVAX_FACES_LIBRARY_NAME = "jakarta.faces";
    protected static final String JSF_JS_RESOURCE_NAME = "jsf.js";
    private ResourceMeta _resourceMeta;
    private ResourceLoader _resourceLoader;
    private ResourceHandlerSupport _resourceHandlerSupport;
    private URL _url;
    private String _requestPath;

    public ResourceImpl(ResourceMeta resourceMeta, ResourceLoader resourceLoader, ResourceHandlerSupport support, String contentType) {
        this._resourceMeta = resourceMeta;
        this._resourceLoader = resourceLoader;
        this._resourceHandlerSupport = support;
        this.setLibraryName(resourceMeta.getLibraryName());
        this.setResourceName(resourceMeta.getResourceName());
        this.setContentType(contentType);
    }

    public ResourceImpl(ResourceMeta resourceMeta, ResourceLoader resourceLoader, ResourceHandlerSupport support, String contentType, URL url, String requestPath) {
        this._resourceMeta = resourceMeta;
        this._resourceLoader = resourceLoader;
        this._resourceHandlerSupport = support;
        this._url = url;
        this._requestPath = requestPath;
        this.setLibraryName(resourceMeta.getLibraryName());
        this.setResourceName(resourceMeta.getResourceName());
        this.setContentType(contentType);
    }

    public ResourceLoader getResourceLoader() {
        return this._resourceLoader;
    }

    public InputStream getInputStream() throws IOException {
        if (this.couldResourceContainValueExpressions()) {
            return new ValueExpressionFilterInputStream(this.getResourceLoader().getResourceInputStream(this._resourceMeta), this.getLibraryName(), this.getResourceName());
        }
        return this.getResourceLoader().getResourceInputStream(this._resourceMeta);
    }

    private boolean couldResourceContainValueExpressions() {
        if (this._resourceMeta.couldResourceContainValueExpressions()) {
            return true;
        }
        String contentType = this.getContentType();
        return "text/css".equals(contentType);
    }

    public String getRequestPath() {
        if (this._requestPath == null) {
            String path;
            if (this._resourceHandlerSupport.isExtensionMapping()) {
                path = this._resourceHandlerSupport.getResourceIdentifier() + '/' + this.getResourceName() + this._resourceHandlerSupport.getMapping();
            } else {
                String mapping = this._resourceHandlerSupport.getMapping();
                path = this._resourceHandlerSupport.getResourceIdentifier() + '/' + this.getResourceName();
                path = mapping == null ? path : mapping + path;
            }
            FacesContext facesContext = FacesContext.getCurrentInstance();
            String metadata = null;
            boolean useAmp = false;
            if (this.getLibraryName() != null) {
                metadata = "?ln=" + this.getLibraryName();
                path = path + metadata;
                useAmp = true;
                if (!facesContext.isProjectStage(ProjectStage.Production) && JSF_JS_RESOURCE_NAME.equals(this.getResourceName()) && JAVAX_FACES_LIBRARY_NAME.equals(this.getLibraryName())) {
                    path = path + "&stage=" + facesContext.getApplication().getProjectStage().toString();
                }
            }
            if (this._resourceMeta.getLocalePrefix() != null) {
                path = path + (useAmp ? (char)'&' : '?') + "loc=" + this._resourceMeta.getLocalePrefix();
                useAmp = true;
            }
            if (this._resourceMeta.getContractName() != null) {
                path = path + (useAmp ? (char)'&' : '?') + "con=" + this._resourceMeta.getContractName();
                useAmp = true;
            }
            this._requestPath = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, path);
        }
        return this._requestPath;
    }

    public Map<String, String> getResponseHeaders() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.getApplication().getResourceHandler().isResourceRequest(facesContext)) {
            long lastModified;
            HashMap<String, String> headers = new HashMap<String, String>();
            try {
                lastModified = ResourceLoaderUtils.getResourceLastModified(this.getURL());
            }
            catch (IOException e) {
                lastModified = -1L;
            }
            if (this.couldResourceContainValueExpressions() && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            } else if (this._resourceMeta instanceof AliasResourceMetaImpl && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            }
            if (lastModified >= 0L) {
                headers.put("Last-Modified", ResourceLoaderUtils.formatDateHeader(lastModified));
                long expires = facesContext.isProjectStage(ProjectStage.Development) ? System.currentTimeMillis() : System.currentTimeMillis() + this._resourceHandlerSupport.getMaxTimeExpires();
                headers.put("Expires", ResourceLoaderUtils.formatDateHeader(expires));
            }
            return headers;
        }
        return Collections.emptyMap();
    }

    public URL getURL() {
        if (this._url == null) {
            this._url = this.getResourceLoader().getResourceURL(this._resourceMeta);
        }
        return this._url;
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        Long lastModified;
        String ifModifiedSinceString = (String)context.getExternalContext().getRequestHeaderMap().get("If-Modified-Since");
        if (ifModifiedSinceString == null) {
            return true;
        }
        Long ifModifiedSince = ResourceLoaderUtils.parseDateHeader(ifModifiedSinceString);
        if (ifModifiedSince == null) {
            return true;
        }
        try {
            lastModified = ResourceLoaderUtils.getResourceLastModified(this.getURL());
        }
        catch (IOException exception) {
            lastModified = -1L;
        }
        if (lastModified >= 0L) {
            if (this.couldResourceContainValueExpressions() && lastModified < this._resourceHandlerSupport.getStartupTime()) {
                lastModified = this._resourceHandlerSupport.getStartupTime();
            }
            if (lastModified - lastModified % 1000L <= ifModifiedSince) {
                return false;
            }
        }
        return true;
    }

    protected ResourceHandlerSupport getResourceHandlerSupport() {
        return this._resourceHandlerSupport;
    }

    protected ResourceMeta getResourceMeta() {
        return this._resourceMeta;
    }

    @Override
    public boolean isContractResource() {
        return this._resourceMeta.getContractName() != null;
    }

    @Override
    public String getContractName() {
        return this._resourceMeta.getContractName();
    }
}

