/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.timeout;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.safeguard.impl.annotation.AnnotationFinder;
import org.apache.safeguard.impl.cache.Key;
import org.apache.safeguard.impl.cache.UnwrappedCache;
import org.apache.safeguard.impl.config.ConfigurationMapper;
import org.apache.safeguard.impl.customizable.Safeguard;
import org.apache.safeguard.impl.metrics.FaultToleranceMetrics;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@Timeout
@Interceptor
@Priority(value=4020)
public class TimeoutInterceptor
implements Serializable {
    @Inject
    private Cache cache;
    @Inject
    @Safeguard
    private Executor executor;

    @AroundInvoke
    public Object withTimeout(InvocationContext context) throws Exception {
        Key key;
        Map<Key, Model> timeouts = this.cache.getTimeouts();
        Model model = timeouts.get(key = new Key(context, this.cache.getUnwrappedCache().getUnwrappedCache()));
        if (model == null) {
            model = this.cache.create(context);
            timeouts.putIfAbsent(key, model);
        }
        if (model.disabled) {
            return context.proceed();
        }
        FutureTask<Object> task = new FutureTask<Object>(() -> ((InvocationContext)context).proceed());
        long start = System.nanoTime();
        this.executor.execute(task);
        try {
            Object result = task.get(model.timeout, TimeUnit.NANOSECONDS);
            model.successes.inc();
            Object object = result;
            return object;
        }
        catch (ExecutionException ee) {
            this.cancel(task);
            throw this.toCause(ee);
        }
        catch (TimeoutException te) {
            model.timeouts.inc();
            this.cancel(task);
            throw new org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException((Throwable)te);
        }
        finally {
            long end = System.nanoTime();
            model.executionDuration.update(end - start);
        }
    }

    private void cancel(FutureTask<Object> task) {
        if (!task.isDone()) {
            task.cancel(true);
        }
    }

    private Exception toCause(Exception te) throws Exception {
        Throwable cause = te.getCause();
        if (Exception.class.isInstance(cause)) {
            throw (Exception)Exception.class.cast(cause);
        }
        if (Error.class.isInstance(cause)) {
            throw (Error)Error.class.cast(cause);
        }
        throw te;
    }

    @ApplicationScoped
    public static class Cache {
        private final Map<Key, Model> timeouts = new ConcurrentHashMap<Key, Model>();
        @Inject
        private AnnotationFinder finder;
        @Inject
        private FaultToleranceMetrics metrics;
        @Inject
        private ConfigurationMapper mapper;
        @Inject
        private UnwrappedCache unwrappedCache;

        public UnwrappedCache getUnwrappedCache() {
            return this.unwrappedCache;
        }

        public Map<Key, Model> getTimeouts() {
            return this.timeouts;
        }

        public Model create(InvocationContext context) {
            Timeout timeout = this.mapper.map(this.finder.findAnnotation(Timeout.class, context), context.getMethod(), Timeout.class);
            if (timeout.value() < 0L) {
                throw new FaultToleranceDefinitionException("Timeout can't be < 0: " + context.getMethod());
            }
            String metricsNameBase = "ft." + context.getMethod().getDeclaringClass().getCanonicalName() + "." + context.getMethod().getName() + ".timeout.";
            return new Model(!this.mapper.isEnabled(context.getMethod(), Timeout.class), timeout.unit().getDuration().toNanos() * timeout.value(), this.metrics.histogram(metricsNameBase + "executionDuration", "Histogram of execution times for the method"), this.metrics.counter(metricsNameBase + "callsTimedOut.total", "The number of times the method timed out"), this.metrics.counter(metricsNameBase + "callsNotTimedOut.total", "The number of times the method completed without timing out"));
        }
    }

    private static class Model {
        private final boolean disabled;
        private final long timeout;
        private final FaultToleranceMetrics.Histogram executionDuration;
        private final FaultToleranceMetrics.Counter timeouts;
        private final FaultToleranceMetrics.Counter successes;

        private Model(boolean disabled, long timeout, FaultToleranceMetrics.Histogram executionDuration, FaultToleranceMetrics.Counter timeouts, FaultToleranceMetrics.Counter successes) {
            this.disabled = disabled;
            this.timeout = timeout;
            this.executionDuration = executionDuration;
            this.timeouts = timeouts;
            this.successes = successes;
        }
    }
}

