/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.circuitbreaker;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.safeguard.impl.annotation.AnnotationFinder;
import org.apache.safeguard.impl.cache.Key;
import org.apache.safeguard.impl.cache.UnwrappedCache;
import org.apache.safeguard.impl.config.ConfigurationMapper;
import org.apache.safeguard.impl.metrics.FaultToleranceMetrics;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@CircuitBreaker
@Interceptor
@Priority(value=4012)
public class CircuitBreakerInterceptor
implements Serializable {
    @Inject
    private Cache cache;

    @AroundInvoke
    public Object ifNotOpen(InvocationContext context) throws Exception {
        Key key;
        Map<Key, CircuitBreakerImpl> circuitBreakers = this.cache.getCircuitBreakers();
        CircuitBreakerImpl circuitBreaker = circuitBreakers.get(key = new Key(context, this.cache.getUnwrappedCache().getUnwrappedCache()));
        if (circuitBreaker == null) {
            circuitBreaker = this.cache.create(context);
            CircuitBreakerImpl existing = circuitBreakers.putIfAbsent(key, circuitBreaker);
            if (existing != null) {
                circuitBreaker = existing;
            } else {
                this.cache.postCreate(circuitBreaker, context);
            }
        }
        if (circuitBreaker.disabled) {
            return context.proceed();
        }
        CheckResult state = circuitBreaker.performStateCheck(CheckType.READ_ONLY);
        if (state == CheckResult.OPEN) {
            circuitBreaker.callsPrevented.inc();
            throw new CircuitBreakerOpenException(context.getMethod() + " circuit breaker is open");
        }
        try {
            Object result = context.proceed();
            if (state != CheckResult.CLOSED_CHANGED) {
                circuitBreaker.onSuccess();
            }
            circuitBreaker.callsSucceeded.inc();
            return result;
        }
        catch (Exception e) {
            if (circuitBreaker.failOn.length > 0 && Stream.of(circuitBreaker.failOn).anyMatch(it -> it.isInstance(e) || it.isInstance(e.getCause()))) {
                circuitBreaker.onFailure();
            } else {
                circuitBreaker.callsSucceeded.inc();
            }
            throw e;
        }
    }

    private static long now() {
        return System.nanoTime();
    }

    private static class CheckIntervalData {
        private final int length;
        private final Boolean[] states;
        private final long checkIntervalStart;

        CheckIntervalData(int length, Boolean[] states, long intervalStart) {
            this.length = length;
            this.states = states;
            this.checkIntervalStart = intervalStart;
        }

        private CheckIntervalData success() {
            return new CheckIntervalData(this.length, this.nextArray(true), this.checkIntervalStart);
        }

        private CheckIntervalData failure() {
            return new CheckIntervalData(this.length, this.nextArray(false), this.checkIntervalStart);
        }

        private Boolean[] nextArray(boolean value) {
            Boolean[] array = new Boolean[Math.min(this.length, this.states.length + 1)];
            if (this.states.length > 0) {
                if (this.states.length < array.length) {
                    System.arraycopy(this.states, 0, array, 0, this.states.length);
                } else {
                    System.arraycopy(this.states, 1, array, 0, this.states.length - 1);
                }
            }
            array[array.length - 1] = value;
            return array;
        }

        public String toString() {
            return "CheckIntervalData{states=" + Arrays.asList(this.states) + ", checkIntervalStart=" + this.checkIntervalStart + '}';
        }
    }

    public static class CircuitBreakerImpl {
        private static final Boolean[] EMPTY_ARRAY = new Boolean[0];
        private static final Boolean[] FIRST_SUCCESS_ARRAY = new Boolean[]{Boolean.TRUE};
        private static final Boolean[] FIRST_FAILURE_ARRAY = new Boolean[]{Boolean.FALSE};
        private final boolean disabled;
        private final AtomicReference<State> state = new AtomicReference<State>(State.CLOSED);
        private final AtomicReference<CheckIntervalData> checkIntervalData;
        private final int volumeThreshold;
        private final long delay;
        private final int successThreshold;
        private final double failureRatio;
        private final Class<? extends Throwable>[] failOn;
        private final AtomicLong openDuration = new AtomicLong();
        private final FaultToleranceMetrics.Counter callsSucceeded;
        private final FaultToleranceMetrics.Counter callsFailed;
        private final FaultToleranceMetrics.Counter callsPrevented;
        private final AtomicLong halfOpenDuration = new AtomicLong();
        private final AtomicLong closedDuration = new AtomicLong();
        private final FaultToleranceMetrics.Counter opened;

        CircuitBreakerImpl(boolean disabled, int volumeThreshold, long delay, int successThreshold, Class<? extends Throwable>[] failOn, double failureRatio, FaultToleranceMetrics.Counter callsSucceeded, FaultToleranceMetrics.Counter callsFailed, FaultToleranceMetrics.Counter callsPrevented, FaultToleranceMetrics.Counter opened) {
            this.disabled = disabled;
            this.checkIntervalData = new AtomicReference<CheckIntervalData>(new CheckIntervalData(volumeThreshold, EMPTY_ARRAY, 0L));
            this.volumeThreshold = volumeThreshold;
            this.delay = delay;
            this.successThreshold = successThreshold;
            this.failOn = failOn;
            this.failureRatio = failureRatio;
            this.callsSucceeded = callsSucceeded;
            this.callsFailed = callsFailed;
            this.callsPrevented = callsPrevented;
            this.opened = opened;
        }

        private void onSuccess() {
            this.performStateCheck(CheckType.SUCCESS);
        }

        private void onFailure() {
            this.performStateCheck(CheckType.FAILURE);
            this.callsFailed.inc();
        }

        private CheckResult performStateCheck(CheckType type) {
            long time;
            State currentState;
            CheckIntervalData nextData;
            CheckIntervalData currentData;
            do {
                time = CircuitBreakerInterceptor.now();
                currentState = this.state.get();
            } while (!this.updateCheckIntervalData(currentData = this.checkIntervalData.get(), nextData = this.nextCheckIntervalData(type, currentData, currentState, time)));
            State newState = currentState.isStateTransition(this, currentData, nextData);
            if (newState != currentState) {
                this.state.compareAndSet(currentState, newState);
                this.checkIntervalData.set(new CheckIntervalData(this.volumeThreshold, EMPTY_ARRAY, CircuitBreakerInterceptor.now()));
                return newState != State.OPEN ? CheckResult.CLOSED_CHANGED : CheckResult.OPEN;
            }
            return newState != State.OPEN ? CheckResult.CLOSED : CheckResult.OPEN;
        }

        private boolean updateCheckIntervalData(CheckIntervalData currentData, CheckIntervalData nextData) {
            return currentData == nextData || this.checkIntervalData.compareAndSet(currentData, nextData);
        }

        private CheckIntervalData nextCheckIntervalData(CheckType type, CheckIntervalData currentData, State currentState, long time) {
            if (currentState.isCheckIntervalFinished(this, currentData, time)) {
                return this.toNewData(type, time);
            }
            switch (type) {
                case FAILURE: {
                    return currentData.failure();
                }
                case SUCCESS: {
                    return currentData.success();
                }
                case READ_ONLY: {
                    return currentData;
                }
            }
            throw new IllegalArgumentException("unknown type " + (Object)((Object)type));
        }

        private CheckIntervalData toNewData(CheckType type, long time) {
            switch (type) {
                case FAILURE: {
                    return new CheckIntervalData(this.volumeThreshold, FIRST_FAILURE_ARRAY, time);
                }
                case SUCCESS: {
                    return new CheckIntervalData(this.volumeThreshold, FIRST_SUCCESS_ARRAY, time);
                }
                case READ_ONLY: {
                    return new CheckIntervalData(this.volumeThreshold, EMPTY_ARRAY, time);
                }
            }
            throw new IllegalArgumentException("unknown type " + (Object)((Object)type));
        }
    }

    private static enum CheckResult {
        OPEN,
        CLOSED_CHANGED,
        CLOSED;

    }

    @ApplicationScoped
    public static class Cache {
        private final Map<Key, CircuitBreakerImpl> circuitBreakers = new ConcurrentHashMap<Key, CircuitBreakerImpl>();
        @Inject
        private AnnotationFinder finder;
        @Inject
        private ConfigurationMapper mapper;
        @Inject
        private FaultToleranceMetrics metrics;
        @Inject
        private UnwrappedCache unwrappedCache;

        public UnwrappedCache getUnwrappedCache() {
            return this.unwrappedCache;
        }

        public Map<Key, CircuitBreakerImpl> getCircuitBreakers() {
            return this.circuitBreakers;
        }

        public CircuitBreakerImpl create(InvocationContext context) {
            CircuitBreaker definition = this.mapper.map(this.finder.findAnnotation(CircuitBreaker.class, context), context.getMethod(), CircuitBreaker.class);
            long delay = definition.delayUnit().getDuration().toNanos() * definition.delay();
            if (delay < 0L) {
                throw new FaultToleranceDefinitionException("CircuitBreaker delay can't be < 0");
            }
            Class[] failOn = definition.failOn();
            double failureRatio = definition.failureRatio();
            if (failureRatio < 0.0 || failureRatio > 1.0) {
                throw new FaultToleranceDefinitionException("CircuitBreaker failure ratio can't be < 0 and > 1");
            }
            int volumeThreshold = definition.requestVolumeThreshold();
            if (volumeThreshold < 1) {
                throw new FaultToleranceDefinitionException("CircuitBreaker volume threshold can't be < 0");
            }
            int successThreshold = definition.successThreshold();
            if (successThreshold <= 0) {
                throw new FaultToleranceDefinitionException("CircuitBreaker success threshold can't be <= 0");
            }
            String metricsNameBase = this.getBaseMetricsName(context);
            return new CircuitBreakerImpl(!this.mapper.isEnabled(context.getMethod(), CircuitBreaker.class), volumeThreshold, delay, successThreshold, failOn, failureRatio, this.metrics.counter(metricsNameBase + "callsSucceeded.total", "Number of calls allowed to run by the circuit breaker that returned successfully"), this.metrics.counter(metricsNameBase + "callsFailed.total", "Number of calls allowed to run by the circuit breaker that then failed"), this.metrics.counter(metricsNameBase + "callsPrevented.total", "Number of calls prevented from running by an open circuit breaker"), this.metrics.counter(metricsNameBase + "opened.total", "Number of times the circuit breaker has moved from closed state to open state"));
        }

        private String getBaseMetricsName(InvocationContext context) {
            return "ft." + context.getMethod().getDeclaringClass().getCanonicalName() + "." + context.getMethod().getName() + ".circuitbreaker.";
        }

        public void postCreate(CircuitBreakerImpl circuitBreaker, InvocationContext context) {
            String metricsNameBase = this.getBaseMetricsName(context);
            this.metrics.gauge(metricsNameBase + "open.total", "Amount of time the circuit breaker has spent in open state", "nanoseconds", circuitBreaker.openDuration::get);
            this.metrics.gauge(metricsNameBase + "halfOpen.total", "Amount of time the circuit breaker has spent in half-open state", "nanoseconds", circuitBreaker.halfOpenDuration::get);
            this.metrics.gauge(metricsNameBase + "closed.total", "Amount of time the circuit breaker has spent in closed state", "nanoseconds", circuitBreaker.closedDuration::get);
        }
    }

    private static enum State {
        CLOSED{

            @Override
            public State isStateTransition(CircuitBreakerImpl breaker, CheckIntervalData currentData, CheckIntervalData nextData) {
                long now = CircuitBreakerInterceptor.now();
                double currentFailureRatio = this.getCurrentFailureRatio(nextData);
                breaker.closedDuration.set(now - currentData.checkIntervalStart);
                if (nextData.states.length >= breaker.volumeThreshold && currentFailureRatio >= breaker.failureRatio) {
                    breaker.opened.inc();
                    return OPEN;
                }
                return this;
            }

            private double getCurrentFailureRatio(CheckIntervalData data) {
                return data.states.length == 0 ? 0.0 : (double)Stream.of(data.states).filter(it -> it == false).count() / (1.0 * (double)data.states.length);
            }
        }
        ,
        HALF_OPEN{

            @Override
            public State isStateTransition(CircuitBreakerImpl breaker, CheckIntervalData currentData, CheckIntervalData nextData) {
                breaker.halfOpenDuration.set(CircuitBreakerInterceptor.now() - currentData.checkIntervalStart);
                if (Stream.of(nextData.states).anyMatch(it -> it == false)) {
                    return OPEN;
                }
                long successes = Stream.of(nextData.states).filter(it -> it).count();
                if (successes == (long)nextData.states.length && successes >= (long)breaker.successThreshold) {
                    return CLOSED;
                }
                return this;
            }
        }
        ,
        OPEN{

            @Override
            public State isStateTransition(CircuitBreakerImpl breaker, CheckIntervalData currentData, CheckIntervalData nextData) {
                breaker.openDuration.set(CircuitBreakerInterceptor.now() - currentData.checkIntervalStart);
                if (nextData.checkIntervalStart != currentData.checkIntervalStart) {
                    return breaker.successThreshold == 1 ? CLOSED : HALF_OPEN;
                }
                if (Stream.of(nextData.states).filter(it -> it).count() > (long)breaker.successThreshold) {
                    return breaker.successThreshold == 1 ? CLOSED : HALF_OPEN;
                }
                return this;
            }
        };


        private boolean isCheckIntervalFinished(CircuitBreakerImpl breaker, CheckIntervalData currentData, long now) {
            return now - currentData.checkIntervalStart > breaker.delay;
        }

        public abstract State isStateTransition(CircuitBreakerImpl var1, CheckIntervalData var2, CheckIntervalData var3);
    }

    private static enum CheckType {
        READ_ONLY,
        FAILURE,
        SUCCESS;

    }
}

