/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.asynchronous;

import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.safeguard.impl.interceptor.IdGeneratorInterceptor;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public abstract class BaseAsynchronousInterceptor
implements Serializable {
    protected abstract Executor getExecutor(InvocationContext var1);

    protected Object around(InvocationContext context) {
        Class<?> returnType = context.getMethod().getReturnType();
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            ExtendedCompletableFuture<Object> future = this.newCompletableFuture(context);
            this.getExecutor(context).execute(() -> {
                try {
                    future.before();
                    Object proceed = context.proceed();
                    CompletionStage stage = (CompletionStage)CompletionStage.class.cast(proceed);
                    stage.handle((r, e) -> {
                        future.after();
                        if (e != null) {
                            Optional.ofNullable(BaseAsynchronousInterceptor.getErrorHandler(context.getContextData())).map(eh -> {
                                if (Exception.class.isInstance(e)) {
                                    try {
                                        eh.apply(Exception.class.cast(e));
                                    }
                                    catch (Exception e1) {
                                        future.completeExceptionally(e1);
                                    }
                                } else {
                                    future.completeExceptionally((Throwable)e);
                                }
                                return true;
                            }).orElseGet(() -> future.completeExceptionally((Throwable)e));
                        } else {
                            future.complete(r);
                        }
                        return null;
                    });
                }
                catch (Exception e2) {
                    future.completeExceptionally(e2);
                }
            });
            return future;
        }
        if (Future.class.isAssignableFrom(returnType)) {
            FutureWrapper<Object> facade = this.newFuture(context, context.getContextData());
            this.getExecutor(context).execute(() -> {
                try {
                    facade.before();
                    Object proceed = context.proceed();
                    facade.setDelegate((Future)Future.class.cast(proceed));
                }
                catch (Exception e) {
                    CompletableFuture failingFuture = new CompletableFuture();
                    failingFuture.completeExceptionally(e);
                    facade.setDelegate(failingFuture);
                }
            });
            return facade;
        }
        throw new FaultToleranceDefinitionException("Unsupported return type: " + returnType + " (from: " + context.getMethod() + ").Should be Future or CompletionStage.");
    }

    private static ErrorHandler<Exception, Future<?>> getErrorHandler(Map<String, Object> contextData) {
        return (ErrorHandler)ErrorHandler.class.cast(contextData.get(BaseFuture.class.getName() + ".errorHandler_" + contextData.get(IdGeneratorInterceptor.class.getName())));
    }

    protected FutureWrapper<Object> newFuture(InvocationContext context, Map<String, Object> data) {
        return new FutureWrapper<Object>(data);
    }

    protected ExtendedCompletableFuture<Object> newCompletableFuture(InvocationContext context) {
        return new ExtendedCompletableFuture<Object>();
    }

    public static class FutureWrapper<T>
    implements Future<T>,
    BaseFuture {
        private final AtomicReference<Future<T>> delegate = new AtomicReference();
        private final AtomicReference<Consumer<Future<T>>> cancelled = new AtomicReference();
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Map<String, Object> data;

        public FutureWrapper(Map<String, Object> data) {
            this.data = data;
        }

        public void setDelegate(Future<T> delegate) {
            Consumer<Future<Future<T>>> cancelledTask = this.cancelled.get();
            if (cancelledTask != null) {
                cancelledTask.accept(delegate);
            }
            this.after();
            this.delegate.set(delegate);
            this.latch.countDown();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled.set(f -> f.cancel(mayInterruptIfRunning));
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get() != null;
        }

        @Override
        public boolean isDone() {
            Future<T> future = this.delegate.get();
            return future != null && future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.latch.await();
            Future<T> future = this.delegate.get();
            try {
                return future.get();
            }
            catch (ExecutionException ee) {
                Future<T> newFuture = this.onException(ee);
                this.delegate.set(newFuture);
                return newFuture.get();
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long latchWaitStart = System.nanoTime();
            boolean latchWait = this.latch.await(timeout, unit);
            long latchWaitDuration = System.nanoTime() - latchWaitStart;
            if (!latchWait) {
                throw new TimeoutException();
            }
            try {
                return this.delegate.get().get(unit.toNanos(timeout) - latchWaitDuration, TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException ee) {
                this.delegate.set(this.onException(ee));
                long duration = unit.toNanos(timeout) - (System.nanoTime() - latchWaitDuration);
                if (duration < 0L) {
                    throw new TimeoutException();
                }
                return this.delegate.get().get(duration, TimeUnit.NANOSECONDS);
            }
        }

        protected Future<T> onException(Throwable cause) throws ExecutionException {
            if (!Exception.class.isInstance(cause)) {
                if (Error.class.isInstance(cause)) {
                    throw (Error)Error.class.cast(cause);
                }
                throw new IllegalStateException(cause);
            }
            Exception ex = (Exception)Exception.class.cast(cause);
            ErrorHandler handler = BaseAsynchronousInterceptor.getErrorHandler(this.data);
            if (handler != null) {
                try {
                    return (Future)handler.apply(ex);
                }
                catch (Exception e) {
                    if (ExecutionException.class.isInstance(e)) {
                        throw (ExecutionException)ExecutionException.class.cast(e);
                    }
                    if (RuntimeException.class.isInstance(e)) {
                        throw (RuntimeException)RuntimeException.class.cast(e);
                    }
                    if (Error.class.isInstance(e)) {
                        throw (Error)Error.class.cast(e);
                    }
                    throw new IllegalStateException(e);
                }
            }
            if (ExecutionException.class.isInstance(cause)) {
                throw (ExecutionException)ExecutionException.class.cast(cause);
            }
            if (RuntimeException.class.isInstance(cause)) {
                throw (RuntimeException)RuntimeException.class.cast(cause);
            }
            throw new IllegalStateException(cause);
        }
    }

    public static class ExtendedCompletableFuture<T>
    extends CompletableFuture<T>
    implements BaseFuture {
    }

    public static interface BaseFuture {
        default public void before() {
        }

        default public void after() {
        }
    }

    @FunctionalInterface
    public static interface ErrorHandler<A, B> {
        public B apply(A var1) throws Exception;
    }
}

