/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.impl.ConfigurableImpl;
import org.apache.cxf.jaxrs.impl.FeatureContextImpl;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.impl.ResourceInfoImpl;
import org.apache.cxf.jaxrs.impl.WebApplicationExceptionMapper;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.BeanParamInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.nio.NioMessageBodyWriter;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerConfigurableFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public final class ServerProviderFactory
extends ProviderFactory {
    private static final String WADL_PROVIDER_NAME = "org.apache.cxf.jaxrs.model.wadl.WadlGenerator";
    private static final String MAKE_DEFAULT_WAE_LEAST_SPECIFIC = "default.wae.mapper.least.specific";
    private List<ProviderInfo<ExceptionMapper<?>>> exceptionMappers = new ArrayList(1);
    private List<ProviderInfo<ContainerRequestFilter>> preMatchContainerRequestFilters = new ArrayList<ProviderInfo<ContainerRequestFilter>>(1);
    private Map<ProviderFactory.NameKey, ProviderInfo<ContainerRequestFilter>> postMatchContainerRequestFilters = new ProviderFactory.NameKeyMap<ProviderInfo<ContainerRequestFilter>>(true);
    private Map<ProviderFactory.NameKey, ProviderInfo<ContainerResponseFilter>> containerResponseFilters = new ProviderFactory.NameKeyMap<ProviderInfo<ContainerResponseFilter>>(false);
    private RequestPreprocessor requestPreprocessor;
    private ApplicationInfo application;
    private Set<DynamicFeature> dynamicFeatures = new LinkedHashSet<DynamicFeature>();
    private Map<Class<?>, BeanParamInfo> beanParams = new ConcurrentHashMap();
    private ProviderInfo<ContainerRequestFilter> wadlGenerator;

    private ServerProviderFactory(Bus bus) {
        super(bus);
        this.wadlGenerator = ServerProviderFactory.createWadlGenerator(bus);
    }

    private static ProviderInfo<ContainerRequestFilter> createWadlGenerator(Bus bus) {
        Object provider = ServerProviderFactory.createProvider(WADL_PROVIDER_NAME, bus);
        if (provider == null) {
            return null;
        }
        return new ProviderInfo<ContainerRequestFilter>((ContainerRequestFilter)provider, bus, true);
    }

    public static ServerProviderFactory getInstance() {
        return ServerProviderFactory.createInstance(null);
    }

    public static ServerProviderFactory createInstance(Bus bus) {
        if (bus == null) {
            bus = BusFactory.getThreadDefaultBus();
        }
        ServerProviderFactory factory = new ServerProviderFactory(bus);
        ProviderFactory.initFactory(factory);
        factory.setProviders(false, false, new WebApplicationExceptionMapper(), new NioMessageBodyWriter());
        factory.setBusProviders();
        return factory;
    }

    public static ServerProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        return (ServerProviderFactory)e.get((Object)"org.apache.cxf.jaxrs.provider.ServerProviderFactory");
    }

    public List<ProviderInfo<ContainerRequestFilter>> getPreMatchContainerRequestFilters() {
        return this.getContainerRequestFilters(this.preMatchContainerRequestFilters, true);
    }

    public List<ProviderInfo<ContainerRequestFilter>> getPostMatchContainerRequestFilters(Set<String> names) {
        return ServerProviderFactory.getBoundFilters(this.postMatchContainerRequestFilters, names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProviderInfo<ContainerRequestFilter>> getContainerRequestFilters(List<ProviderInfo<ContainerRequestFilter>> filters, boolean syncNeeded) {
        if (this.wadlGenerator == null) {
            return filters;
        }
        if (filters.isEmpty()) {
            return Collections.singletonList(this.wadlGenerator);
        }
        if (!syncNeeded) {
            filters.add(0, this.wadlGenerator);
            return filters;
        }
        List<ProviderInfo<ContainerRequestFilter>> list = filters;
        synchronized (list) {
            if (filters.get(0) != this.wadlGenerator) {
                filters.add(0, this.wadlGenerator);
            }
        }
        return filters;
    }

    public List<ProviderInfo<ContainerResponseFilter>> getContainerResponseFilters(Set<String> names) {
        return ServerProviderFactory.getBoundFilters(this.containerResponseFilters, names);
    }

    public void addBeanParamInfo(BeanParamInfo bpi) {
        this.beanParams.put(bpi.getResourceClass(), bpi);
        for (Method method : bpi.getResourceClass().getMethods()) {
            if (method.getAnnotation(BeanParam.class) == null) continue;
            BeanParamInfo methodBpi = new BeanParamInfo(method.getParameterTypes()[0], this.getBus());
            this.addBeanParamInfo(methodBpi);
        }
        for (AccessibleObject accessibleObject : bpi.getResourceClass().getDeclaredFields()) {
            if (((Field)accessibleObject).getAnnotation(BeanParam.class) == null) continue;
            BeanParamInfo fieldBpi = new BeanParamInfo(((Field)accessibleObject).getType(), this.getBus());
            this.addBeanParamInfo(fieldBpi);
        }
    }

    public BeanParamInfo getBeanParamInfo(Class<?> beanClass) {
        return this.beanParams.get(beanClass);
    }

    public <T extends Throwable> ExceptionMapper<T> createExceptionMapper(Class<?> exceptionType, Message m) {
        boolean makeDefaultWaeLeastSpecific = MessageUtils.getContextualBoolean((Message)m, (String)MAKE_DEFAULT_WAE_LEAST_SPECIFIC, (boolean)false);
        return this.exceptionMappers.stream().filter(em -> this.handleMapper(em, exceptionType, m, ExceptionMapper.class, Throwable.class, true)).sorted(new ExceptionProviderInfoComparator(exceptionType, makeDefaultWaeLeastSpecific)).map(ProviderInfo::getProvider).findFirst().orElse(null);
    }

    @Override
    protected void setProviders(boolean custom, boolean busGlobal, Object ... providers) {
        LinkedList<Object> allProviders = new LinkedList<Object>();
        for (Object p : providers) {
            if (p instanceof Feature) {
                FeatureContext featureContext = this.createServerFeatureContext();
                Feature feature = (Feature)p;
                this.injectApplicationIntoFeature(feature);
                feature.configure(featureContext);
                Configuration cfg = featureContext.getConfiguration();
                for (Object featureProvider : cfg.getInstances()) {
                    Map contracts = cfg.getContracts(featureProvider.getClass());
                    if (contracts != null && !contracts.isEmpty()) {
                        Class providerCls = ClassHelper.getRealClass((Bus)this.getBus(), featureProvider);
                        allProviders.add(new FilterProviderInfo(featureProvider.getClass(), providerCls, featureProvider, this.getBus(), ServerProviderFactory.getFilterNameBindings(this.getBus(), featureProvider), false, contracts));
                        continue;
                    }
                    allProviders.add(featureProvider);
                }
                continue;
            }
            allProviders.add(p);
        }
        LinkedList<ProviderInfo<ContainerRequestFilter>> postMatchRequestFilters = new LinkedList<ProviderInfo<ContainerRequestFilter>>();
        LinkedList postMatchResponseFilters = new LinkedList();
        List<ProviderInfo<? extends Object>> theProviders = this.prepareProviders(custom, busGlobal, allProviders.toArray(), this.application);
        super.setCommonProviders(theProviders);
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class providerCls;
            if (ServerProviderFactory.filterContractSupported(provider, providerCls = ClassHelper.getRealClass((Bus)this.getBus(), (Object)provider.getProvider()), ContainerRequestFilter.class)) {
                this.addContainerRequestFilter(postMatchRequestFilters, provider);
            }
            if (ServerProviderFactory.filterContractSupported(provider, providerCls, ContainerResponseFilter.class)) {
                postMatchResponseFilters.add(provider);
            }
            if (DynamicFeature.class.isAssignableFrom(providerCls)) {
                Object feature = provider.getProvider();
                this.dynamicFeatures.add((DynamicFeature)feature);
            }
            if (!ServerProviderFactory.filterContractSupported(provider, providerCls, ExceptionMapper.class)) continue;
            this.addProviderToList(this.exceptionMappers, provider);
        }
        Collections.sort(this.preMatchContainerRequestFilters, new ProviderFactory.BindingPriorityComparator(ContainerRequestFilter.class, true));
        ServerProviderFactory.mapInterceptorFilters(this.postMatchContainerRequestFilters, postMatchRequestFilters, ContainerRequestFilter.class, true);
        ServerProviderFactory.mapInterceptorFilters(this.containerResponseFilters, postMatchResponseFilters, ContainerResponseFilter.class, false);
        this.injectContextProxies(this.exceptionMappers, this.postMatchContainerRequestFilters.values(), this.preMatchContainerRequestFilters, this.containerResponseFilters.values());
    }

    protected void injectApplicationIntoFeature(Feature feature) {
        if (this.application != null) {
            AbstractResourceInfo info = new AbstractResourceInfo(feature.getClass(), ClassHelper.getRealClass((Object)feature), true, true, this.getBus()){

                @Override
                public boolean isSingleton() {
                    return false;
                }
            };
            Method contextMethod = info.getContextMethods().get(Application.class);
            if (contextMethod != null) {
                InjectionUtils.injectThroughMethod(feature, contextMethod, this.application.getProvider());
                return;
            }
            for (Field contextField : info.getContextFields()) {
                if (Application.class != contextField.getType()) continue;
                InjectionUtils.injectContextField(info, contextField, feature, this.application.getProvider());
                break;
            }
        }
    }

    @Override
    protected void injectContextProxiesIntoProvider(ProviderInfo<?> pi) {
        this.injectContextProxiesIntoProvider(pi, this.application == null ? null : (Application)this.application.getProvider());
    }

    @Override
    protected void injectContextValues(ProviderInfo<?> pi, Message m) {
        if (m != null) {
            InjectionUtils.injectContexts(pi.getProvider(), pi, m);
            if (this.application != null && this.application.contextsAvailable()) {
                InjectionUtils.injectContexts(this.application.getProvider(), this.application, m);
            }
        }
    }

    private void addContainerRequestFilter(List<ProviderInfo<ContainerRequestFilter>> postMatchFilters, ProviderInfo<ContainerRequestFilter> p) {
        ContainerRequestFilter filter = p.getProvider();
        if (ServerProviderFactory.isWadlGenerator(filter.getClass())) {
            this.wadlGenerator = p;
        } else if (ServerProviderFactory.isPrematching(filter.getClass())) {
            this.addProviderToList(this.preMatchContainerRequestFilters, p);
        } else {
            postMatchFilters.add(p);
        }
    }

    private static boolean isWadlGenerator(Class<?> filterCls) {
        if (filterCls == null || filterCls == Object.class) {
            return false;
        }
        if (WADL_PROVIDER_NAME.equals(filterCls.getName())) {
            return true;
        }
        return ServerProviderFactory.isWadlGenerator(filterCls.getSuperclass());
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public void setApplicationProvider(ApplicationInfo app) {
        this.application = app;
    }

    public ApplicationInfo getApplicationProvider() {
        return this.application;
    }

    public void setRequestPreprocessor(RequestPreprocessor rp) {
        this.requestPreprocessor = rp;
    }

    public void clearExceptionMapperProxies() {
        this.clearProxies(this.exceptionMappers);
    }

    @Override
    public void clearProviders() {
        super.clearProviders();
        this.exceptionMappers.clear();
        this.preMatchContainerRequestFilters.clear();
        this.postMatchContainerRequestFilters.clear();
        this.containerResponseFilters.clear();
    }

    @Override
    public void clearThreadLocalProxies() {
        if (this.application != null) {
            this.application.clearThreadLocalProxies();
        }
        super.clearThreadLocalProxies();
    }

    public void applyDynamicFeatures(List<ClassResourceInfo> list) {
        if (!this.dynamicFeatures.isEmpty()) {
            for (ClassResourceInfo cri : list) {
                this.doApplyDynamicFeatures(cri);
            }
        }
    }

    @Override
    public Configuration getConfiguration(Message m) {
        return new ServerConfigurationImpl();
    }

    private void doApplyDynamicFeatures(ClassResourceInfo cri) {
        Set<OperationResourceInfo> oris = cri.getMethodDispatcher().getOperationResourceInfos();
        for (OperationResourceInfo ori : oris) {
            String nameBinding = "org.apache.cxf.filter.binding" + ori.getClassResourceInfo().getServiceClass().getName() + "." + ori.getMethodToInvoke().toString();
            for (DynamicFeature feature : this.dynamicFeatures) {
                FeatureContext featureContext = this.createServerFeatureContext();
                feature.configure((ResourceInfo)new ResourceInfoImpl(ori), featureContext);
                Configuration cfg = featureContext.getConfiguration();
                for (Object provider : cfg.getInstances()) {
                    Map contracts = cfg.getContracts(provider.getClass());
                    if (contracts == null || contracts.isEmpty()) continue;
                    Class providerCls = ClassHelper.getRealClass((Bus)this.getBus(), provider);
                    this.registerUserProvider(new FilterProviderInfo(provider.getClass(), providerCls, provider, this.getBus(), Collections.singleton(nameBinding), true, contracts));
                    ori.addNameBindings(Collections.singletonList(nameBinding));
                }
            }
        }
        Collection<ClassResourceInfo> subs = cri.getSubResources();
        for (ClassResourceInfo sub : subs) {
            if (sub == cri) continue;
            this.doApplyDynamicFeatures(sub);
        }
    }

    private FeatureContext createServerFeatureContext() {
        FeatureContextImpl featureContext = new FeatureContextImpl();
        ServerConfigurableFactory factory = (ServerConfigurableFactory)this.getBus().getExtension(ServerConfigurableFactory.class);
        ServerFeatureContextConfigurable configImpl = factory == null ? new ServerFeatureContextConfigurable(featureContext) : factory.create(featureContext);
        featureContext.setConfigurable(configImpl);
        if (this.application != null) {
            Map appProps = ((Application)this.application.getProvider()).getProperties();
            for (Map.Entry entry : appProps.entrySet()) {
                configImpl.property((String)entry.getKey(), entry.getValue());
            }
        }
        return featureContext;
    }

    protected static boolean isPrematching(Class<?> filterCls) {
        return AnnotationUtils.getClassAnnotation(filterCls, PreMatching.class) != null;
    }

    public static void clearThreadLocalProxies(Message message) {
        ServerProviderFactory.clearThreadLocalProxies(ServerProviderFactory.getInstance(message), message);
    }

    public static void clearThreadLocalProxies(ServerProviderFactory factory, Message message) {
        factory.clearThreadLocalProxies();
        ClassResourceInfo cri = (ClassResourceInfo)message.getExchange().get((Object)"root.resource.class");
        if (cri != null) {
            cri.clearThreadLocalProxies();
        }
    }

    public static void releaseRequestState(Message message) {
        ServerProviderFactory.releaseRequestState(ServerProviderFactory.getInstance(message), message);
    }

    public static void releaseRequestState(ServerProviderFactory factory, Message message) {
        Object rootProvider;
        Object rootInstance = message.getExchange().remove((Object)"service.root.instance");
        if (rootInstance != null && (rootProvider = message.getExchange().remove((Object)"service.root.provider")) != null) {
            try {
                ((ResourceProvider)rootProvider).releaseInstance(message, rootInstance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ServerProviderFactory.clearThreadLocalProxies(factory, message);
    }

    public static class ExceptionProviderInfoComparator
    extends ProviderFactory.ProviderInfoClassComparator {
        private boolean makeDefaultWaeLeastSpecific;

        public ExceptionProviderInfoComparator(Class<?> expectedCls, boolean makeDefaultWaeLeastSpecific) {
            super(expectedCls);
            this.makeDefaultWaeLeastSpecific = makeDefaultWaeLeastSpecific;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            int result;
            if (this.makeDefaultWaeLeastSpecific) {
                if (p1.getProvider() instanceof WebApplicationExceptionMapper && !p1.isCustom()) {
                    return 1;
                }
                if (p2.getProvider() instanceof WebApplicationExceptionMapper && !p2.isCustom()) {
                    return -1;
                }
            }
            if ((result = super.compare(p1, p2)) == 0) {
                result = ProviderFactory.comparePriorityStatus(p1.getProvider().getClass(), p2.getProvider().getClass());
            }
            return result;
        }
    }

    private class ServerConfigurationImpl
    implements Configuration {
        ServerConfigurationImpl() {
        }

        public Set<Class<?>> getClasses() {
            return ServerProviderFactory.this.application != null ? ((Application)ServerProviderFactory.this.application.getProvider()).getClasses() : Collections.emptySet();
        }

        public Set<Object> getInstances() {
            return ServerProviderFactory.this.application != null ? ((Application)ServerProviderFactory.this.application.getProvider()).getSingletons() : Collections.emptySet();
        }

        public boolean isEnabled(Feature f) {
            return ServerProviderFactory.this.dynamicFeatures.contains(f);
        }

        public boolean isEnabled(Class<? extends Feature> featureCls) {
            for (DynamicFeature f : ServerProviderFactory.this.dynamicFeatures) {
                if (!featureCls.isAssignableFrom(f.getClass())) continue;
                return true;
            }
            return false;
        }

        public boolean isRegistered(Object o) {
            return this.isRegistered(ServerProviderFactory.this.preMatchContainerRequestFilters, o) || this.isRegistered(ServerProviderFactory.this.postMatchContainerRequestFilters.values(), o) || this.isRegistered(ServerProviderFactory.this.containerResponseFilters.values(), o) || this.isRegistered(ServerProviderFactory.this.readerInterceptors.values(), o) || this.isRegistered(ServerProviderFactory.this.writerInterceptors.values(), o);
        }

        public boolean isRegistered(Class<?> cls) {
            return this.isRegistered(ServerProviderFactory.this.preMatchContainerRequestFilters, cls) || this.isRegistered(ServerProviderFactory.this.postMatchContainerRequestFilters.values(), cls) || this.isRegistered(ServerProviderFactory.this.containerResponseFilters.values(), cls) || this.isRegistered(ServerProviderFactory.this.readerInterceptors.values(), cls) || this.isRegistered(ServerProviderFactory.this.writerInterceptors.values(), cls);
        }

        public Map<Class<?>, Integer> getContracts(Class<?> cls) {
            HashMap map = new HashMap();
            if (this.isRegistered(cls)) {
                if (ContainerRequestFilter.class.isAssignableFrom(cls)) {
                    boolean isPreMatch = cls.getAnnotation(PreMatching.class) != null;
                    map.put(ContainerRequestFilter.class, this.getPriority(isPreMatch ? ServerProviderFactory.this.preMatchContainerRequestFilters : ServerProviderFactory.this.postMatchContainerRequestFilters.values(), cls, ContainerRequestFilter.class));
                }
                if (ContainerResponseFilter.class.isAssignableFrom(cls)) {
                    map.put(ContainerResponseFilter.class, this.getPriority(ServerProviderFactory.this.containerResponseFilters.values(), cls, ContainerResponseFilter.class));
                }
                if (WriterInterceptor.class.isAssignableFrom(cls)) {
                    map.put(WriterInterceptor.class, this.getPriority(ServerProviderFactory.this.writerInterceptors.values(), cls, WriterInterceptor.class));
                }
                if (ReaderInterceptor.class.isAssignableFrom(cls)) {
                    map.put(ReaderInterceptor.class, this.getPriority(ServerProviderFactory.this.readerInterceptors.values(), cls, ReaderInterceptor.class));
                }
            }
            return map;
        }

        public Map<String, Object> getProperties() {
            return ServerProviderFactory.this.application != null ? ServerProviderFactory.this.application.getProperties() : Collections.emptyMap();
        }

        public Object getProperty(String name) {
            return this.getProperties().get(name);
        }

        public Collection<String> getPropertyNames() {
            return this.getProperties().keySet();
        }

        public RuntimeType getRuntimeType() {
            return RuntimeType.SERVER;
        }

        private boolean isRegistered(Collection<?> list, Object o) {
            Collection list2 = CastUtils.cast(list);
            for (ProviderInfo pi : list2) {
                if (pi.getProvider() != o) continue;
                return true;
            }
            return false;
        }

        private boolean isRegistered(Collection<?> list, Class<?> cls) {
            Collection list2 = CastUtils.cast(list);
            for (ProviderInfo p : list2) {
                Class pClass = ClassHelper.getRealClass((Bus)p.getBus(), p.getProvider());
                if (!cls.isAssignableFrom(pClass)) continue;
                return true;
            }
            return false;
        }

        private Integer getPriority(Collection<?> list, Class<?> cls, Class<?> filterClass) {
            Collection list2 = CastUtils.cast(list);
            for (ProviderInfo p : list2) {
                Class pClass;
                if (!(p instanceof FilterProviderInfo) || !cls.isAssignableFrom(pClass = ClassHelper.getRealClass((Bus)p.getBus(), p.getProvider()))) continue;
                return ((FilterProviderInfo)p).getPriority(filterClass);
            }
            return 5000;
        }
    }

    private static class ServerFeatureContextConfigurable
    extends ConfigurableImpl<FeatureContext> {
        protected ServerFeatureContextConfigurable(FeatureContext mc) {
            super(mc, RuntimeType.SERVER);
        }
    }
}

