/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common.prometheus;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

public class PrometheusFormatter {
    private final Map<String, String> keyMapping = new HashMap<String, String>();
    private Predicate<String> prefixFilter = null;

    public PrometheusFormatter enableOverriding(Properties properties) {
        properties.stringPropertyNames().forEach(k -> this.keyMapping.put((String)k, properties.getProperty((String)k)));
        this.afterOverride();
        return this;
    }

    public PrometheusFormatter enableOverriding() {
        try (InputStream source = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/geronimo-metrics/prometheus-mapping.properties");){
            if (source != null) {
                Properties properties = new Properties();
                properties.load(source);
                this.enableOverriding(properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.getProperties().stringPropertyNames().stream().filter(it -> it.startsWith("geronimo.metrics.prometheus.mapping.")).forEach(k -> this.keyMapping.put(k.substring("geronimo.metrics.prometheus.mapping.".length()), System.getProperty(k)));
        this.afterOverride();
        return this;
    }

    private void afterOverride() {
        String prefix = this.keyMapping.get("geronimo.metrics.filter.prefix");
        if (prefix == null) {
            this.prefixFilter = null;
        } else {
            List prefixes = Stream.of(prefix.split(",")).map(String::trim).filter(it -> !it.isEmpty()).collect(Collectors.toList());
            Predicate<String> directPredicate = name -> prefixes.stream().anyMatch(name::startsWith);
            this.prefixFilter = name -> directPredicate.test((String)name) || directPredicate.test(this.keyMapping.getOrDefault(name, (String)name));
        }
    }

    public StringBuilder toText(MetricRegistry registry, String registryKey, Map<String, Metric> entries) {
        Map metadatas = registry.getMetadata();
        return entries.entrySet().stream().map(it -> new Entry((Metadata)metadatas.get(it.getKey()), registryKey + ':' + this.toPrometheusKey((Metadata)metadatas.get(it.getKey())), (Metric)it.getValue())).filter(it -> this.prefixFilter == null || this.prefixFilter.test(((Entry)it).prometheusKey)).map(entry -> {
            switch (((Entry)entry).metadata.getTypeRaw()) {
                case COUNTER: {
                    String key = this.toPrometheusKey(((Entry)entry).metadata);
                    return new StringBuilder().append((CharSequence)this.value(registryKey, key, ((Counter)Counter.class.cast(((Entry)entry).metric)).getCount(), ((Entry)entry).metadata));
                }
                case GAUGE: {
                    Object val = ((Gauge)Gauge.class.cast(((Entry)entry).metric)).getValue();
                    if (Number.class.isInstance(val)) {
                        String key = this.toPrometheusKey(((Entry)entry).metadata);
                        return new StringBuilder().append((CharSequence)this.value(registryKey, key, ((Number)Number.class.cast(val)).doubleValue(), ((Entry)entry).metadata));
                    }
                    return new StringBuilder();
                }
                case METERED: {
                    String keyBase = this.toPrometheus(((Entry)entry).metadata);
                    String key = keyBase + this.toUnitSuffix(((Entry)entry).metadata);
                    Meter meter = (Meter)Meter.class.cast(((Entry)entry).metric);
                    return new StringBuilder().append((CharSequence)this.value(registryKey, key + "_count", meter.getCount(), ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + "_rate_per_second", meter.getMeanRate(), ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + "_one_min_rate_per_second", meter.getOneMinuteRate(), ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + "_five_min_rate_per_second", meter.getFiveMinuteRate(), ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + "_fifteen_min_rate_per_second", meter.getFifteenMinuteRate(), ((Entry)entry).metadata));
                }
                case TIMER: {
                    String keyBase = this.toPrometheus(((Entry)entry).metadata);
                    String keyUnit = this.toUnitSuffix(((Entry)entry).metadata);
                    Timer timer = (Timer)Timer.class.cast(((Entry)entry).metric);
                    return new StringBuilder().append((CharSequence)this.type(registryKey, keyBase + keyUnit + " summary", ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + keyUnit + "_count", timer.getCount(), ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + "_rate_per_second", timer.getMeanRate(), ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + "_one_min_rate_per_second", timer.getOneMinuteRate(), ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + "_five_min_rate_per_second", timer.getFiveMinuteRate(), ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + "_fifteen_min_rate_per_second", timer.getFifteenMinuteRate(), ((Entry)entry).metadata)).append((CharSequence)this.toPrometheus(registryKey, keyBase, keyUnit, timer.getSnapshot(), ((Entry)entry).metadata));
                }
                case HISTOGRAM: {
                    String keyBase = this.toPrometheus(((Entry)entry).metadata);
                    String keyUnit = this.toUnitSuffix(((Entry)entry).metadata);
                    Histogram histogram = (Histogram)Histogram.class.cast(((Entry)entry).metric);
                    return new StringBuilder().append((CharSequence)this.type(registryKey, keyBase + keyUnit + " summary", ((Entry)entry).metadata)).append((CharSequence)this.value(registryKey, keyBase + keyUnit + "_count", histogram.getCount(), ((Entry)entry).metadata)).append((CharSequence)this.toPrometheus(registryKey, keyBase, keyUnit, histogram.getSnapshot(), ((Entry)entry).metadata));
                }
            }
            return new StringBuilder();
        }).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append);
    }

    private StringBuilder toPrometheus(String registryKey, String keyBase, String keyUnit, Snapshot snapshot, Metadata metadata) {
        Function<Map, Metadata> metaFactory = tag -> new Metadata(metadata.getName(), metadata.getDisplayName(), metadata.getDescription(), metadata.getTypeRaw(), metadata.getUnit(), Stream.concat(metadata.getTags().entrySet().stream(), tag.entrySet().stream()).map(e -> (String)e.getKey() + '=' + (String)e.getValue()).collect(Collectors.joining(",")));
        String completeKey = keyBase + keyUnit;
        return new StringBuilder().append((CharSequence)this.value(registryKey, keyBase + "_min" + keyUnit, snapshot.getMin(), metadata)).append((CharSequence)this.value(registryKey, keyBase + "_max" + keyUnit, snapshot.getMax(), metadata)).append((CharSequence)this.value(registryKey, keyBase + "_mean" + keyUnit, snapshot.getMean(), metadata)).append((CharSequence)this.value(registryKey, keyBase + "_stddev" + keyUnit, snapshot.getStdDev(), metadata)).append((CharSequence)this.value(registryKey, completeKey, snapshot.getMedian(), metaFactory.apply(Collections.singletonMap("quantile", "0.5")))).append((CharSequence)this.value(registryKey, completeKey, snapshot.get75thPercentile(), metaFactory.apply(Collections.singletonMap("quantile", "0.75")))).append((CharSequence)this.value(registryKey, completeKey, snapshot.get95thPercentile(), metaFactory.apply(Collections.singletonMap("quantile", "0.95")))).append((CharSequence)this.value(registryKey, completeKey, snapshot.get98thPercentile(), metaFactory.apply(Collections.singletonMap("quantile", "0.98")))).append((CharSequence)this.value(registryKey, completeKey, snapshot.get99thPercentile(), metaFactory.apply(Collections.singletonMap("quantile", "0.99")))).append((CharSequence)this.value(registryKey, completeKey, snapshot.get999thPercentile(), metaFactory.apply(Collections.singletonMap("quantile", "0.999"))));
    }

    private String toPrometheusKey(Metadata metadata) {
        return this.toPrometheus(metadata) + this.toUnitSuffix(metadata);
    }

    private String toUnitSuffix(Metadata metadata) {
        return metadata.getUnit().equalsIgnoreCase("none") ? "" : "_" + this.toPrometheusUnit(metadata.getUnit());
    }

    private StringBuilder value(String registryKey, String key, double value, Metadata metadata) {
        String builtKey = registryKey + ':' + key;
        return new StringBuilder().append((CharSequence)this.type(registryKey, key, metadata)).append(this.keyMapping.getOrDefault(builtKey, builtKey)).append(Optional.of(metadata.getTags()).filter(t -> !t.isEmpty()).map(t -> t.entrySet().stream().map(e -> (String)e.getKey() + "=\"" + (String)e.getValue() + "\"").collect(Collectors.joining(",", "{", "}"))).orElse("")).append(' ').append(this.toPrometheusValue(metadata.getUnit(), value)).append("\n");
    }

    private StringBuilder type(String registryKey, String key, Metadata metadata) {
        String builtKey = registryKey + ':' + key;
        StringBuilder builder = new StringBuilder().append("# TYPE ").append(this.keyMapping.getOrDefault(builtKey, builtKey));
        if (metadata != null) {
            builder.append(' ').append(metadata.getType());
        }
        return builder.append("\n");
    }

    private String toPrometheusUnit(String unit) {
        if (unit == null) {
            return null;
        }
        switch (unit) {
            case "bits": 
            case "kilobits": 
            case "megabits": 
            case "gigabits": 
            case "kibibits": 
            case "mebibits": 
            case "gibibits": 
            case "bytes": 
            case "kilobytes": 
            case "megabytes": 
            case "gigabytes": {
                return "bytes";
            }
            case "nanoseconds": 
            case "microseconds": 
            case "milliseconds": 
            case "seconds": 
            case "minutes": 
            case "hours": 
            case "days": {
                return "seconds";
            }
        }
        return unit;
    }

    private double toPrometheusValue(String unit, double value) {
        if (unit == null) {
            return value;
        }
        switch (unit) {
            case "bits": {
                return value / 8.0;
            }
            case "kilobits": {
                return value * 1000.0 / 8.0;
            }
            case "megabits": {
                return value * Math.pow(1000.0, 2.0) / 8.0;
            }
            case "gigabits": {
                return value * Math.pow(1000.0, 3.0) / 8.0;
            }
            case "kibibits": {
                return value * 128.0;
            }
            case "mebibits": {
                return value * Math.pow(1024.0, 2.0);
            }
            case "gibibits": {
                return value * Math.pow(1024.0, 3.0);
            }
            case "bytes": {
                return value;
            }
            case "kilobytes": {
                return value * 1000.0;
            }
            case "megabytes": {
                return value * Math.pow(1000.0, 2.0);
            }
            case "gigabytes": {
                return value * Math.pow(1000.0, 3.0);
            }
            case "nanoseconds": {
                return value;
            }
            case "microseconds": {
                return value / 1000.0;
            }
            case "milliseconds": {
                return value / Math.pow(1000.0, 2.0);
            }
            case "seconds": {
                return value / Math.pow(1000.0, 3.0);
            }
            case "minutes": {
                return value * 60.0 / Math.pow(1000.0, 3.0);
            }
            case "hours": {
                return value * Math.pow(60.0, 2.0) / Math.pow(1000.0, 3.0);
            }
            case "days": {
                return value * Math.pow(60.0, 2.0) * 24.0 / Math.pow(1000.0, 3.0);
            }
        }
        return value;
    }

    private String toPrometheus(Metadata metadata) {
        return metadata.getName().replaceAll("[^\\w]+", "_").replaceAll("(.)(\\p{Upper})", "$1_$2").replace("__", "_").replace(":_", ":").toLowerCase(Locale.ROOT);
    }

    private static class Entry {
        private final Metadata metadata;
        private final String prometheusKey;
        private final Metric metric;

        private Entry(Metadata metadata, String prometheusKey, Metric metric) {
            this.metadata = metadata;
            this.prometheusKey = prometheusKey;
            this.metric = metric;
        }
    }
}

