/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common.jaxrs;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SecurityValidator {
    private static final Predicate<String> LOCAL_MATCHER = it -> it.startsWith("127.") || it.startsWith("1::") || "localhost".equals(it);
    private List<Predicate<String>> acceptedHosts;
    private List<String> acceptedRoles;

    public void init() {
        this.acceptedHosts = this.config("geronimo.metrics.jaxrs.acceptedHosts", value -> {
            if ("<local>".equals(value)) {
                return LOCAL_MATCHER;
            }
            return value::equals;
        }).orElse(Collections.singletonList(LOCAL_MATCHER));
        this.acceptedRoles = this.config("geronimo.metrics.jaxrs.acceptedRoles", Function.identity()).orElse(null);
    }

    public void checkSecurity(SecurityContext securityContext, UriInfo uriInfo) {
        String host;
        if (this.acceptedHosts != null && uriInfo != null && ((host = uriInfo.getRequestUri().getHost()) == null || this.acceptedHosts.stream().noneMatch(it -> it.test(host)))) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.hasValidRole(securityContext)) {
            if (securityContext == null || securityContext.getUserPrincipal() == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasValidRole(SecurityContext securityContext) {
        if (this.acceptedRoles == null) return true;
        if (securityContext == null) return false;
        if (securityContext.getUserPrincipal() == null) return false;
        if (!this.acceptedRoles.stream().anyMatch(arg_0 -> ((SecurityContext)securityContext).isUserInRole(arg_0))) return false;
        return true;
    }

    private <T> Optional<List<T>> config(String key, Function<String, T> mapper) {
        return Optional.ofNullable(this.config(key)).map(value -> Stream.of(value.split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(mapper).collect(Collectors.toList()));
    }

    protected String config(String key) {
        return System.getProperty(key);
    }
}

