/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.common;

import jakarta.json.bind.annotation.JsonbTransient;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.function.LongSupplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public class BaseMetrics {
    private final MetricRegistry registry;

    public BaseMetrics(MetricRegistry registry) {
        this.registry = registry;
    }

    public void register() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.registry.register(new Metadata("jvm.uptime", "JVM Uptime", "Displays the start time of the Java virtual machine in milliseconds.This attribute displays the approximate time when the Java virtual machine started.", MetricType.GAUGE, "milliseconds"), this.gauge(runtimeMXBean::getUptime));
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.registry.register(new Metadata("cpu.availableProcessors", "Available Processors", "Displays the number of processors available to the Java virtual machine. This value may change during a particular invocation of the virtual machine.", MetricType.GAUGE, "none"), this.gauge(operatingSystemMXBean::getAvailableProcessors));
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        this.registry.register(new Metadata("classloader.currentLoadedClass.count", "Current Loaded Class Count", "Displays the number of classes that are currently loaded in the Java virtual machine.", MetricType.COUNTER, "none"), (Metric)this.counter(classLoadingMXBean::getLoadedClassCount));
        this.registry.register(new Metadata("classloader.totalLoadedClass.count", "Total Loaded Class Count", "Displays the total number of classes that have been loaded since the Java virtual machine has started execution.", MetricType.COUNTER, "none"), (Metric)this.counter(classLoadingMXBean::getTotalLoadedClassCount));
        this.registry.register(new Metadata("classloader.totalUnloadedClass.count", "Total Unloaded Loaded Class Count", "Displays the total number of classes unloaded since the Java virtual machine has started execution.", MetricType.COUNTER, "none"), (Metric)this.counter(classLoadingMXBean::getTotalLoadedClassCount));
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        this.registry.register(new Metadata("thread.count", "Thread Count", "Displays the current number of live threads including both daemon and non-daemon threads", MetricType.COUNTER, "none"), (Metric)this.counter(threadMXBean::getThreadCount));
        this.registry.register(new Metadata("thread.daemon.count", "Daemon Thread Count", "Displays the current number of live daemon threads.", MetricType.COUNTER, "none"), (Metric)this.counter(threadMXBean::getDaemonThreadCount));
        this.registry.register(new Metadata("thread.max.count", "Peak Thread Count", "Displays the peak live thread count since the Java virtual machine started or peak was reset.This includes daemon and non-daemon threads.", MetricType.COUNTER, "none"), (Metric)this.counter(threadMXBean::getPeakThreadCount));
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.registry.register(new Metadata("memory.usedHeap", "Used Heap Memory", "Displays the amount of used heap memory in bytes.", MetricType.GAUGE, "bytes"), this.gauge(memoryMXBean.getHeapMemoryUsage()::getUsed));
        this.registry.register(new Metadata("memory.committedHeap", "Committed Heap Memory", "Displays the amount of memory in bytes that is committed for the Java virtual machine to use. This amount of memory is guaranteed for the Java virtual machine to use.", MetricType.GAUGE, "bytes"), this.gauge(memoryMXBean.getHeapMemoryUsage()::getCommitted));
        this.registry.register(new Metadata("memory.maxHeap", "Max Heap Memory", "Displays the maximum amount of heap memory in bytes that can be used for memory management. This attribute displays -1 if the maximum heap memory size is undefined. This amount of memory is not guaranteed to be available for memory management if it is greater than the amount of committed memory. The Java virtual machine may fail to allocate memory even if the amount of used memory does not exceed this maximum size.", MetricType.GAUGE, "bytes"), this.gauge(memoryMXBean.getHeapMemoryUsage()::getMax));
        ManagementFactory.getGarbageCollectorMXBeans().forEach(garbageCollectorMXBean -> {
            this.registry.register(new Metadata(String.format("gc.%s.count", garbageCollectorMXBean.getName()), "Garbage Collection Count", "Displays the total number of collections that have occurred.This attribute lists -1 if the collection count is undefined for this collector.", MetricType.COUNTER, "none"), (Metric)this.counter(garbageCollectorMXBean::getCollectionCount));
            this.registry.register(new Metadata(String.format("gc.%s.time", garbageCollectorMXBean.getName()), "Garbage Collection Time", "Displays the approximate accumulated collection elapsed time in milliseconds.This attribute displays -1 if the collection elapsed time is undefined for this collector.The Java virtual machine implementation may use a high resolution timer to measure the elapsed time.This attribute may display the same value even if the collection count has been incremented ifthe collection elapsed time is very short.", MetricType.GAUGE, "milliseconds"), this.gauge(garbageCollectorMXBean::getCollectionTime));
        });
    }

    private Gauge<Long> gauge(final LongSupplier supplier) {
        return new Gauge<Long>(){

            @JsonbTransient
            public Long getValue() {
                return supplier.getAsLong();
            }
        };
    }

    private Counter counter(final LongSupplier supplier) {
        return new Counter(){

            public void inc() {
            }

            public void inc(long n) {
            }

            public void dec() {
                this.dec(1L);
            }

            public void dec(long n) {
            }

            public long getCount() {
                return supplier.getAsLong();
            }
        };
    }
}

