/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.webapp;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.ValueBinding;
import jakarta.faces.webapp.UIComponentTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;

public class AttributeTag
extends TagSupport {
    private static final long serialVersionUID = 3147657100171678632L;
    private String _name;
    private String _value;

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public int doStartTag() throws JspException {
        Object value;
        UIComponentTag componentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        if (componentTag == null) {
            throw new JspException("no parent UIComponentTag found");
        }
        UIComponent component = componentTag.getComponentInstance();
        if (component == null) {
            throw new JspException("parent UIComponentTag has no UIComponent");
        }
        String name = this.getName();
        if (component.getAttributes().get(name) == null && (value = this.getValue()) != null) {
            component.getAttributes().put(name, value);
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.release();
        return 6;
    }

    public void release() {
        super.release();
        this._name = null;
        this._value = null;
    }

    private String getName() {
        if (UIComponentTag.isValueReference(this._name)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ValueBinding vb = facesContext.getApplication().createValueBinding(this._name);
            return (String)vb.getValue(facesContext);
        }
        return this._name;
    }

    private Object getValue() {
        if (UIComponentTag.isValueReference(this._value)) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ValueBinding vb = facesContext.getApplication().createValueBinding(this._value);
            return vb.getValue(facesContext);
        }
        return this._value;
    }
}

