/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.credential.BasicAuthenticationCredential;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;

@ApplicationScoped
public class BasicAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    private IdentityStoreHandler identityStoreHandler;

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        try {
            BasicAuthenticationCredential credential = this.parseAuthenticationHeader(request.getHeader("Authorization"));
            CredentialValidationResult result = this.identityStoreHandler.validate((Credential)credential);
            if (result.getStatus().equals((Object)CredentialValidationResult.Status.VALID)) {
                return httpMessageContext.notifyContainerAboutLogin(result);
            }
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        if (httpMessageContext.isProtected()) {
            response.setHeader("WWW-Authenticate", "Basic");
            return httpMessageContext.responseUnauthorized();
        }
        return httpMessageContext.doNothing();
    }

    private BasicAuthenticationCredential parseAuthenticationHeader(String authenticationHeader) {
        return Optional.ofNullable(authenticationHeader).filter(header -> !header.isEmpty()).filter(header -> header.startsWith("Basic ")).map(header -> header.substring(6)).map(BasicAuthenticationCredential::new).orElseGet(() -> new BasicAuthenticationCredential(""));
    }
}

