/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.JoseJaxrsUtils;
import org.apache.cxf.rs.security.jose.jwe.JweCompactBuilder;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweOutputStream;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

@Priority(value=1001)
public class JweWriterInterceptor
implements WriterInterceptor {
    protected static final Logger LOG = LogUtils.getL7dLogger(JweWriterInterceptor.class);
    private Set<String> protectedHttpHeaders;
    private boolean protectHttpHeaders;
    private JweEncryptionProvider encryptionProvider;
    private boolean contentTypeRequired = true;
    private boolean useJweOutputStream;

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        OutputStream actualOs = ctx.getOutputStream();
        JweHeaders jweHeaders = new JweHeaders();
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider(jweHeaders);
        String ctString = null;
        MediaType contentMediaType = ctx.getMediaType();
        if (this.contentTypeRequired && contentMediaType != null) {
            ctString = "application".equals(contentMediaType.getType()) ? contentMediaType.getSubtype() : JAXRSUtils.mediaTypeToString((MediaType)contentMediaType, (String[])new String[0]);
        }
        if (ctString != null) {
            jweHeaders.setContentType(ctString);
        }
        this.protectHttpHeadersIfNeeded(ctx, jweHeaders);
        if (this.useJweOutputStream) {
            JweOutputStream jweOutputStream;
            JweEncryptionOutput encryption = theEncryptionProvider.getEncryptionOutput(new JweEncryptionInput(jweHeaders));
            JoseUtils.traceHeaders((JoseHeaders)encryption.getHeaders());
            try {
                JweCompactBuilder.startJweContent((OutputStream)actualOs, (JweHeaders)encryption.getHeaders(), (byte[])encryption.getEncryptedContentEncryptionKey(), (byte[])encryption.getIv());
            }
            catch (IOException ex) {
                LOG.warning("JWE encryption error");
                throw new JweException(JweException.Error.CONTENT_ENCRYPTION_FAILURE, (Throwable)ex);
            }
            Object wrappedStream = null;
            wrappedStream = jweOutputStream = new JweOutputStream(actualOs, encryption.getCipher(), encryption.getAuthTagProducer());
            if (encryption.isCompressionSupported()) {
                wrappedStream = new DeflaterOutputStream((OutputStream)jweOutputStream);
            }
            ctx.setOutputStream((OutputStream)wrappedStream);
            ctx.proceed();
            this.setJoseMediaType(ctx);
            jweOutputStream.finalFlush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            String jweContent = theEncryptionProvider.encrypt(cos.getBytes(), jweHeaders);
            JoseUtils.traceHeaders((JoseHeaders)jweHeaders);
            this.setJoseMediaType(ctx);
            IOUtils.copy((InputStream)new ByteArrayInputStream(StringUtils.toBytesUTF8((String)jweContent)), (OutputStream)actualOs);
            actualOs.flush();
        }
    }

    private void setJoseMediaType(WriterInterceptorContext ctx) {
        MediaType joseMediaType = JAXRSUtils.toMediaType((String)"application/jose");
        ctx.setMediaType(joseMediaType);
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider(JweHeaders headers) {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        return JweUtils.loadEncryptionProvider((JweHeaders)headers, (boolean)true);
    }

    public void setUseJweOutputStream(boolean useJweOutputStream) {
        this.useJweOutputStream = useJweOutputStream;
    }

    public void setEncryptionProvider(JweEncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }

    protected void protectHttpHeadersIfNeeded(WriterInterceptorContext ctx, JweHeaders jweHeaders) {
        if (this.protectHttpHeaders) {
            JoseJaxrsUtils.protectHttpHeaders((MultivaluedMap<String, Object>)ctx.getHeaders(), (JoseHeaders)jweHeaders, this.protectedHttpHeaders);
        }
    }

    public void setProtectHttpHeaders(boolean protectHttpHeaders) {
        this.protectHttpHeaders = protectHttpHeaders;
    }

    public void setProtectedHttpHeaders(Set<String> protectedHttpHeaders) {
        this.protectedHttpHeaders = protectedHttpHeaders;
    }
}

