/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config;

import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.Vetoed;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.geronimo.config.DefaultConfigBuilder;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

@Typed
@Vetoed
public class DefaultConfigProvider
extends ConfigProviderResolver {
    private static Map<ClassLoader, WeakReference<Config>> configs = Collections.synchronizedMap(new WeakHashMap());

    public Config getConfig() {
        return this.getConfig(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Config getConfig(ClassLoader forClassLoader) {
        Config config = this.existingConfig(forClassLoader);
        if (config != null) return config;
        Class<DefaultConfigProvider> clazz = DefaultConfigProvider.class;
        synchronized (DefaultConfigProvider.class) {
            config = this.existingConfig(forClassLoader);
            if (config != null) return config;
            config = this.getBuilder().forClassLoader(forClassLoader).addDefaultSources().addDiscoveredSources().addDiscoveredConverters().build();
            this.registerConfig(config, forClassLoader);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return config;
        }
    }

    Config existingConfig(ClassLoader forClassLoader) {
        WeakReference<Config> configRef = configs.get(forClassLoader);
        return configRef != null ? (Config)configRef.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfig(Config config, ClassLoader forClassLoader) {
        Class<DefaultConfigProvider> clazz = DefaultConfigProvider.class;
        synchronized (DefaultConfigProvider.class) {
            configs.put(forClassLoader, new WeakReference<Config>(config));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public ConfigBuilder getBuilder() {
        return new DefaultConfigBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void releaseConfig(Config config) {
        if (config == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = DefaultConfigProvider.class.getClassLoader();
            }
            config = this.existingConfig(classLoader);
        }
        if (config == null) return;
        Class<DefaultConfigProvider> clazz = DefaultConfigProvider.class;
        synchronized (DefaultConfigProvider.class) {
            Iterator<Map.Entry<ClassLoader, WeakReference<Config>>> it = configs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ClassLoader, WeakReference<Config>> entry = it.next();
                if (entry.getValue().get() == null || entry.getValue().get() != config) continue;
                it.remove();
                break;
            }
            if (!(config instanceof AutoCloseable)) return;
            try {
                ((AutoCloseable)config).close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while closing Config", e);
            }
            return;
        }
    }
}

