/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.config;

import jakarta.enterprise.inject.Vetoed;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.geronimo.microprofile.openapi.config.GeronimoOpenAPIConfig;

@Vetoed
class DefaultOpenAPIConfig
implements GeronimoOpenAPIConfig {
    private final Map<String, String> configuration = new HashMap<String, String>();

    DefaultOpenAPIConfig() {
        System.getProperties().stringPropertyNames().forEach(k -> this.configuration.put((String)k, System.getProperty(k)));
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/geronimo/microprofile/opentracing.properties");){
            if (stream != null) {
                Properties properties = new Properties();
                properties.load(stream);
                properties.stringPropertyNames().forEach(k -> this.configuration.put((String)k, properties.getProperty((String)k)));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String read(String value, String def) {
        return this.configuration.getOrDefault(value, def);
    }
}

