/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt;

import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.microprofile.jwt.JWTLogCategories;
import org.apache.tomee.microprofile.jwt.ParseException;
import org.apache.tomee.microprofile.jwt.config.JWTAuthConfiguration;
import org.apache.tomee.microprofile.jwt.config.PublicKeyResolver;
import org.apache.tomee.microprofile.jwt.principal.JWTCallerPrincipal;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public class JsonWebTokenValidator {
    private static final Logger VALIDATION = Logger.getInstance((LogCategory)JWTLogCategories.CONSTRAINT, JsonWebTokenValidator.class);
    private final Predicate<JsonWebToken> validation;
    private final Key verificationKey;
    private final Map<String, Key> verificationKeys;
    private final String issuer;
    private boolean allowNoExpiryClaim = false;

    public JsonWebTokenValidator(Predicate<JsonWebToken> validation, Key verificationKey, String issuer, Map<String, Key> verificationKeys, boolean allowNoExpiryClaim) {
        this.validation = validation;
        this.verificationKey = verificationKey;
        this.verificationKeys = verificationKeys;
        this.issuer = issuer;
        this.allowNoExpiryClaim = allowNoExpiryClaim;
    }

    public JsonWebToken validate(String token) throws ParseException {
        JWTCallerPrincipal principal;
        JWTAuthConfiguration authConfiguration = this.verificationKey != null ? JWTAuthConfiguration.authConfiguration(this.verificationKey, this.issuer, this.allowNoExpiryClaim) : JWTAuthConfiguration.authConfiguration(this.verificationKeys, this.issuer, this.allowNoExpiryClaim);
        try {
            JwtConsumerBuilder builder = new JwtConsumerBuilder().setRelaxVerificationKeyValidation().setRequireSubject().setSkipDefaultAudienceValidation().setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256", "RS384", "RS512"}));
            if (authConfiguration.getIssuer() != null) {
                builder.setExpectedIssuer(authConfiguration.getIssuer());
            }
            if (authConfiguration.getExpGracePeriodSecs() > 0) {
                builder.setAllowedClockSkewInSeconds(authConfiguration.getExpGracePeriodSecs());
            } else {
                builder.setEvaluationTime(NumericDate.fromSeconds((long)0L));
            }
            if (authConfiguration.isSingleKey()) {
                builder.setVerificationKey(authConfiguration.getPublicKey());
            } else {
                builder.setVerificationKeyResolver((VerificationKeyResolver)new JwksVerificationKeyResolver(authConfiguration.getPublicKeys()));
            }
            JwtConsumer jwtConsumer = builder.build();
            JwtContext jwtContext = jwtConsumer.process(token);
            String type = ((JsonWebStructure)jwtContext.getJoseObjects().get(0)).getHeader("typ");
            jwtConsumer.processContext(jwtContext);
            JwtClaims claimsSet = jwtContext.getJwtClaims();
            String principalName = (String)claimsSet.getClaimValue("upn", String.class);
            if (principalName == null && (principalName = (String)claimsSet.getClaimValue("preferred_username", String.class)) == null) {
                principalName = claimsSet.getSubject();
            }
            claimsSet.setClaim(Claims.raw_token.name(), (Object)token);
            principal = new JWTCallerPrincipal(token, type, claimsSet, principalName);
        }
        catch (InvalidJwtException e) {
            VALIDATION.warning(e.getMessage());
            throw new ParseException("Failed to verify token", e);
        }
        catch (MalformedClaimException e) {
            VALIDATION.warning(e.getMessage());
            throw new ParseException("Failed to verify token claims", e);
        }
        return principal;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Predicate<JsonWebToken> validation = jsonWebToken -> true;
        private Key verificationKey;
        private List<JsonWebKey> verificationKeys;
        private String issuer;
        private boolean allowNoExpiryClaim = false;

        public Builder add(Predicate<JsonWebToken> validation) {
            this.validation = validation.and(validation);
            return this;
        }

        public Builder publicKey(String keyContent) {
            Map<String, Key> keys = new PublicKeyResolver().readPublicKeys(keyContent);
            Map.Entry<String, Key> key = keys.entrySet().iterator().next();
            return this.verificationKey(key.getValue());
        }

        public Builder verificationKey(Key key) {
            this.verificationKey = key;
            return this;
        }

        public Builder verificationKey(Map<String, Key> key) {
            this.verificationKeys = this.verificationKeys;
            return this;
        }

        public JsonWebTokenValidator build() {
            return new JsonWebTokenValidator(this.validation, this.verificationKey, this.issuer, null, this.allowNoExpiryClaim);
        }

        public Builder verificationKeys(List<JsonWebKey> keys) {
            this.verificationKeys = keys;
            return this;
        }

        public Builder issuer(String iss) {
            this.issuer = iss;
            return this;
        }

        public Builder allowNoExpiryClaim(boolean allowNoExpiryClaim) {
            this.allowNoExpiryClaim = allowNoExpiryClaim;
            return this;
        }
    }
}

