/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.server;

import io.opentracing.Tracer;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.opentracing.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.microprofile.server.OpenTracingServerRequestFilter;
import org.apache.geronimo.microprofile.opentracing.microprofile.server.OpenTracingServerResponseFilter;
import org.eclipse.microprofile.opentracing.Traced;

@Provider
@Dependent
public class GeronimoOpenTracingFeature
implements DynamicFeature {
    @Inject
    private Tracer tracer;
    @Inject
    private GeronimoOpenTracingConfig config;

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Optional<Traced> traced;
        if (this.tracer == null) {
            CDI cdi = CDI.current();
            this.tracer = (Tracer)cdi.select(Tracer.class, new Annotation[0]).get();
            this.config = (GeronimoOpenTracingConfig)cdi.select(GeronimoOpenTracingConfig.class, new Annotation[0]).get();
        }
        if (!(traced = Optional.ofNullable(Optional.ofNullable(resourceInfo.getResourceMethod().getAnnotation(Traced.class)).orElseGet(() -> resourceInfo.getResourceClass().getAnnotation(Traced.class)))).map(Traced::value).orElse(true).booleanValue()) {
            return;
        }
        String operationName = traced.map(Traced::operationName).filter(v -> !v.trim().isEmpty()).orElseGet(() -> {
            boolean usePath = Boolean.parseBoolean(this.config.read("server.filter.request.operationName.usePath", "false"));
            if (usePath) {
                String classPath = Optional.ofNullable(resourceInfo.getResourceClass().getAnnotation(Path.class)).map(Path::value).orElse("");
                String methodPath = Optional.ofNullable(resourceInfo.getResourceMethod().getAnnotation(Path.class)).map(Path::value).orElse("");
                return this.getHttpMethod(resourceInfo) + ':' + classPath + (!classPath.isEmpty() && !methodPath.isEmpty() && !classPath.endsWith("/") ? "/" : "") + methodPath;
            }
            return this.buildDefaultName(resourceInfo);
        });
        ((FeatureContext)context.register((Object)new OpenTracingServerResponseFilter())).register((Object)new OpenTracingServerRequestFilter(operationName, this.tracer, Boolean.parseBoolean(this.config.read("server.filter.request.skip." + resourceInfo.getResourceClass().getName() + "_" + resourceInfo.getResourceMethod().getName(), this.config.read("server.filter.request.skip", "false"))), Boolean.parseBoolean(this.config.read("server.filter.request.skipDefaultTags", "false"))));
    }

    private String buildDefaultName(ResourceInfo resourceInfo) {
        return this.getHttpMethod(resourceInfo) + ':' + resourceInfo.getResourceClass().getName() + "." + resourceInfo.getResourceMethod().getName();
    }

    private String getHttpMethod(ResourceInfo resourceInfo) {
        return Stream.of(resourceInfo.getResourceMethod().getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(HttpMethod.class)).findFirst().map(a -> a.annotationType().getAnnotation(HttpMethod.class).value()).orElse("");
    }
}

