/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TransactionRequiredException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.HashMap;
import java.util.Map;
import org.apache.openejb.persistence.EntityManagerAlreadyRegisteredException;
import org.apache.openejb.persistence.EntityManagerTxKey;
import org.apache.openejb.persistence.JtaEntityManager;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class JtaEntityManagerRegistry {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB.createChild("persistence"), JtaEntityManager.class);
    private final TransactionSynchronizationRegistry transactionRegistry;
    private final ThreadLocal<ExtendedRegistry> extendedRegistry = new ThreadLocal<ExtendedRegistry>(){

        @Override
        protected ExtendedRegistry initialValue() {
            return new ExtendedRegistry();
        }
    };

    public JtaEntityManagerRegistry(TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this.transactionRegistry = transactionSynchronizationRegistry;
    }

    public EntityManager getEntityManager(EntityManagerFactory entityManagerFactory, Map properties, boolean extended, String unitName, SynchronizationType synchronizationType) throws IllegalStateException {
        EntityManager entityManager;
        if (entityManagerFactory == null) {
            throw new NullPointerException("entityManagerFactory is null");
        }
        EntityManagerTxKey txKey = new EntityManagerTxKey(entityManagerFactory);
        boolean transactionActive = this.isTransactionActive();
        if (transactionActive && (entityManager = (EntityManager)this.transactionRegistry.getResource((Object)txKey)) != null) {
            return entityManager;
        }
        if (extended) {
            EntityManagerTracker entityManagerTracker = this.getInheritedEntityManager(entityManagerFactory);
            if (entityManagerTracker == null || entityManagerTracker.getEntityManager() == null) {
                throw new IllegalStateException("InternalError: an entity manager should already be registered for this extended persistence unit");
            }
            EntityManager entityManager2 = entityManagerTracker.getEntityManager();
            if (transactionActive) {
                if (entityManagerTracker.autoJoinTx) {
                    entityManager2.joinTransaction();
                }
                this.transactionRegistry.putResource((Object)txKey, (Object)entityManager2);
            }
            return entityManager2;
        }
        entityManager = synchronizationType != null ? (properties != null ? entityManagerFactory.createEntityManager(synchronizationType, properties) : entityManagerFactory.createEntityManager(synchronizationType)) : (properties != null ? entityManagerFactory.createEntityManager(properties) : entityManagerFactory.createEntityManager());
        logger.debug("Created EntityManager(unit=" + unitName + ", hashCode=" + entityManager.hashCode() + ")");
        if (transactionActive) {
            this.transactionRegistry.registerInterposedSynchronization((Synchronization)new CloseEntityManager(entityManager, unitName));
            this.transactionRegistry.putResource((Object)txKey, (Object)entityManager);
        }
        return entityManager;
    }

    public void addEntityManagers(String deploymentId, Object primaryKey, Map<EntityManagerFactory, EntityManagerTracker> entityManagers) throws EntityManagerAlreadyRegisteredException {
        this.extendedRegistry.get().addEntityManagers(new InstanceId(deploymentId, primaryKey), entityManagers);
    }

    public Map<EntityManagerFactory, EntityManagerTracker> removeEntityManagers(String deploymentId, Object primaryKey) {
        return this.extendedRegistry.get().removeEntityManagers(new InstanceId(deploymentId, primaryKey));
    }

    public EntityManagerTracker getInheritedEntityManager(EntityManagerFactory entityManagerFactory) {
        return this.extendedRegistry.get().getInheritedEntityManager(entityManagerFactory);
    }

    public void transactionStarted(String deploymentId, Object primaryKey) {
        this.extendedRegistry.get().transactionStarted(new InstanceId(deploymentId, primaryKey));
    }

    public boolean isTransactionActive() {
        int txStatus = this.transactionRegistry.getTransactionStatus();
        boolean transactionActive = txStatus == 0 || txStatus == 1;
        return transactionActive;
    }

    private static class CloseEntityManager
    implements Synchronization {
        private final EntityManager entityManager;
        private final String unitName;

        public CloseEntityManager(EntityManager entityManager, String unitName) {
            this.entityManager = entityManager;
            this.unitName = unitName;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
            this.entityManager.close();
            logger.debug("Closed EntityManager(unit=" + this.unitName + ", hashCode=" + this.entityManager.hashCode() + ")");
        }
    }

    public static class EntityManagerTracker {
        private transient int counter;
        private final EntityManager entityManager;
        private final boolean autoJoinTx;

        public EntityManagerTracker(EntityManager entityManager, boolean autoJoinTx) {
            if (entityManager == null) {
                throw new NullPointerException("entityManager is null.");
            }
            this.counter = 0;
            this.entityManager = entityManager;
            this.autoJoinTx = autoJoinTx;
        }

        public int incCounter() {
            return this.counter++;
        }

        public int decCounter() {
            return this.counter--;
        }

        public EntityManager getEntityManager() {
            return this.entityManager;
        }
    }

    private static class InstanceId {
        private final String deploymentId;
        private final Object primaryKey;

        public InstanceId(String deploymentId, Object primaryKey) {
            if (deploymentId == null) {
                throw new NullPointerException("deploymentId is null");
            }
            if (primaryKey == null) {
                throw new NullPointerException("primaryKey is null");
            }
            this.deploymentId = deploymentId;
            this.primaryKey = primaryKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstanceId that = (InstanceId)o;
            return this.deploymentId.equals(that.deploymentId) && this.primaryKey.equals(that.primaryKey);
        }

        public int hashCode() {
            int result = this.deploymentId.hashCode();
            result = 29 * result + this.primaryKey.hashCode();
            return result;
        }
    }

    private class ExtendedRegistry {
        private final Map<InstanceId, Map<EntityManagerFactory, EntityManagerTracker>> entityManagersByDeploymentId = new HashMap<InstanceId, Map<EntityManagerFactory, EntityManagerTracker>>();

        private ExtendedRegistry() {
        }

        private void addEntityManagers(InstanceId instanceId, Map<EntityManagerFactory, EntityManagerTracker> entityManagers) throws EntityManagerAlreadyRegisteredException {
            if (instanceId == null) {
                throw new NullPointerException("instanceId is null");
            }
            if (entityManagers == null) {
                throw new NullPointerException("entityManagers is null");
            }
            if (JtaEntityManagerRegistry.this.isTransactionActive()) {
                for (Map.Entry<EntityManagerFactory, EntityManagerTracker> entry : entityManagers.entrySet()) {
                    EntityManagerFactory entityManagerFactory = entry.getKey();
                    EntityManagerTracker tracker = entry.getValue();
                    EntityManager entityManager = tracker.getEntityManager();
                    EntityManagerTxKey txKey = new EntityManagerTxKey(entityManagerFactory);
                    EntityManager oldEntityManager = (EntityManager)JtaEntityManagerRegistry.this.transactionRegistry.getResource((Object)txKey);
                    if (entityManager == oldEntityManager) break;
                    if (oldEntityManager != null) {
                        throw new EntityManagerAlreadyRegisteredException("Another entity manager is already registered for this persistence unit");
                    }
                    if (tracker.autoJoinTx) {
                        entityManager.joinTransaction();
                    }
                    JtaEntityManagerRegistry.this.transactionRegistry.putResource((Object)txKey, (Object)entityManager);
                }
            }
            this.entityManagersByDeploymentId.put(instanceId, entityManagers);
        }

        private Map<EntityManagerFactory, EntityManagerTracker> removeEntityManagers(InstanceId instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("InstanceId is null");
            }
            return this.entityManagersByDeploymentId.remove(instanceId);
        }

        private EntityManagerTracker getInheritedEntityManager(EntityManagerFactory entityManagerFactory) {
            if (entityManagerFactory == null) {
                throw new NullPointerException("entityManagerFactory is null");
            }
            for (Map<EntityManagerFactory, EntityManagerTracker> entityManagers : this.entityManagersByDeploymentId.values()) {
                EntityManagerTracker entityManagerTracker = entityManagers.get(entityManagerFactory);
                if (entityManagerTracker == null) continue;
                return entityManagerTracker;
            }
            return null;
        }

        private void transactionStarted(InstanceId instanceId) {
            if (instanceId == null) {
                throw new NullPointerException("instanceId is null");
            }
            if (!JtaEntityManagerRegistry.this.isTransactionActive()) {
                throw new TransactionRequiredException();
            }
            Map<EntityManagerFactory, EntityManagerTracker> entityManagers = this.entityManagersByDeploymentId.get(instanceId);
            if (entityManagers == null) {
                return;
            }
            for (Map.Entry<EntityManagerFactory, EntityManagerTracker> entry : entityManagers.entrySet()) {
                EntityManagerFactory entityManagerFactory = entry.getKey();
                EntityManagerTracker value = entry.getValue();
                EntityManager entityManager = value.getEntityManager();
                if (value.autoJoinTx) {
                    entityManager.joinTransaction();
                }
                EntityManagerTxKey txKey = new EntityManagerTxKey(entityManagerFactory);
                JtaEntityManagerRegistry.this.transactionRegistry.putResource((Object)txKey, (Object)entityManager);
            }
        }
    }
}

