/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.openejb.BeanContext;
import org.apache.openejb.assembler.classic.MethodAttributeInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodPermissionInfo;
import org.apache.openejb.assembler.classic.MethodTransactionInfo;
import org.apache.openejb.assembler.classic.NamedMethodInfo;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.SetAccessible;

public class MethodInfoUtil {
    public static Method toMethod(Class clazz, NamedMethodInfo info) {
        ArrayList<Class> parameterTypes = new ArrayList<Class>();
        if (info.methodParams != null) {
            for (String paramType : info.methodParams) {
                try {
                    parameterTypes.add(Classes.forName(paramType, clazz.getClassLoader()));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("Parameter class could not be loaded for type " + paramType, cnfe);
                }
            }
        }
        Class[] parameters = parameterTypes.toArray(new Class[parameterTypes.size()]);
        IllegalStateException noSuchMethod = null;
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(info.methodName, parameters);
                return SetAccessible.on(method);
            }
            catch (NoSuchMethodException e) {
                if (noSuchMethod == null) {
                    noSuchMethod = new IllegalStateException("Callback method does not exist: " + clazz.getName() + "." + info.methodName, e);
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw noSuchMethod;
    }

    public static List<Method> matchingMethods(Method signature, Class clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        block0: for (Method method : clazz.getMethods()) {
            Class<?>[] signatureTypes;
            Class<?>[] methodTypes;
            if (!method.getName().equals(signature.getName()) || (methodTypes = method.getParameterTypes()).length != (signatureTypes = signature.getParameterTypes()).length) continue;
            for (int i = 0; i < methodTypes.length; ++i) {
                if (!methodTypes[i].equals(signatureTypes[i])) continue block0;
            }
            list.add(method);
        }
        return list;
    }

    public static List<Method> matchingMethods(MethodInfo mi, Class clazz) {
        Method[] methods = clazz.getMethods();
        return MethodInfoUtil.matchingMethods(mi, methods);
    }

    public static List<Method> matchingMethods(MethodInfo mi, Method[] methods) {
        List<Method> filtered = MethodInfoUtil.filterByLevel(mi, methods);
        filtered = MethodInfoUtil.filterByView(mi, filtered);
        return filtered;
    }

    private static List<Method> filterByView(MethodInfo mi, List<Method> filtered) {
        View view = MethodInfoUtil.view(mi);
        switch (view) {
            case CLASS: {
                return MethodInfoUtil.filterByClass(mi, filtered);
            }
        }
        return filtered;
    }

    private static List<Method> filterByClass(MethodInfo mi, List<Method> methods) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            String className = method.getDeclaringClass().getName();
            if (!mi.className.equals(className)) continue;
            list.add(method);
        }
        return list;
    }

    private static List<Method> filterByLevel(MethodInfo mi, Method[] methods) {
        Level level2 = MethodInfoUtil.level(mi);
        switch (level2) {
            case BEAN: 
            case PACKAGE: {
                return Arrays.asList(methods);
            }
            case OVERLOADED_METHOD: {
                return MethodInfoUtil.filterByName(methods, mi.methodName);
            }
            case EXACT_METHOD: {
                return MethodInfoUtil.filterByNameAndParams(methods, mi);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static Method getMethod(Class clazz, MethodInfo info) {
        ClassLoader cl = clazz.getClassLoader();
        ArrayList<Class> params = new ArrayList<Class>();
        for (String methodParam : info.methodParams) {
            try {
                params.add(MethodInfoUtil.getClassForParam(methodParam, cl));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        Method method = null;
        try {
            method = clazz.getMethod(info.methodName, params.toArray(new Class[params.size()]));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!info.className.equals("*") && !method.getDeclaringClass().getName().equals(info.className)) {
            return null;
        }
        return method;
    }

    private static List<Method> filterByName(Method[] methods, String methodName) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            list.add(method);
        }
        return list;
    }

    private static List<Method> filterByNameAndParams(Method[] methods, MethodInfo mi) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            if (!MethodInfoUtil.matches(method, mi)) continue;
            list.add(method);
        }
        return list;
    }

    public static List<MethodPermissionInfo> normalizeMethodPermissionInfos(List<MethodPermissionInfo> infos) {
        ArrayList<MethodPermissionInfo> normalized = new ArrayList<MethodPermissionInfo>();
        for (MethodPermissionInfo oldInfo : infos) {
            for (MethodInfo methodInfo : oldInfo.methods) {
                MethodPermissionInfo newInfo = new MethodPermissionInfo();
                newInfo.description = oldInfo.description;
                newInfo.methods.add(methodInfo);
                newInfo.roleNames.addAll(oldInfo.roleNames);
                newInfo.unchecked = oldInfo.unchecked;
                newInfo.excluded = oldInfo.excluded;
                normalized.add(newInfo);
            }
        }
        normalized.sort(new MethodPermissionComparator());
        return normalized;
    }

    private static Class getClassForParam(String className, ClassLoader cl) throws ClassNotFoundException {
        switch (className) {
            case "int": {
                return Integer.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
        }
        return Class.forName(className, false, cl);
    }

    public static Map<Method, MethodAttributeInfo> resolveAttributes(List<? extends MethodAttributeInfo> infos, BeanContext beanContext) {
        LinkedHashMap<Method, MethodAttributeInfo> attributes = new LinkedHashMap<Method, MethodAttributeInfo>();
        Method[] wildCardView = MethodInfoUtil.getWildCardView(beanContext).toArray(new Method[0]);
        for (MethodAttributeInfo methodAttributeInfo : infos) {
            for (MethodInfo methodInfo : methodAttributeInfo.methods) {
                if (methodInfo.ejbName != null && !methodInfo.ejbName.equals("*") && !methodInfo.ejbName.equals(beanContext.getEjbName())) continue;
                ArrayList<Method> methods = new ArrayList<Method>();
                if (methodInfo.methodIntf == null) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, wildCardView));
                } else if (methodInfo.methodIntf.equals("Home")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getHomeInterface()));
                } else if (methodInfo.methodIntf.equals("Remote")) {
                    if (beanContext.getRemoteInterface() != null) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getRemoteInterface()));
                    }
                    for (Class intf : beanContext.getBusinessRemoteInterfaces()) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, intf));
                    }
                } else if (methodInfo.methodIntf.equals("LocalHome")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getLocalHomeInterface()));
                } else if (methodInfo.methodIntf.equals("Local")) {
                    if (beanContext.getLocalInterface() != null) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getLocalInterface()));
                    }
                    for (Class intf : beanContext.getBusinessRemoteInterfaces()) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, intf));
                    }
                } else if (methodInfo.methodIntf.equals("ServiceEndpoint")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getServiceEndpointInterface()));
                }
                for (Method method : methods) {
                    if (MethodInfoUtil.containerMethod(method)) continue;
                    attributes.put(method, methodAttributeInfo);
                }
            }
        }
        return attributes;
    }

    public static Map<ViewMethod, MethodAttributeInfo> resolveViewAttributes(List<? extends MethodAttributeInfo> infos, BeanContext beanContext) {
        LinkedHashMap<ViewMethod, MethodAttributeInfo> attributes = new LinkedHashMap<ViewMethod, MethodAttributeInfo>();
        Method[] wildCardView = MethodInfoUtil.getWildCardView(beanContext).toArray(new Method[0]);
        for (MethodAttributeInfo methodAttributeInfo : infos) {
            for (MethodInfo methodInfo : methodAttributeInfo.methods) {
                if (methodInfo.ejbName != null && !methodInfo.ejbName.equals("*") && !methodInfo.ejbName.equals(beanContext.getEjbName())) continue;
                ArrayList<Method> methods = new ArrayList<Method>();
                if (methodInfo.methodIntf == null) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, wildCardView));
                } else if (methodInfo.methodIntf.equals("Home")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getHomeInterface()));
                } else if (methodInfo.methodIntf.equals("Remote")) {
                    if (beanContext.getRemoteInterface() != null) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getRemoteInterface()));
                    }
                    for (Class intf : beanContext.getBusinessRemoteInterfaces()) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, intf));
                    }
                } else if (methodInfo.methodIntf.equals("LocalHome")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getLocalHomeInterface()));
                } else if (methodInfo.methodIntf.equals("Local")) {
                    if (beanContext.getLocalInterface() != null) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getLocalInterface()));
                    }
                    for (Class intf : beanContext.getBusinessRemoteInterfaces()) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, intf));
                    }
                } else if (methodInfo.methodIntf.equals("ServiceEndpoint")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, beanContext.getServiceEndpointInterface()));
                }
                for (Method method : methods) {
                    if (MethodInfoUtil.containerMethod(method)) continue;
                    ViewMethod viewMethod = new ViewMethod(methodInfo.methodIntf, method);
                    attributes.put(viewMethod, methodAttributeInfo);
                }
            }
        }
        return attributes;
    }

    private static boolean containerMethod(Method method) {
        return (method.getDeclaringClass() == EJBObject.class || method.getDeclaringClass() == EJBHome.class || method.getDeclaringClass() == EJBLocalObject.class || method.getDeclaringClass() == EJBLocalHome.class) && !method.getName().equals("remove");
    }

    private static List<Method> getWildCardView(BeanContext info) {
        List<Method> beanMethods = Arrays.asList(info.getBeanClass().getMethods());
        ArrayList<Method> methods = new ArrayList<Method>(beanMethods);
        if (info.getRemoteInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getRemoteInterface().getMethods()));
        }
        if (info.getHomeInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getHomeInterface().getMethods()));
        }
        if (info.getLocalInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getLocalInterface().getMethods()));
        }
        if (info.getLocalHomeInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getLocalHomeInterface().getMethods()));
        }
        if (info.getMdbInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getMdbInterface().getMethods()));
        }
        if (info.getServiceEndpointInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getServiceEndpointInterface().getMethods()));
        }
        for (Class intf : info.getBusinessRemoteInterfaces()) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, intf.getMethods()));
        }
        for (Class intf : info.getBusinessLocalInterfaces()) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, intf.getMethods()));
        }
        methods.removeIf(MethodInfoUtil::containerMethod);
        return methods;
    }

    private static List<Method> exclude(List<Method> excludes, Method[] methods) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            if (MethodInfoUtil.matches(excludes, method)) continue;
            list.add(method);
        }
        return list;
    }

    private static boolean matches(List<Method> excludes, Method method) {
        for (Method excluded : excludes) {
            boolean match = MethodInfoUtil.match(method, excluded);
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static boolean match(Method methodA, Method methodB) {
        if (!methodA.getName().equals(methodB.getName())) {
            return false;
        }
        if (methodA.getParameterTypes().length != methodB.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < methodA.getParameterTypes().length; ++i) {
            Class<?> b;
            Class<?> a = methodA.getParameterTypes()[i];
            if (a.equals(b = methodB.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(Method method, MethodInfo methodInfo) {
        return MethodInfoUtil.matches(method, methodInfo.methodName, methodInfo.methodParams);
    }

    public static boolean matches(Method method, NamedMethodInfo methodInfo) {
        return MethodInfoUtil.matches(method, methodInfo.methodName, methodInfo.methodParams);
    }

    public static boolean matches(Method method, String methodName, List<String> methodParams) {
        if (!methodName.equals(method.getName())) {
            return false;
        }
        if (methodParams == null) {
            return true;
        }
        if (methodParams.size() != method.getParameterTypes().length) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            String methodParam = methodParams.get(i);
            if (methodParam.equals(MethodInfoUtil.getName(parameterType).replace('$', '.')) || methodParam.equals(parameterType.getName())) continue;
            return false;
        }
        return true;
    }

    private static String getName(Class<?> type) {
        if (type.isArray()) {
            return MethodInfoUtil.getName(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    public static View view(MethodInfo methodInfo) {
        if (methodInfo.className != null && !methodInfo.className.equals("*")) {
            return View.CLASS;
        }
        if (methodInfo.methodIntf != null && !methodInfo.methodIntf.equals("*")) {
            return View.INTERFACE;
        }
        return View.ANY;
    }

    public static Level level(MethodInfo methodInfo) {
        if (methodInfo.ejbName != null && methodInfo.ejbName.equals("*")) {
            return Level.PACKAGE;
        }
        if (methodInfo.methodName.equals("*")) {
            return Level.BEAN;
        }
        if (methodInfo.methodParams == null) {
            return Level.OVERLOADED_METHOD;
        }
        return Level.EXACT_METHOD;
    }

    public static String toString(MethodInfo i) {
        String s = i.ejbName;
        s = s + " : ";
        s = s + (i.methodIntf == null ? "*" : i.methodIntf);
        s = s + " : ";
        s = s + i.className;
        s = s + " : ";
        s = s + i.methodName;
        s = s + "(";
        s = i.methodParams != null ? s + Join.join(", ", i.methodParams) : s + "*";
        s = s + ")";
        return s;
    }

    public static String toString(MethodPermissionInfo i) {
        String s = MethodInfoUtil.toString((MethodInfo)i.methods.get(0));
        s = i.unchecked ? s + " Unchecked" : (i.excluded ? s + " Excluded" : s + " " + Join.join(", ", i.roleNames));
        return s;
    }

    public static String toString(MethodTransactionInfo i) {
        String s = MethodInfoUtil.toString((MethodInfo)i.methods.get(0));
        s = s + " " + i.transAttribute;
        return s;
    }

    public static String toString(MethodConcurrencyInfo i) {
        String s = MethodInfoUtil.toString((MethodInfo)i.methods.get(0));
        s = s + " " + i.concurrencyAttribute;
        return s;
    }

    public static abstract class BaseComparator<T>
    implements Comparator<T> {
        @Override
        public int compare(MethodInfo am, MethodInfo bm) {
            Level levelB;
            Level levelA = MethodInfoUtil.level(am);
            if (levelA != (levelB = MethodInfoUtil.level(bm))) {
                return levelA.ordinal() - levelB.ordinal();
            }
            return MethodInfoUtil.view(am).ordinal() - MethodInfoUtil.view(bm).ordinal();
        }
    }

    public static class MethodPermissionComparator
    extends BaseComparator<MethodPermissionInfo> {
        @Override
        public int compare(MethodPermissionInfo a, MethodPermissionInfo b) {
            return this.compare((MethodInfo)a.methods.get(0), (MethodInfo)b.methods.get(0));
        }
    }

    public static enum View {
        CLASS,
        ANY,
        INTERFACE;

    }

    public static enum Level {
        PACKAGE,
        BEAN,
        OVERLOADED_METHOD,
        EXACT_METHOD;

    }

    public static class ViewMethod {
        private final String view;
        private final Method method;

        public ViewMethod(String view, Method method) {
            this.view = view;
            this.method = method;
        }

        public String getView() {
            return this.view;
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewMethod that = (ViewMethod)o;
            if (!this.method.equals(that.method)) {
                return false;
            }
            return Objects.equals(this.view, that.view);
        }

        public int hashCode() {
            int result = this.view != null ? this.view.hashCode() : 0;
            result = 31 * result + this.method.hashCode();
            return result;
        }

        public String toString() {
            return String.format("%s : %s(%s)", this.view, this.method.getName(), Join.join(", ", Classes.getSimpleNames(this.method.getParameterTypes())));
        }
    }
}

