/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.metrics.cdi;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.metrics.cdi.MetricsExtension;
import org.apache.geronimo.microprofile.metrics.cdi.Names;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Timed
@Interceptor
@Priority(value=1000)
public class TimedInterceptor
implements Serializable {
    @Inject
    private MetricRegistry registry;
    @Inject
    @Intercepted
    private Bean<?> bean;
    @Inject
    private BeanManager beanManager;
    @Inject
    private MetricsExtension extension;
    private volatile transient ConcurrentMap<Executable, Timer> timers = new ConcurrentHashMap<Executable, Timer>();

    @AroundConstruct
    public Object onConstructor(InvocationContext context) throws Exception {
        return this.findTimer(context.getConstructor()).time(() -> ((InvocationContext)context).proceed());
    }

    @AroundInvoke
    public Object onMethod(InvocationContext context) throws Exception {
        return this.findTimer(context.getMethod()).time(() -> ((InvocationContext)context).proceed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer findTimer(Executable executable) {
        Timer timer;
        if (this.timers == null) {
            TimedInterceptor timedInterceptor = this;
            synchronized (timedInterceptor) {
                if (this.timers == null) {
                    this.timers = new ConcurrentHashMap<Executable, Timer>();
                }
            }
        }
        if ((timer = (Timer)this.timers.get(executable)) == null) {
            AnnotatedType type = this.beanManager.createAnnotatedType(this.bean.getBeanClass());
            Timed timed = Stream.concat(type.getMethods().stream(), type.getConstructors().stream()).filter(it -> it.getJavaMember().equals(executable)).findFirst().map(m -> (Timed)m.getAnnotation(Timed.class)).orElse(null);
            String name = Names.findName(Modifier.isAbstract(executable.getDeclaringClass().getModifiers()) ? type.getJavaClass() : executable.getDeclaringClass(), executable, timed == null ? null : timed.name(), timed != null && timed.absolute(), Optional.ofNullable(type.getAnnotation(Timed.class)).map(Timed::name).orElse(""));
            timer = (Timer)Timer.class.cast(this.registry.getMetrics().get(name));
            if (timer == null) {
                throw new IllegalStateException("No timer with name [" + name + "] found in registry [" + this.registry + "]");
            }
            this.timers.putIfAbsent(executable, timer);
        }
        return timer;
    }
}

