/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashSet;
import java.util.Set;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.StringAdapter;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="env-entryType", propOrder={"descriptions", "envEntryName", "envEntryType", "envEntryValue", "mappedName", "injectionTarget", "lookupName"})
public class EnvEntry
implements JndiReference {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="env-entry-name", required=true)
    protected String envEntryName;
    @XmlElement(name="env-entry-type")
    protected String envEntryType;
    @XmlJavaTypeAdapter(value=StringAdapter.class)
    @XmlElement(name="env-entry-value")
    protected String envEntryValue;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public EnvEntry() {
    }

    public EnvEntry(String envEntryName, String envEntryType, String envEntryValue) {
        this.setEnvEntryName(envEntryName);
        this.setEnvEntryType(envEntryType);
        this.setEnvEntryValue(envEntryValue);
    }

    public EnvEntry(String envEntryName, Class<?> envEntryType, String envEntryValue) {
        this(envEntryName, envEntryType.getName(), envEntryValue);
    }

    public EnvEntry name(String envEntryName) {
        this.setEnvEntryName(envEntryName);
        return this;
    }

    public EnvEntry type(String envEntryType) {
        this.setEnvEntryType(envEntryType);
        return this;
    }

    public EnvEntry type(Class<?> envEntryType) {
        return this.type(envEntryType.getName());
    }

    public EnvEntry value(String envEntryValue) {
        this.setEnvEntryValue(envEntryValue);
        return this;
    }

    public EnvEntry mappedName(String mappedName) {
        this.setMappedName(mappedName);
        return this;
    }

    public EnvEntry lookup(String lookupName) {
        this.setLookupName(lookupName);
        return this;
    }

    public EnvEntry injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.getEnvEntryName() == null) {
            this.setEnvEntryName("java:comp/env/" + className + "/" + property);
        }
        return this;
    }

    public EnvEntry injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.getEnvEntryName();
    }

    @Override
    @XmlTransient
    public String getType() {
        return this.getEnvEntryType();
    }

    @Override
    public void setName(String name) {
        this.setEnvEntryName(name);
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    @Override
    public void setType(String type) {
        this.setEnvEntryType(type);
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getEnvEntryName() {
        return this.envEntryName;
    }

    public void setEnvEntryName(String value) {
        this.envEntryName = value;
    }

    public String getEnvEntryType() {
        return this.envEntryType;
    }

    public void setEnvEntryType(String value) {
        this.envEntryType = value;
    }

    public String getEnvEntryValue() {
        return this.envEntryValue;
    }

    public void setEnvEntryValue(String value) {
        this.envEntryValue = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "EnvEntry{name='" + this.getEnvEntryName() + '\'' + ", type='" + this.getEnvEntryType() + '\'' + ", value='" + this.getEnvEntryValue() + '\'' + ", mappedName='" + this.getMappedName() + '\'' + ", lookupName='" + this.getLookupName() + '\'' + '}';
    }
}

