/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.HashSet;
import java.util.Set;
import org.apache.openejb.jee.EjbRefType;
import org.apache.openejb.jee.EjbReference;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ejb-local-refType", propOrder={"descriptions", "ejbRefName", "ejbRefType", "localHome", "local", "ejbLink", "mappedName", "injectionTarget", "lookupName"})
public class EjbLocalRef
implements EjbReference {
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlElement(name="ejb-ref-name", required=true)
    protected String ejbRefName;
    @XmlElement(name="ejb-ref-type")
    protected EjbRefType ejbRefType;
    @XmlElement(name="local-home")
    protected String localHome;
    protected String local;
    @XmlElement(name="ejb-link")
    protected String ejbLink;
    @XmlElement(name="mapped-name")
    protected String mappedName;
    @XmlElement(name="lookup-name")
    protected String lookupName;
    @XmlElement(name="injection-target", required=true)
    protected Set<InjectionTarget> injectionTarget;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    public EjbLocalRef() {
    }

    public EjbLocalRef(String ejbRefName, String ejbLink) {
        this.ejbRefName = ejbRefName;
        this.ejbLink = ejbLink;
    }

    public EjbLocalRef(EjbReference ref) {
        this.ejbRefName = ref.getName();
        this.ejbRefType = ref.getEjbRefType();
        this.ejbLink = ref.getEjbLink();
        this.mappedName = ref.getMappedName();
        this.setDescriptions(ref.getDescriptions());
        this.injectionTarget = ref.getInjectionTarget();
        this.local = ref.getInterface();
        this.localHome = ref.getHome();
    }

    public EjbLocalRef name(String ejbRefName) {
        this.ejbRefName = ejbRefName;
        return this;
    }

    public EjbLocalRef type(EjbRefType ejbRefType) {
        this.ejbRefType = ejbRefType;
        return this;
    }

    public EjbLocalRef link(String link) {
        this.ejbLink = link;
        return this;
    }

    public EjbLocalRef local(String local) {
        this.local = local;
        return this;
    }

    public EjbLocalRef local(Class<?> local) {
        return this.local(local.getName());
    }

    public EjbLocalRef localHome(String localHome) {
        this.localHome = localHome;
        return this;
    }

    public EjbLocalRef localHome(Class<?> localHome) {
        return this.localHome(localHome.getName());
    }

    public EjbLocalRef mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public EjbLocalRef lookup(String lookupName) {
        this.lookupName = lookupName;
        return this;
    }

    public EjbLocalRef injectionTarget(String className, String property) {
        this.getInjectionTarget().add(new InjectionTarget(className, property));
        if (this.ejbRefName == null) {
            this.ejbRefName = "java:comp/env/" + className + "/" + property;
        }
        return this;
    }

    public EjbLocalRef injectionTarget(Class<?> clazz, String property) {
        return this.injectionTarget(clazz.getName(), property);
    }

    @Override
    public String getName() {
        return this.getEjbRefName();
    }

    @Override
    public String getKey() {
        String name = this.getName();
        if (name == null || name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    @Override
    public String getType() {
        return this.getEjbRefType().name();
    }

    @Override
    public void setName(String name) {
        this.setEjbRefName(name);
    }

    @Override
    public void setType(String type) {
    }

    @Override
    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    public String getEjbRefName() {
        return this.ejbRefName;
    }

    public void setEjbRefName(String value) {
        this.ejbRefName = value;
    }

    @Override
    public EjbRefType getEjbRefType() {
        return this.ejbRefType;
    }

    public void setEjbRefType(EjbRefType value) {
        this.ejbRefType = value;
    }

    public String getLocalHome() {
        return this.localHome;
    }

    @Override
    public String getHome() {
        return this.getLocalHome();
    }

    @Override
    public String getInterface() {
        return this.getLocal();
    }

    @Override
    public EjbReference.Type getRefType() {
        return EjbReference.Type.LOCAL;
    }

    @Override
    public void setRefType(EjbReference.Type refType) {
    }

    public void setLocalHome(String value) {
        this.localHome = value;
    }

    public String getLocal() {
        return this.local;
    }

    public void setLocal(String value) {
        this.local = value;
    }

    @Override
    public String getEjbLink() {
        return this.ejbLink;
    }

    public void setEjbLink(String value) {
        this.ejbLink = value;
    }

    @Override
    public String getMappedName() {
        return this.mappedName;
    }

    @Override
    public void setMappedName(String value) {
        this.mappedName = value;
    }

    @Override
    public String getLookupName() {
        return this.lookupName;
    }

    @Override
    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    @Override
    public Set<InjectionTarget> getInjectionTarget() {
        if (this.injectionTarget == null) {
            this.injectionTarget = new HashSet<InjectionTarget>();
        }
        return this.injectionTarget;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String toString() {
        return "EjbLocalRef{name='" + this.ejbRefName + '\'' + ", local=" + this.local + ", link='" + this.ejbLink + '\'' + ", mappedName='" + this.mappedName + '\'' + ", lookupName='" + this.lookupName + '\'' + '}';
    }
}

