/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataDefaults;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public abstract class AbstractMetaDataDefaults
implements MetaDataDefaults {
    private static final Localizer _loc = Localizer.forPackage(AbstractMetaDataDefaults.class);
    private int _access = AccessCode.FIELD;
    private int _identity = 0;
    private boolean _ignore = true;
    private boolean _interface = true;
    private boolean _pcRegistry = true;
    private int _callback = 16;
    private boolean _unwrapped = false;

    public boolean getUsePCRegistry() {
        return this._pcRegistry;
    }

    public void setUsePCRegistry(boolean pcRegistry) {
        this._pcRegistry = pcRegistry;
    }

    @Override
    public int getDefaultAccessType() {
        return this._access;
    }

    public void setDefaultAccessType(int access) {
        this._access = access;
    }

    @Override
    public int getDefaultIdentityType() {
        return this._identity;
    }

    public void setDefaultIdentityType(int identity) {
        this._identity = identity;
    }

    @Override
    public int getCallbackMode() {
        return this._callback;
    }

    public void setCallbackMode(int mode) {
        this._callback = mode;
    }

    public void setCallbackMode(int mode, boolean on) {
        this._callback = on ? (this._callback |= mode) : (this._callback &= ~mode);
    }

    @Override
    public boolean getCallbacksBeforeListeners(int type) {
        return false;
    }

    @Override
    public boolean isDeclaredInterfacePersistent() {
        return this._interface;
    }

    public void setDeclaredInterfacePersistent(boolean pers) {
        this._interface = pers;
    }

    @Override
    public boolean isDataStoreObjectIdFieldUnwrapped() {
        return this._unwrapped;
    }

    public void setDataStoreObjectIdFieldUnwrapped(boolean unwrapped) {
        this._unwrapped = unwrapped;
    }

    public boolean getIgnoreNonPersistent() {
        return this._ignore;
    }

    @Override
    public void setIgnoreNonPersistent(boolean ignore) {
        this._ignore = ignore;
    }

    @Override
    public void populate(ClassMetaData meta, int access) {
        this.populate(meta, access, false);
    }

    @Override
    public void populate(ClassMetaData meta, int access, boolean ignoreTransient) {
        if (meta.getDescribedType() == Object.class) {
            return;
        }
        meta.setAccessType(access);
        Log log = meta.getRepository().getLog();
        if (log.isTraceEnabled()) {
            log.trace(_loc.get("gen-meta", meta));
        }
        if (!this._pcRegistry || !this.populateFromPCRegistry(meta)) {
            if (log.isTraceEnabled()) {
                log.trace(_loc.get("meta-reflect"));
            }
            this.populateFromReflection(meta, ignoreTransient);
        }
    }

    private boolean populateFromPCRegistry(ClassMetaData meta) {
        Class<?> cls = meta.getDescribedType();
        if (!PCRegistry.isRegistered(cls)) {
            return false;
        }
        try {
            String[] fieldNames = PCRegistry.getFieldNames(cls);
            Class<?>[] fieldTypes = PCRegistry.getFieldTypes(cls);
            for (int i = 0; i < fieldNames.length; ++i) {
                String property = fieldNames[i];
                Member member = this.getMemberByProperty(meta, property, AccessCode.UNKNOWN, true);
                if (member == null) continue;
                FieldMetaData fmd = meta.addDeclaredField(property, fieldTypes[i]);
                fmd.backingMember(member);
                this.populate(fmd);
            }
            return true;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new UserException(e);
        }
    }

    protected abstract List<Member> getPersistentMembers(ClassMetaData var1, boolean var2);

    private void populateFromReflection(ClassMetaData meta, boolean ignoreTransient) {
        List<Member> members = this.getPersistentMembers(meta, ignoreTransient);
        boolean iface = meta.getDescribedType().isInterface();
        for (int i = 0; i < members.size(); ++i) {
            boolean def;
            Member member = members.get(i);
            String name = AbstractMetaDataDefaults.getFieldName(member);
            if (name == null || this.isReservedFieldName(name) || !(def = this.isDefaultPersistent(meta, member, name, ignoreTransient)) && this._ignore) continue;
            FieldMetaData fmd = meta.addDeclaredField(name, Object.class);
            fmd.backingMember(member);
            if (!def) {
                fmd.setExplicit(true);
                fmd.setManagement(0);
            }
            this.populate(fmd);
        }
    }

    protected void populate(FieldMetaData fmd) {
    }

    protected List<String> getFieldAccessNames(ClassMetaData meta) {
        return null;
    }

    protected List<String> getPropertyAccessNames(ClassMetaData meta) {
        return null;
    }

    public static String getFieldName(Member member) {
        if (member instanceof Field) {
            return member.getName();
        }
        if (!(member instanceof Method)) {
            return null;
        }
        Method method = (Method)member;
        String name = method.getName();
        if (AbstractMetaDataDefaults.isNormalGetter(method)) {
            name = name.substring("get".length());
        } else if (AbstractMetaDataDefaults.isBooleanGetter(method)) {
            name = name.substring("is".length());
        } else {
            return null;
        }
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    protected boolean isReservedFieldName(String name) {
        return name.startsWith("openjpa") || name.startsWith("jdo");
    }

    protected abstract boolean isDefaultPersistent(ClassMetaData var1, Member var2, String var3, boolean var4);

    @Override
    public Member getBackingMember(FieldMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        if (fmd.getBackingMember() != null) {
            return fmd.getBackingMember();
        }
        return this.getMemberByProperty(fmd.getDeclaringMetaData(), fmd.getName(), fmd.getAccessType(), true);
    }

    @Override
    public Class<?> getUnimplementedExceptionType() {
        return UnsupportedOperationException.class;
    }

    protected static boolean isUserDefined(Class<?> cls) {
        return cls != null && !cls.getName().startsWith("java.") && !cls.getName().startsWith("javax.") && !cls.getName().startsWith("jakarta.");
    }

    public static boolean isNormalGetter(Method method) {
        String methodName = method.getName();
        return AbstractMetaDataDefaults.startsWith(methodName, "get") && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    public static boolean isBooleanGetter(Method method) {
        String methodName = method.getName();
        return AbstractMetaDataDefaults.startsWith(methodName, "is") && method.getParameterTypes().length == 0 && AbstractMetaDataDefaults.isBoolean(method.getReturnType());
    }

    public static boolean isGetter(Method method, boolean includePrivate) {
        if (method == null) {
            return false;
        }
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods) && (!Modifier.isPrivate(mods) || !includePrivate) || Modifier.isNative(mods) || Modifier.isStatic(mods)) {
            return false;
        }
        return AbstractMetaDataDefaults.isNormalGetter(method) || AbstractMetaDataDefaults.isBooleanGetter(method);
    }

    public static boolean startsWith(String full, String head) {
        return full != null && head != null && full.startsWith(head) && full.length() > head.length();
    }

    public static boolean isBoolean(Class<?> cls) {
        return cls == Boolean.TYPE || cls == Boolean.class;
    }

    public static List<String> toNames(List<? extends Member> members) {
        ArrayList<String> result = new ArrayList<String>();
        for (Member member : members) {
            result.add(member.getName());
        }
        return result;
    }
}

