/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;

@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Provider
public class JsonMapObjectProvider
implements MessageBodyReader<JsonMapObject>,
MessageBodyWriter<JsonMapObject> {
    private JsonMapObjectReaderWriter handler = new JsonMapObjectReaderWriter();

    public long getSize(JsonMapObject o, Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return JsonMapObject.class.isAssignableFrom(cls);
    }

    public void writeTo(JsonMapObject o, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        this.handler.toJson(o, os);
    }

    public boolean isReadable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return JsonMapObject.class.isAssignableFrom(cls);
    }

    public JsonMapObject readFrom(Class<JsonMapObject> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        String s = IOUtils.readStringFromStream((InputStream)is);
        try {
            JsonMapObject obj = cls == JsonMapObject.class ? new JsonMapObject() : cls.newInstance();
            this.handler.fromJson(obj, s);
            return obj;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

