/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import jakarta.ws.rs.client.InvocationCallback;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cxf.endpoint.ClientCallback;

public class JaxrsClientCallback<T>
extends ClientCallback {
    private final InvocationCallback<T> handler;
    private final Type outType;
    private final Class<?> responseClass;

    public JaxrsClientCallback(InvocationCallback<T> handler, Class<?> responseClass, Type outGenericType) {
        this.handler = handler;
        this.outType = outGenericType;
        this.responseClass = responseClass;
    }

    public InvocationCallback<T> getHandler() {
        return this.handler;
    }

    public Type getOutGenericType() {
        return this.outType;
    }

    public Class<?> getResponseClass() {
        return this.responseClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.started) {
            if (this.handler != null) {
                this.handler.failed((Throwable)new CancellationException());
            }
            this.delegate.cancel(mayInterruptIfRunning);
            JaxrsClientCallback jaxrsClientCallback = this;
            synchronized (jaxrsClientCallback) {
                ((Object)((Object)this)).notifyAll();
            }
            return true;
        }
        return false;
    }

    public Future<T> createFuture() {
        return new JaxrsResponseFuture(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(Map<String, Object> ctx, Object[] res) {
        this.context = ctx;
        if (this.handler != null) {
            this.handler.completed(res[0]);
        }
        this.delegate.complete(res);
        JaxrsClientCallback jaxrsClientCallback = this;
        synchronized (jaxrsClientCallback) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Map<String, Object> ctx, Throwable ex) {
        this.context = ctx;
        if (this.handler != null) {
            this.handler.failed(ex);
        }
        this.delegate.completeExceptionally(ex);
        JaxrsClientCallback jaxrsClientCallback = this;
        synchronized (jaxrsClientCallback) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    static class JaxrsResponseFuture<T>
    implements Future<T> {
        JaxrsClientCallback<T> callback;

        JaxrsResponseFuture(JaxrsClientCallback<T> cb) {
            this.callback = cb;
        }

        public Map<String, Object> getContext() {
            try {
                return this.callback.getResponseContext();
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.callback.cancel(mayInterruptIfRunning);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.getObject(this.callback.get()[0]);
            }
            catch (InterruptedException ex) {
                if (((JaxrsClientCallback)this.callback).handler != null) {
                    ((JaxrsClientCallback)this.callback).handler.failed((Throwable)ex);
                }
                throw ex;
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return this.getObject(this.callback.get(timeout, unit)[0]);
            }
            catch (InterruptedException ex) {
                if (((JaxrsClientCallback)this.callback).handler != null) {
                    ((JaxrsClientCallback)this.callback).handler.failed((Throwable)ex);
                }
                throw ex;
            }
        }

        private T getObject(Object object) {
            return (T)object;
        }

        @Override
        public boolean isCancelled() {
            return this.callback.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.callback.isDone();
        }
    }
}

