/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webservices;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.apache.openejb.server.cxf.rs.CxfRsHttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.httpd.ServletResponseAdapter;

public class CXFJAXRSFilter
implements Filter {
    private static final Field REQUEST;
    private final CxfRsHttpListener delegate;
    private final ConcurrentMap<Wrapper, Boolean> mappingByServlet = new ConcurrentHashMap<Wrapper, Boolean>();
    private final String[] welcomeFiles;
    private String mapping;

    public CXFJAXRSFilter(CxfRsHttpListener delegate, String[] welcomeFiles) {
        this.delegate = delegate;
        this.welcomeFiles = new String[welcomeFiles.length];
        for (int i = 0; i < welcomeFiles.length; ++i) {
            this.welcomeFiles[i] = '/' + welcomeFiles[i];
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.mapping = filterConfig.getInitParameter("mapping");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(request)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)HttpServletRequest.class.cast(request);
        HttpServletResponse httpServletResponse = (HttpServletResponse)HttpServletResponse.class.cast(response);
        if (!this.delegate.isCXFResource(httpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (CxfRsHttpListener.TRY_STATIC_RESOURCES) {
            if (this.servletMappingIsUnderRestPath(httpServletRequest)) {
                chain.doFilter(request, response);
                return;
            }
            InputStream staticContent = this.delegate.findStaticContent(httpServletRequest, this.welcomeFiles);
            if (staticContent != null) {
                chain.doFilter(request, response);
                return;
            }
        }
        try {
            this.delegate.doInvoke((HttpRequest)new ServletRequestAdapter(httpServletRequest, httpServletResponse, request.getServletContext()), (HttpResponse)new ServletResponseAdapter(httpServletResponse));
        }
        catch (Exception e) {
            throw new ServletException("Error processing webservice request", (Throwable)e);
        }
    }

    private boolean servletMappingIsUnderRestPath(HttpServletRequest request) {
        Request tr;
        HttpServletRequest unwrapped = this.unwrap(request);
        if (!RequestFacade.class.isInstance(unwrapped)) {
            return false;
        }
        try {
            tr = (Request)Request.class.cast(REQUEST.get(unwrapped));
        }
        catch (IllegalAccessException e) {
            return false;
        }
        Wrapper wrapper = tr.getWrapper();
        if (wrapper == null || this.mapping == null) {
            return false;
        }
        Boolean accept = (Boolean)this.mappingByServlet.get(wrapper);
        if (accept == null) {
            accept = false;
            if (!"org.apache.catalina.servlets.DefaultServlet".equals(wrapper.getServletClass())) {
                for (String mapping : wrapper.findMappings()) {
                    if (mapping.isEmpty() || "/*".equals(mapping) || "/".equals(mapping) || mapping.startsWith("*") || !mapping.startsWith(this.mapping)) continue;
                    accept = true;
                    break;
                }
            }
            this.mappingByServlet.putIfAbsent(wrapper, accept);
            return accept;
        }
        return accept;
    }

    private HttpServletRequest unwrap(HttpServletRequest request) {
        boolean changed;
        HttpServletRequest unwrapped = request;
        do {
            changed = false;
            while (HttpServletRequestWrapper.class.isInstance(unwrapped)) {
                HttpServletRequest tmp = (HttpServletRequest)HttpServletRequest.class.cast(((HttpServletRequestWrapper)HttpServletRequestWrapper.class.cast(unwrapped)).getRequest());
                if (tmp == unwrapped) {
                    changed = false;
                    break;
                }
                unwrapped = tmp;
                changed = true;
            }
            while (ServletRequestAdapter.class.isInstance(unwrapped)) {
                unwrapped = ((ServletRequestAdapter)ServletRequestAdapter.class.cast(unwrapped)).getRequest();
                changed = true;
            }
        } while (changed);
        return unwrapped;
    }

    public void destroy() {
    }

    static {
        try {
            REQUEST = RequestFacade.class.getDeclaredField("request");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        REQUEST.setAccessible(true);
    }
}

