/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.common.jaxrs;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geronimo.microprofile.common.registry.HealthChecksRegistry;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;

@Path(value="health")
public class HealthChecksEndpoint {
    private HealthChecksRegistry registry;

    public void setRegistry(HealthChecksRegistry registry) {
        this.registry = registry;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getChecks() {
        List checks;
        HealthCheckResponse.State globalState;
        if (this.registry == null) {
            this.registry = HealthChecksRegistry.load();
        }
        return Response.status((Response.Status)((globalState = (checks = this.registry.getChecks().stream().map(HealthCheck::call).collect(Collectors.toList())).stream().reduce(HealthCheckResponse.State.UP, (a, b) -> this.combine((HealthCheckResponse.State)a, b.getState()), this::combine)) == HealthCheckResponse.State.DOWN ? Response.Status.SERVICE_UNAVAILABLE : Response.Status.OK)).entity((Object)new AggregatedResponse(globalState, checks)).build();
    }

    private HealthCheckResponse.State combine(HealthCheckResponse.State a, HealthCheckResponse.State b) {
        return a == HealthCheckResponse.State.DOWN || b == HealthCheckResponse.State.DOWN ? HealthCheckResponse.State.DOWN : a;
    }

    public static class AggregatedResponse {
        private HealthCheckResponse.State status;
        private Collection<HealthCheckResponse> checks;

        private AggregatedResponse(HealthCheckResponse.State state, Collection<HealthCheckResponse> checks) {
            this.status = state;
            this.checks = checks;
        }

        public HealthCheckResponse.State getStatus() {
            return this.status;
        }

        @Deprecated
        public HealthCheckResponse.State getOutcome() {
            return this.status;
        }

        public Collection<HealthCheckResponse> getChecks() {
            return this.checks;
        }
    }
}

