/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.handlers;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Message;
import jakarta.mail.MessageAware;
import jakarta.mail.MessageContext;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.OutputStream;

public class MessageHandler
implements DataContentHandler {
    ActivationDataFlavor dataFlavor = new ActivationDataFlavor(String.class, "message/rfc822", "Text");

    protected ActivationDataFlavor getDF() {
        return this.dataFlavor;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.dataFlavor};
    }

    public Object getTransferData(DataFlavor dataflavor, DataSource datasource) throws IOException {
        if (this.getDF().equals(dataflavor)) {
            return this.getContent(datasource);
        }
        return null;
    }

    public Object getContent(DataSource datasource) throws IOException {
        try {
            if (datasource instanceof MessageAware) {
                MessageContext context = ((MessageAware)datasource).getMessageContext();
                return new MimeMessage(context.getSession(), datasource.getInputStream());
            }
        }
        catch (MessagingException e) {
            throw new IOException("Exception writing MimeMultipart: " + e.toString());
        }
        return null;
    }

    public void writeTo(Object object, String s, OutputStream outputstream) throws IOException {
        if (object instanceof Message) {
            try {
                ((Message)object).writeTo(outputstream);
            }
            catch (MessagingException e) {
                throw new IOException("Error parsing message: " + e.toString());
            }
        }
    }
}

