/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.imap.connection;

import jakarta.mail.Flags;
import jakarta.mail.MessagingException;
import java.util.List;
import org.apache.geronimo.javamail.store.imap.connection.IMAPFlagsResponse;
import org.apache.geronimo.javamail.store.imap.connection.IMAPOkResponse;
import org.apache.geronimo.javamail.store.imap.connection.IMAPPermanentFlagsResponse;
import org.apache.geronimo.javamail.store.imap.connection.IMAPResponseTokenizer;
import org.apache.geronimo.javamail.store.imap.connection.IMAPSizeResponse;
import org.apache.geronimo.javamail.store.imap.connection.IMAPStatusResponse;

public class IMAPMailboxStatus {
    public Flags availableFlags = null;
    public Flags permanentFlags = null;
    public int mode = 2;
    public int messages = -1;
    public int recentMessages = -1;
    public int unseenMessages = -1;
    public long uidNext = -1L;
    public long uidValidity = -1L;

    public void mergeStatus(IMAPStatusResponse source) throws MessagingException {
        if (source.messages != -1) {
            this.messages = source.messages;
        }
        if (source.uidNext != -1L) {
            this.uidNext = source.uidNext;
        }
        if (source.uidValidity != -1L) {
            this.uidValidity = source.uidValidity;
        }
        if (source.recentMessages != -1) {
            this.recentMessages = source.recentMessages;
        }
        if (source.unseenMessages != -1) {
            this.unseenMessages = source.unseenMessages;
        }
    }

    public void mergeFlags(IMAPFlagsResponse response) throws MessagingException {
        if (response != null) {
            this.availableFlags = response.getFlags();
        }
    }

    public void mergeSizeResponses(List responses) throws MessagingException {
        for (int i = 0; i < responses.size(); ++i) {
            this.mergeStatus((IMAPSizeResponse)responses.get(i));
        }
    }

    public void mergeOkResponses(List responses) throws MessagingException {
        for (int i = 0; i < responses.size(); ++i) {
            this.mergeStatus((IMAPOkResponse)responses.get(i));
        }
    }

    public void mergeStatus(IMAPSizeResponse source) throws MessagingException {
        if (source != null) {
            String name = source.getKeyword();
            if (source.isKeyword("EXISTS")) {
                this.messages = source.getSize();
            } else if (source.isKeyword("RECENT")) {
                this.recentMessages = source.getSize();
            }
        }
    }

    public void mergeStatus(IMAPOkResponse source) throws MessagingException {
        if (source != null) {
            List arguments;
            String name = source.getKeyword();
            if (source.isKeyword("UIDVALIDITY")) {
                arguments = source.getStatus();
                this.uidValidity = ((IMAPResponseTokenizer.Token)arguments.get(0)).getLong();
            }
            if (source.isKeyword("UIDNEXT")) {
                arguments = source.getStatus();
                this.uidNext = ((IMAPResponseTokenizer.Token)arguments.get(0)).getLong();
            } else if (source.isKeyword("UNSEEN")) {
                arguments = source.getStatus();
                this.uidValidity = ((IMAPResponseTokenizer.Token)arguments.get(0)).getInteger();
            }
        }
    }

    public void mergeStatus(IMAPPermanentFlagsResponse source) throws MessagingException {
        if (source != null) {
            this.permanentFlags = source.flags;
        }
    }
}

