/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.ws;

import jakarta.xml.ws.Binding;
import jakarta.xml.ws.EndpointContext;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.spi.Provider;
import jakarta.xml.ws.spi.http.HttpContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Endpoint {
    public static final String WSDL_SERVICE = "jakarta.xml.ws.wsdl.service";
    public static final String WSDL_PORT = "jakarta.xml.ws.wsdl.port";

    public static Endpoint create(Object implementor) {
        return Endpoint.create(null, implementor);
    }

    public static Endpoint create(String bindingId, Object implementor) {
        return Provider.provider().createEndpoint(bindingId, implementor);
    }

    public static Endpoint create(Object implementor, WebServiceFeature ... features) {
        return Provider.provider().createEndpoint(null, implementor, features);
    }

    public static Endpoint create(String bindingId, Object implementor, WebServiceFeature ... features) {
        return Provider.provider().createEndpoint(bindingId, implementor, features);
    }

    public static Endpoint publish(String address, Object implementor) {
        return Provider.provider().createAndPublishEndpoint(address, implementor);
    }

    public static Endpoint publish(String address, Object implementor, WebServiceFeature ... features) {
        return Provider.provider().createAndPublishEndpoint(address, implementor, features);
    }

    public abstract Binding getBinding();

    public abstract Object getImplementor();

    public abstract void publish(String var1);

    public abstract void publish(Object var1);

    public abstract void stop();

    public abstract boolean isPublished();

    public abstract List<Source> getMetadata();

    public abstract void setMetadata(List<Source> var1);

    public abstract Executor getExecutor();

    public abstract void setExecutor(Executor var1);

    public abstract Map<String, Object> getProperties();

    public abstract void setProperties(Map<String, Object> var1);

    public abstract EndpointReference getEndpointReference(Element ... var1);

    public abstract <T extends EndpointReference> T getEndpointReference(Class<T> var1, Element ... var2);

    public void setEndpointContext(EndpointContext ctx) {
        throw new UnsupportedOperationException("JAX-WS 2.2 implementations must override this method.");
    }

    public void publish(HttpContext context) {
        throw new UnsupportedOperationException("JAX-WS 2.2 implementations must override this method.");
    }
}

