/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.soap;

import jakarta.xml.soap.SOAPException;
import java.io.File;
import org.apache.geronimo.osgi.locator.ProviderLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String factoryClassName, ClassLoader classLoader) throws SOAPException {
        ClassLoader classloader = null;
        try {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new SOAPException(exception.toString(), exception);
        }
        try {
            return ProviderLocator.loadClass(factoryClassName, FactoryFinder.class, classloader).newInstance();
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new SOAPException("Provider " + factoryClassName + " not found", classnotfoundexception);
        }
        catch (Exception exception) {
            throw new SOAPException("Provider " + factoryClassName + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(Class<?> factoryType, String defaultFactoryClassName) throws SOAPException {
        String factoryPropertyName = factoryType.getName();
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new SOAPException(exception.toString(), exception);
        }
        try {
            Object service = ProviderLocator.getService(factoryPropertyName, FactoryFinder.class, classLoader);
            if (service != null) {
                return service;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String factoryClassName = ProviderLocator.lookupByJREPropertyFile("lib" + File.separator + "jaxm.properties", factoryPropertyName);
            if (factoryClassName != null) {
                return FactoryFinder.newInstance(factoryClassName, classLoader);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String systemProp = System.getProperty(factoryPropertyName);
            if (systemProp != null) {
                return FactoryFinder.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return FactoryFinder.newInstance(defaultFactoryClassName, classLoader);
    }
}

