/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.jacc;

import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.PolicyContextHandler;
import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class PolicyContext {
    private static final ThreadLocal<String> contextId = new ThreadLocal();
    private static final ThreadLocal<Object> handlerData = new ThreadLocal();
    private static volatile Map<String, PolicyContextHandler> handlers = new HashMap<String, PolicyContextHandler>();
    private static final SecurityPermission SET_POLICY = new SecurityPermission("setPolicy");

    private PolicyContext() {
    }

    public static void setContextID(String contextID) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_POLICY);
        }
        contextId.set(contextID);
    }

    public static String getContextID() {
        return contextId.get();
    }

    public static void setHandlerData(Object data) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_POLICY);
        }
        handlerData.set(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHandler(String key, PolicyContextHandler handler, boolean replace) throws PolicyContextException {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Handler must not be null");
        }
        if (!handler.supports(key)) {
            throw new IllegalArgumentException("Registered handler does not support the key '" + key + "'");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_POLICY);
        }
        Class<PolicyContext> clazz = PolicyContext.class;
        synchronized (PolicyContext.class) {
            if (!replace && handlers.containsKey(key)) {
                throw new IllegalArgumentException("A handler has already been registered under '" + key + "' and replace is false.");
            }
            HashMap<String, PolicyContextHandler> newHandlers = new HashMap<String, PolicyContextHandler>(handlers);
            newHandlers.put(key, handler);
            handlers = newHandlers;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static Set getHandlerKeys() {
        return handlers.keySet();
    }

    public static Object getContext(String key) throws PolicyContextException {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        PolicyContextHandler handler = handlers.get(key);
        if (handler == null) {
            throw new IllegalArgumentException("No handler can be found for the key '" + key + "'");
        }
        if (!handler.supports(key)) {
            throw new IllegalArgumentException("Registered handler no longer supports the key '" + key + "'");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_POLICY);
        }
        return handler.getContext(key, handlerData.get());
    }
}

