/*
 * Decompiled with CFR 0.152.
 */
package jakarta.persistence;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUtil;
import jakarta.persistence.spi.LoadState;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProviderResolverHolder;
import jakarta.persistence.spi.ProviderUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Persistence {
    @Deprecated
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    @Deprecated
    public static final String PERSISTENCE_PROVIDER = "jakarta.persistence.spi.PeristenceProvider";
    static final String PERSISTENCE_PROVIDER_PROPERTY = "jakarta.persistence.provider";
    static final String PERSISTENCE_PROVIDER_SERVICE = "META-INF/services/" + PersistenceProvider.class.getName();

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, Collections.EMPTY_MAP);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        EntityManagerFactory factory = null;
        Map props = properties;
        if (props == null) {
            props = Collections.EMPTY_MAP;
        }
        List<PersistenceProvider> providers = Persistence.getProviders();
        HashMap<String, Throwable> exceptions = new HashMap<String, Throwable>();
        StringBuffer foundProviders = null;
        for (PersistenceProvider provider : providers) {
            String providerName = provider.getClass().getName();
            try {
                factory = provider.createEntityManagerFactory(persistenceUnitName, props);
            }
            catch (Exception e) {
                exceptions.put(providerName, e);
            }
            if (factory != null) {
                return factory;
            }
            if (foundProviders == null) {
                foundProviders = new StringBuffer(providerName);
                continue;
            }
            foundProviders.append(", ");
            foundProviders.append(providerName);
        }
        if (foundProviders == null) {
            foundProviders = new StringBuffer("NONE");
        }
        if (exceptions.isEmpty()) {
            throw new PersistenceException("No persistence providers available for \"" + persistenceUnitName + "\" after trying the following discovered implementations: " + foundProviders);
        }
        throw Persistence.createPersistenceException("Explicit persistence provider error(s) occurred for \"" + persistenceUnitName + "\" after trying the following discovered implementations: " + foundProviders, exceptions);
    }

    private static PersistenceException createPersistenceException(String msg, Map<String, Throwable> failures) {
        String newline = System.getProperty("line.separator");
        StringWriter strWriter = new StringWriter();
        strWriter.append(msg);
        if (failures.size() <= 1) {
            Throwable t = null;
            Iterator<String> iterator = failures.keySet().iterator();
            if (iterator.hasNext()) {
                String providerName = iterator.next();
                t = failures.get(providerName);
                strWriter.append(" from provider: ");
                strWriter.append(providerName);
            }
            return new PersistenceException(strWriter.toString(), t);
        }
        strWriter.append(" with the following failures:");
        strWriter.append(newline);
        for (String providerName : failures.keySet()) {
            strWriter.append(providerName);
            strWriter.append(" returned: ");
            failures.get(providerName).printStackTrace(new PrintWriter(strWriter));
        }
        strWriter.append(newline);
        return new PersistenceException(strWriter.toString());
    }

    public static PersistenceUtil getPersistenceUtil() {
        return new PersistenceUtilImpl();
    }

    public static void generateSchema(String persistenceUnitName, Map properties) {
        List<PersistenceProvider> providers = Persistence.getProviders();
        for (PersistenceProvider provider : providers) {
            if (!provider.generateSchema(persistenceUnitName, properties)) continue;
            return;
        }
        throw new PersistenceException("No provider for schema generation of unit '" + persistenceUnitName + "'");
    }

    private static List<PersistenceProvider> getProviders() {
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        return resolver.getPersistenceProviders();
    }

    private static class PersistenceUtilImpl
    implements PersistenceUtil {
        private PersistenceUtilImpl() {
        }

        @Override
        public boolean isLoaded(Object entity, String attributeName) {
            LoadState ls;
            ProviderUtil pu2;
            List pps = Persistence.getProviders();
            for (PersistenceProvider pp : pps) {
                try {
                    pu2 = pp.getProviderUtil();
                    ls = pu2.isLoadedWithoutReference(entity, attributeName);
                    if (ls == LoadState.LOADED) {
                        return true;
                    }
                    if (ls != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable pu2) {
                }
            }
            for (PersistenceProvider pp : pps) {
                try {
                    pu2 = pp.getProviderUtil();
                    ls = pu2.isLoadedWithReference(entity, attributeName);
                    if (ls == LoadState.LOADED) {
                        return true;
                    }
                    if (ls != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable throwable) {
                }
            }
            return true;
        }

        @Override
        public boolean isLoaded(Object entity) {
            List pps = Persistence.getProviders();
            for (PersistenceProvider pp : pps) {
                try {
                    ProviderUtil pu = pp.getProviderUtil();
                    LoadState ls = pu.isLoaded(entity);
                    if (ls == LoadState.LOADED) {
                        return true;
                    }
                    if (ls != LoadState.NOT_LOADED) continue;
                    return false;
                }
                catch (Throwable throwable) {
                }
            }
            return true;
        }
    }
}

