/*
 * Decompiled with CFR 0.152.
 */
package jakarta.batch.runtime;

import jakarta.batch.operations.JobOperator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;

public class BatchRuntime {
    public static JobOperator getJobOperator() {
        if (System.getSecurityManager() == null) {
            return BatchRuntime.findJobOperator();
        }
        return AccessController.doPrivileged(new PrivilegedAction<JobOperator>(){

            @Override
            public JobOperator run() {
                return BatchRuntime.findJobOperator();
            }
        });
    }

    private static JobOperator findJobOperator() {
        Iterator<JobOperator> iterator = ServiceLoader.load(JobOperator.class).iterator();
        if (iterator.hasNext()) {
            JobOperator operator = iterator.next();
            return operator;
        }
        return null;
    }
}

