/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.List;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;

public class HtmlHeadRenderer
extends Renderer {
    private static final String HEAD_ELEM = "head";
    private static final String HEAD_TARGET = "head";
    private static final String PROFILE_ATTR = "profile";
    private static final String[] HEAD_PASSTHROUGH_ATTRIBUTES = new String[]{"dir", "lang", "profile"};

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeBegin(facesContext, component);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("head", component);
        HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, component, HEAD_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.renderHTMLAttribute(writer, component, "xmlns", "xmlns");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        ResponseWriter writer = facesContext.getResponseWriter();
        UIViewRoot root = facesContext.getViewRoot();
        List componentResources = root.getComponentResources(facesContext, "head");
        int childCount = componentResources.size();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)componentResources.get(i);
            child.encodeAll(facesContext);
        }
        writer.endElement("head");
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isEarlyFlushEnabled() && facesContext.isProjectStage(ProjectStage.Production)) {
            writer.flush();
        }
    }
}

