/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator;

import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleProviderLoader
implements Comparable<BundleProviderLoader> {
    private final String providerId;
    private final String providerClass;
    private final Bundle bundle;
    private final int priority;

    public BundleProviderLoader(String providerId, String providerClass, Bundle bundle, int priority) {
        this.providerId = providerId;
        this.providerClass = providerClass;
        this.bundle = bundle;
        this.priority = priority;
    }

    public Class<?> loadClass() throws ClassNotFoundException {
        return this.bundle.loadClass(this.providerClass);
    }

    public Object createInstance() throws Exception {
        Class<?> cls = this.loadClass();
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
    }

    public String id() {
        return this.providerId;
    }

    public String toString() {
        return "Provider interface=" + this.providerId + " , provider class=" + this.providerClass + ", bundle=" + this.bundle;
    }

    public int hashCode() {
        return this.providerId.hashCode() + this.providerClass.hashCode() + (int)this.bundle.getBundleId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BundleProviderLoader) {
            return this.providerId.equals(((BundleProviderLoader)obj).providerId) && this.providerClass.equals(((BundleProviderLoader)obj).providerClass) && this.bundle.getBundleId() == ((BundleProviderLoader)obj).bundle.getBundleId();
        }
        return false;
    }

    @Override
    public int compareTo(BundleProviderLoader other) {
        return other.priority - this.priority;
    }
}

