/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile;

import java.io.File;
import java.net.MalformedURLException;
import java.security.CodeSource;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.geronimo.microprofile.common.jaxrs.HealthChecksEndpoint;
import org.apache.geronimo.microprofile.impl.health.cdi.CdiHealthChecksEndpoint;
import org.apache.geronimo.microprofile.metrics.common.jaxrs.MetricsEndpoints;
import org.apache.geronimo.microprofile.metrics.jaxrs.CdiMetricsEndpoints;
import org.apache.geronimo.microprofile.openapi.jaxrs.OpenAPIEndpoint;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.event.EnhanceScannableUrlsEvent;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.observer.event.BeforeEvent;
import org.apache.tomee.catalina.event.AfterApplicationCreated;
import org.apache.tomee.installer.Paths;

public class TomEEMicroProfileListener {
    private static final String[] MICROPROFILE_LIBS_IMPLS_PREFIXES = new String[]{"mp-common"};
    private static final String[] MICROPROFILE_EXTENSIONS = new String[]{"org.apache.geronimo.config.cdi.ConfigExtension", "org.apache.safeguard.impl.cdi.SafeguardExtension", "org.apache.tomee.microprofile.jwt.cdi.MPJWTCDIExtension", "org.apache.geronimo.microprofile.impl.health.cdi.GeronimoHealthExtension", "org.apache.geronimo.microprofile.metrics.cdi.MetricsExtension", "org.apache.geronimo.microprofile.opentracing.microprofile.cdi.OpenTracingExtension", "org.apache.geronimo.microprofile.openapi.cdi.GeronimoOpenAPIExtension", "org.apache.cxf.microprofile.client.cdi.RestClientExtension"};

    public void enhanceScannableUrls(@Observes EnhanceScannableUrlsEvent enhanceScannableUrlsEvent) {
        String mpScan = SystemInstance.get().getOptions().get("tomee.mp.scan", "none");
        if (mpScan.equals("none")) {
            Stream.of(MICROPROFILE_EXTENSIONS).forEach(extension -> SystemInstance.get().setProperty(extension + ".active", "false"));
            return;
        }
        List containerUrls = enhanceScannableUrlsEvent.getScannableUrls();
        for (String extension2 : MICROPROFILE_EXTENSIONS) {
            try {
                CodeSource src = Class.forName(extension2).getProtectionDomain().getCodeSource();
                if (src == null) continue;
                containerUrls.add(src.getLocation());
            }
            catch (ClassNotFoundException src) {
                // empty catch block
            }
        }
        Paths paths = new Paths(new File(System.getProperty("openejb.home")));
        for (String prefix : MICROPROFILE_LIBS_IMPLS_PREFIXES) {
            File file = paths.findTomEELibJar(prefix);
            if (file == null) continue;
            try {
                containerUrls.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        SystemInstance.get().setProperty("openejb.cxf-rs.cache-application", "false");
    }

    public void processApplication(@Observes BeforeEvent<AfterApplicationCreated> afterApplicationCreated) {
        ServletContext context = ((AfterApplicationCreated)afterApplicationCreated.getEvent()).getContext();
        WebAppInfo webApp = ((AfterApplicationCreated)afterApplicationCreated.getEvent()).getWeb();
        webApp.restClass.removeIf(className -> className.equals(HealthChecksEndpoint.class.getName()));
        webApp.restClass.removeIf(className -> className.equals(MetricsEndpoints.class.getName()));
        context.getServletRegistrations().values().stream().map(ServletRegistration::getMappings).flatMap(Collection::stream).filter(mapping -> mapping.equals("/*")).findFirst().ifPresent(mapping -> {
            webApp.restClass.removeIf(className -> className.equals(CdiHealthChecksEndpoint.class.getName()));
            webApp.restClass.removeIf(className -> className.equals(CdiMetricsEndpoints.class.getName()));
            webApp.restClass.removeIf(className -> className.equals(OpenAPIEndpoint.class.getName()));
        });
    }
}

