/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.EventContext;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.WithAnnotations;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.event.EventContextImpl;
import org.apache.webbeans.event.OwbObserverMethod;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;

public class ObserverMethodImpl<T>
implements OwbObserverMethod<T> {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ObserverMethodImpl.class);
    private final AbstractOwbBean<?> ownerBean;
    private final boolean ifExist;
    private final Set<Annotation> observedQualifiers;
    private final Type observedEventType;
    private final TransactionPhase phase;
    private final Set<InjectionPoint> injectionPoints;
    private final Method view;
    private AnnotatedMethod<T> annotatedObserverMethod;
    private AnnotatedParameter<T> annotatedObservesParameter;
    private int priority = 2500;
    private boolean isAsync;

    public ObserverMethodImpl(AbstractOwbBean<?> ownerBean, AnnotatedMethod<T> annotatedObserverMethod, AnnotatedParameter<T> annotatedObservesParameter) {
        this(ownerBean, annotatedObserverMethod, annotatedObservesParameter, true);
    }

    protected ObserverMethodImpl(AbstractOwbBean<?> ownerBean, AnnotatedMethod<T> annotatedObserverMethod, AnnotatedParameter<T> annotatedObservesParameter, boolean fireEvent) {
        OpenWebBeansEjbPlugin ejbPlugin;
        Class<Observes> observerAnnotation;
        this.ownerBean = ownerBean;
        this.annotatedObservesParameter = annotatedObservesParameter;
        this.annotatedObserverMethod = annotatedObserverMethod;
        this.observedEventType = annotatedObservesParameter.getBaseType();
        Observes observes = (Observes)annotatedObservesParameter.getAnnotation(Observes.class);
        if (observes != null) {
            this.ifExist = observes.notifyObserver() == Reception.IF_EXISTS;
            this.phase = observes.during();
            observerAnnotation = Observes.class;
        } else {
            ObservesAsync observesAsync = (ObservesAsync)annotatedObservesParameter.getAnnotation(ObservesAsync.class);
            this.ifExist = observesAsync.notifyObserver() == Reception.IF_EXISTS;
            this.phase = TransactionPhase.IN_PROGRESS;
            observerAnnotation = ObservesAsync.class;
            this.isAsync = true;
        }
        this.observedQualifiers = new HashSet<Annotation>();
        for (Annotation annotation : annotatedObservesParameter.getAnnotations()) {
            if (!ownerBean.getWebBeansContext().getAnnotationManager().isQualifierAnnotation(annotation.annotationType())) continue;
            this.observedQualifiers.add(annotation);
        }
        Priority priorityAnn = (Priority)annotatedObservesParameter.getAnnotation(Priority.class);
        if (priorityAnn != null) {
            this.priority = priorityAnn.value();
        }
        this.view = (ejbPlugin = this.getWebBeansContext().getPluginLoader().getEjbPlugin()) != null && ejbPlugin.isNewSessionBean(ownerBean.getBeanClass()) ? ejbPlugin.resolveViewMethod(ownerBean, annotatedObserverMethod.getJavaMember()) : annotatedObserverMethod.getJavaMember();
        this.injectionPoints = new LinkedHashSet<InjectionPoint>();
        for (AnnotatedParameter parameter : annotatedObserverMethod.getParameters()) {
            if (parameter.isAnnotationPresent(observerAnnotation)) continue;
            this.injectionPoints.add(this.getWebBeansContext().getInjectionPointFactory().buildInjectionPoint(ownerBean, parameter, fireEvent));
        }
        this.checkObserverCondition(annotatedObservesParameter);
        if (!this.view.isAccessible()) {
            ownerBean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)this.view, true);
        }
    }

    protected void checkObserverCondition(AnnotatedParameter<T> annotatedObservesParameter) {
        if (annotatedObservesParameter.getAnnotation(WithAnnotations.class) != null) {
            throw new WebBeansConfigurationException("@WithAnnotations must only be used for ProcessAnnotatedType events");
        }
    }

    @Override
    public AbstractOwbBean<?> getOwnerBean() {
        return this.ownerBean;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public void notify(T event) {
        this.notify(new EventContextImpl<T>(event, null));
    }

    /*
     * Loose catch block
     */
    public void notify(EventContext<T> eventContext) {
        block33: {
            Object event = eventContext.getEvent();
            EventMetadata metadata = eventContext.getMetadata();
            AbstractOwbBean<?> component = this.ownerBean;
            if (!this.ownerBean.isEnabled()) {
                return;
            }
            Object object = null;
            List<ObserverParams> methodArgsMap = this.getMethodArguments(event, metadata);
            BeanManagerImpl manager = this.ownerBean.getWebBeansContext().getBeanManagerImpl();
            CreationalContext creationalContext = manager.createCreationalContext((Contextual)component);
            if (metadata != null) {
                creationalContext.putInjectionPoint(metadata.getInjectionPoint());
                creationalContext.putEventMetadata(metadata);
            }
            ObserverParams[] obargs = null;
            try {
                Context context;
                Object[] args;
                if (methodArgsMap == null) {
                    args = new Object[]{event};
                } else {
                    args = new Object[methodArgsMap.size()];
                    obargs = new ObserverParams[args.length];
                    obargs = methodArgsMap.toArray(obargs);
                    int i = 0;
                    for (ObserverParams param : obargs) {
                        args[i++] = param.instance;
                    }
                }
                if (Modifier.isStatic(this.view.getModifiers())) {
                    this.view.invoke(null, args);
                    break block33;
                }
                try {
                    context = manager.getContext(component.getScope());
                }
                catch (ContextNotActiveException cnae) {
                    if (this.ifExist) {
                        creationalContext.removeEventMetadata();
                        creationalContext.removeInjectionPoint();
                        if (component.getScope().equals(Dependent.class) && object != null) {
                            component.destroy(object, creationalContext);
                        }
                        if (methodArgsMap != null && obargs != null) {
                            for (ObserverParams param : obargs) {
                                if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                                param.bean.destroy(param.instance, param.creational);
                            }
                        }
                        return;
                    }
                    logger.log(Level.INFO, "INFO_0010", this.ownerBean);
                    creationalContext.removeEventMetadata();
                    creationalContext.removeInjectionPoint();
                    if (component.getScope().equals(Dependent.class) && object != null) {
                        component.destroy(object, creationalContext);
                    }
                    if (methodArgsMap != null && obargs != null) {
                        for (ObserverParams param : obargs) {
                            if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                            param.bean.destroy(param.instance, param.creational);
                        }
                    }
                    return;
                }
                object = context.get(component);
                if (this.ifExist && object == null) {
                    return;
                }
                if (object == null) {
                    object = context.get(component, creationalContext);
                }
                if (object == null) {
                    Type t = component.getBeanClass();
                    if (component.getWebBeansType() == WebBeansType.ENTERPRISE) {
                        t = (Type)component.getTypes().toArray()[0];
                    }
                    object = manager.getReference(component, t, creationalContext);
                }
                if (object != null) {
                    if (Modifier.isPrivate(this.view.getModifiers()) && object instanceof OwbNormalScopeProxy) {
                        object = this.getWebBeansContext().getInterceptorDecoratorProxyFactory().unwrapInstance(object);
                    }
                    this.invoke(object, args);
                }
                break block33;
                {
                    catch (InvocationTargetException ite) {
                        throw new WebBeansException(ite.getCause());
                    }
                    catch (Exception e) {
                        throw new WebBeansException(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                creationalContext.removeEventMetadata();
                creationalContext.removeInjectionPoint();
                if (component.getScope().equals(Dependent.class) && object != null) {
                    component.destroy(object, creationalContext);
                }
                if (methodArgsMap != null && obargs != null) {
                    for (ObserverParams param : obargs) {
                        if (!param.isBean || !param.bean.getScope().equals(Dependent.class)) continue;
                        param.bean.destroy(param.instance, param.creational);
                    }
                }
            }
        }
    }

    protected void invoke(Object object, Object[] args) throws IllegalAccessException, InvocationTargetException {
        this.view.invoke(object, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ObserverParams> getMethodArguments(Object event, EventMetadata metadata) {
        if (this.injectionPoints.isEmpty() && this.annotatedObservesParameter.getPosition() == 0) {
            return null;
        }
        ArrayList<ObserverParams> list = new ArrayList<ObserverParams>();
        if (this.annotatedObservesParameter.getPosition() == 0) {
            ObserverParams param = new ObserverParams();
            param.instance = event;
            list.add(param);
        }
        WebBeansContext webBeansContext = this.ownerBean.getWebBeansContext();
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        for (InjectionPoint injectionPoint : this.injectionPoints) {
            Object instance;
            Bean<?> injectedBean = manager.getInjectionResolver().getInjectionPointBean(injectionPoint);
            CreationalContext creational = manager.createCreationalContext((Contextual)injectedBean);
            creational.putInjectionPoint(metadata.getInjectionPoint());
            creational.putInjectionPoint(injectionPoint);
            creational.putEventMetadata(metadata);
            try {
                instance = manager.getReference(injectedBean, null, creational);
            }
            finally {
                creational.removeEventMetadata();
                creational.removeInjectionPoint();
                creational.removeInjectionPoint();
            }
            ObserverParams param = new ObserverParams();
            param.isBean = true;
            param.creational = creational;
            param.instance = instance;
            param.bean = injectedBean;
            list.add(param);
            if (list.size() != this.annotatedObservesParameter.getPosition()) continue;
            param = new ObserverParams();
            param.instance = event;
            list.add(param);
        }
        return list;
    }

    public Class<?> getBeanClass() {
        return this.ownerBean.getBeanClass();
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.observedQualifiers;
    }

    public Type getObservedType() {
        return this.observedEventType;
    }

    public Reception getReception() {
        return this.ifExist ? Reception.IF_EXISTS : Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return this.phase;
    }

    public AnnotatedMethod<T> getObserverMethod() {
        return this.annotatedObserverMethod;
    }

    protected WebBeansContext getWebBeansContext() {
        return this.ownerBean.getWebBeansContext();
    }

    public void setObserverMethod(AnnotatedMethod<T> m) {
        this.annotatedObserverMethod = m;
    }

    private static class ObserverParams {
        private Bean<Object> bean;
        private Object instance;
        private CreationalContext<Object> creational;
        private boolean isBean;

        private ObserverParams() {
        }
    }
}

