/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.oejb2;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Indicates that the database automatically populates a primary key
 * ID in the listed column(s).  Typically this is used for columns
 * with an AUTO_INCREMENT flag or the equivalent.  This only makes
 * sense if this key generator is used for an EJB or something else
 * with a corresponding database table (not if it's meant to generate
 * unique web session IDs or something like that -- see
 * auto-increment-tableType for that case).
 *
 *
 * <p>Java class for database-generatedType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="database-generatedType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="identity-column" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "database-generatedType", namespace = "http://tomee.apache.org/xml/ns/pkgen-2.1", propOrder = {
    "identityColumn"
})
public class DatabaseGeneratedType {

    @XmlElement(name = "identity-column", namespace = "http://tomee.apache.org/xml/ns/pkgen-2.1", required = true)
    protected List<String> identityColumn;

    /**
     * Gets the value of the identityColumn property.
     *
     *
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the identityColumn property.
     *
     *
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIdentityColumn().add(newItem);
     * </pre>
     *
     *
     *
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     */
    public List<String> getIdentityColumn() {
        if (identityColumn == null) {
            identityColumn = new ArrayList<String>();
        }
        return this.identityColumn;
    }

}
