/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq.jms2;

import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.TransactionSupport;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.activemq.ra.ActiveMQManagedConnection;
import org.apache.activemq.ra.ManagedConnectionProxy;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.resource.activemq.jms2.JMS2;
import org.apache.openejb.resource.activemq.jms2.TomEEManagedConnection;

public class TomEEManagedConnectionProxy
extends ManagedConnectionProxy
implements Connection,
QueueConnection,
TopicConnection,
ExceptionListener,
XAConnection {
    private volatile ActiveMQManagedConnection connection;

    public TomEEManagedConnectionProxy(ActiveMQManagedConnection managedConnection, ConnectionRequestInfo info) {
        super(managedConnection, info);
        this.connection = managedConnection;
    }

    public void cleanup() {
        super.cleanup();
        this.connection = null;
    }

    public Session createSession(int acknowledgeMode) throws JMSException {
        boolean xa;
        int mode;
        TransactionSupport.TransactionSupportLevel transactionSupportLevel = this.connection instanceof TomEEManagedConnection ? ((TomEEManagedConnection)this.connection).getTransactionSupportLevel() : TransactionSupport.TransactionSupportLevel.XATransaction;
        switch (transactionSupportLevel) {
            case XATransaction: {
                if (JMS2.inTx()) {
                    mode = -1;
                    xa = true;
                    break;
                }
            }
            case NoTransaction: {
                mode = acknowledgeMode;
                xa = false;
                break;
            }
            case LocalTransaction: {
                mode = 0;
                xa = false;
                break;
            }
            default: {
                throw new IllegalStateException("transactionSupportLevel mode not supported:" + transactionSupportLevel);
            }
        }
        if (xa) {
            return this.createXASession();
        }
        return this.connection.getPhysicalConnection().createSession(mode);
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        boolean xa;
        int mode;
        TransactionSupport.TransactionSupportLevel transactionSupportLevel = this.connection instanceof TomEEManagedConnection ? ((TomEEManagedConnection)this.connection).getTransactionSupportLevel() : (!transacted ? TransactionSupport.TransactionSupportLevel.NoTransaction : TransactionSupport.TransactionSupportLevel.XATransaction);
        switch (transactionSupportLevel) {
            case XATransaction: {
                if (JMS2.inTx()) {
                    mode = -1;
                    xa = true;
                    break;
                }
            }
            case NoTransaction: {
                mode = acknowledgeMode;
                xa = false;
                break;
            }
            case LocalTransaction: {
                mode = 0;
                xa = false;
                break;
            }
            default: {
                throw new IllegalStateException("transactionSupportLevel mode not supported:" + transactionSupportLevel);
            }
        }
        if (xa) {
            return this.createXASession();
        }
        Session session = this.connection.getPhysicalConnection().createSession(mode);
        this.enlistInTransactionIfNeeded(session);
        return session;
    }

    public Session createSession() throws JMSException {
        boolean xa;
        int mode;
        TransactionSupport.TransactionSupportLevel transactionSupportLevel = this.connection instanceof TomEEManagedConnection ? ((TomEEManagedConnection)this.connection).getTransactionSupportLevel() : TransactionSupport.TransactionSupportLevel.XATransaction;
        switch (transactionSupportLevel) {
            case XATransaction: {
                if (JMS2.inTx()) {
                    mode = -1;
                    xa = true;
                    break;
                }
            }
            case NoTransaction: {
                mode = 1;
                xa = false;
                break;
            }
            case LocalTransaction: {
                mode = 0;
                xa = false;
                break;
            }
            default: {
                throw new IllegalStateException("transactionSupportLevel mode not supported:" + transactionSupportLevel);
            }
        }
        if (xa) {
            return this.createXASession();
        }
        Session session = this.connection.getPhysicalConnection().createSession(mode);
        this.enlistInTransactionIfNeeded(session);
        return session;
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.connection.getPhysicalConnection().createSharedDurableConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.connection.getPhysicalConnection().createSharedConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
    }

    public XASession createXASession() throws JMSException {
        XASession session = ((XAConnection)this.connection.getPhysicalConnection()).createXASession();
        this.enlistInTransactionIfNeeded((Session)session);
        return session;
    }

    private void enlistInTransactionIfNeeded(Session session) {
        if (session instanceof XASession) {
            XASession xaSession = (XASession)XASession.class.cast(session);
            try {
                Transaction transaction = OpenEJB.getTransactionManager().getTransaction();
                if (transaction != null) {
                    transaction.enlistResource(xaSession.getXAResource());
                }
            }
            catch (IllegalStateException | RollbackException | SystemException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

