/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.ra.ActiveMQResourceAdapter;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.PersistenceAdapterFactory;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.propertyeditor.PropertyEditorException;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.apache.xbean.recipe.ObjectRecipe;

public class ActiveMQ5Factory
implements BrokerFactoryHandler {
    private static Properties properties;
    protected static final Map<URI, BrokerService> brokers;
    private static Throwable throwable;
    private static final AtomicBoolean started;
    private static PropertyEditorRegistry propertyEditorRegistry;

    public static void setThreadProperties(Properties p) {
        properties = p;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized BrokerService createBroker(URI brokerURI) throws Exception {
        PersistenceAdapter persistenceAdapter;
        Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("ActiveMQ5Factory creating broker");
        BrokerService broker = brokers.get(brokerURI);
        if (null != broker && broker.isStarted()) return broker;
        Properties properties = this.getLowerCaseProperties();
        URISupport.CompositeData compositeData = URISupport.parseComposite((URI)new URI(brokerURI.getRawSchemeSpecificPart()));
        HashMap<String, String> params = new HashMap<String, String>(compositeData.getParameters());
        if ("true".equals(params.remove("usekahadb"))) {
            persistenceAdapter = ActiveMQ5Factory.createPersistenceAdapter("org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter", "kahadb", params);
        } else if ("true".equals(params.remove("useleveldb"))) {
            persistenceAdapter = ActiveMQ5Factory.createPersistenceAdapter("org.apache.activemq.store.leveldb.LevelDBPersistenceAdapter", "leveldb", params);
        } else if (params.get("persistenceadapter") != null) {
            String adapter = (String)params.remove("persistenceadapter");
            persistenceAdapter = ActiveMQ5Factory.createPersistenceAdapter(adapter, "persistence", params);
        } else {
            persistenceAdapter = null;
        }
        String systemUsage = (String)params.remove("systemUsage");
        SystemUsage systemUsageInstance = "true".equalsIgnoreCase(systemUsage) ? this.newSystemUsage(params) : null;
        BrokerPlugin[] plugins = this.createPlugins(params);
        URI uri = new URI(ActiveMQ5Factory.cleanUpUri(brokerURI.getRawSchemeSpecificPart(), compositeData.getParameters(), params));
        BrokerService brokerService = broker = "broker".equals(uri.getScheme()) ? this.newDefaultBroker(uri) : BrokerFactory.createBroker((URI)uri);
        if (plugins != null) {
            broker.setPlugins(plugins);
        }
        if (systemUsageInstance != null) {
            broker.setSystemUsage(systemUsageInstance);
        }
        brokers.put(brokerURI, broker);
        if (persistenceAdapter != null) {
            broker.setPersistenceAdapter(persistenceAdapter);
            broker.setPersistenceFactory((PersistenceAdapterFactory)new ProvidedPersistenceAdapterPersistenceAdapterFactory(persistenceAdapter));
            broker.setPersistent(true);
            this.tomeeConfig(broker);
        } else {
            boolean notXbean;
            boolean bl = notXbean = !uri.getScheme().toLowerCase(Locale.ENGLISH).startsWith("xbean");
            if (notXbean) {
                DataSource dataSource;
                Object value = properties.get("datasource");
                if (String.class.isInstance(value) && value.toString().length() == 0) {
                    value = null;
                }
                if (value != null) {
                    if (DataSource.class.isInstance(value)) {
                        dataSource = (DataSource)DataSource.class.cast(value);
                    } else {
                        if (!String.class.isInstance(value)) throw new IllegalArgumentException("Unexpected datasource definition: " + value);
                        String resouceId = (String)String.class.cast(value);
                        try {
                            ContainerSystem containerSystem = SystemInstance.get().getComponent(ContainerSystem.class);
                            Context context = containerSystem.getJNDIContext();
                            Object obj = context.lookup("openejb/Resource/" + resouceId);
                            if (!(obj instanceof DataSource)) {
                                throw new IllegalArgumentException("Resource with id " + resouceId + " is not a DataSource, but is " + obj.getClass().getName());
                            }
                            dataSource = (DataSource)obj;
                        }
                        catch (NamingException e) {
                            throw new IllegalArgumentException("Unknown datasource " + resouceId);
                        }
                    }
                } else {
                    dataSource = null;
                }
                if (null != dataSource) {
                    JDBCPersistenceAdapter adapter = new JDBCPersistenceAdapter();
                    if (properties.containsKey("usedatabaselock")) {
                        adapter.setUseLock(Boolean.parseBoolean(properties.getProperty("usedatabaselock", "true")));
                    }
                    adapter.setDataSource(dataSource);
                    broker.setPersistent(true);
                    broker.setPersistenceAdapter((PersistenceAdapter)adapter);
                } else {
                    broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
                }
                this.tomeeConfig(broker);
            }
        }
        broker.setUseShutdownHook(false);
        broker.setSystemExitOnShutdown(false);
        broker.setStartAsync(false);
        ManagementContext managementContext = new ManagementContext();
        managementContext.setCreateConnector(false);
        broker.setManagementContext(managementContext);
        final BrokerService bs = broker;
        Thread start = new Thread("ActiveMQFactory start and checkpoint"){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(ActiveMQResourceAdapter.class.getClassLoader());
                try {
                    if (!bs.isStarted()) {
                        Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Starting ActiveMQ BrokerService");
                        bs.start();
                    }
                    bs.waitUntilStarted();
                    Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Starting ActiveMQ checkpoint");
                    bs.getPersistenceAdapter().checkpoint(true);
                    started.set(true);
                }
                catch (Throwable t) {
                    throwable = t;
                }
            }
        };
        int timeout = 30000;
        try {
            timeout = Integer.parseInt(properties.getProperty("startuptimeout", "30000"));
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("Using ActiveMQ startup timeout of " + timeout + "ms");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        start.setDaemon(true);
        start.start();
        try {
            start.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (null != throwable) {
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").error("ActiveMQ failed to start broker", throwable);
            return broker;
        } else if (started.get()) {
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").info("ActiveMQ broker started");
            return broker;
        } else {
            Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").warning("ActiveMQ failed to start broker within " + timeout + " seconds - It may be unusable");
        }
        return broker;
    }

    private SystemUsage newSystemUsage(Map<String, String> params) {
        SystemUsage systemUsage = new SystemUsage();
        String memory = params.remove("systemUsage.memory.limit");
        if (memory != null) {
            systemUsage.getMemoryUsage().setLimit((long)Integer.parseInt(memory.trim()));
        } else {
            systemUsage.getMemoryUsage().setLimit(0x40000000L);
        }
        memory = params.remove("systemUsage.temp.limit");
        if (memory != null) {
            systemUsage.getTempUsage().setLimit((long)Integer.parseInt(memory.trim()));
        } else {
            systemUsage.getTempUsage().setLimit(0xC80000000L);
        }
        memory = params.remove("systemUsage.store.limit");
        if (memory != null) {
            systemUsage.getStoreUsage().setLimit((long)Integer.parseInt(memory.trim()));
        } else {
            systemUsage.getStoreUsage().setLimit(0x1900000000L);
        }
        memory = params.remove("systemUsage.scheduler.limit");
        if (memory != null) {
            systemUsage.getJobSchedulerUsage().setLimit((long)Integer.parseInt(memory.trim()));
        } else {
            systemUsage.getJobSchedulerUsage().setLimit(0x40000000L);
        }
        return systemUsage;
    }

    private BrokerService newDefaultBroker(URI uri) throws Exception {
        URISupport.CompositeData compositeData = URISupport.parseComposite((URI)uri);
        HashMap params = new HashMap(compositeData.getParameters());
        BrokerService brokerService = this.newPatchedBrokerService();
        IntrospectionSupport.setProperties((Object)brokerService, params);
        if (!params.isEmpty()) {
            String msg = "There are " + params.size() + " Broker options that couldn't be set on the BrokerService. Check the options are spelled correctly. Unknown parameters=[" + params + "]. This BrokerService cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        if (compositeData.getPath() != null) {
            brokerService.setBrokerName(compositeData.getPath());
        }
        for (URI component : compositeData.getComponents()) {
            if ("network".equals(component.getScheme())) {
                brokerService.addNetworkConnector(component.getSchemeSpecificPart());
                continue;
            }
            if ("proxy".equals(component.getScheme())) {
                brokerService.addProxyConnector(component.getSchemeSpecificPart());
                continue;
            }
            brokerService.addConnector(component);
        }
        return brokerService;
    }

    private BrokerService newPatchedBrokerService() {
        return new BrokerService(){

            public NetworkConnector addNetworkConnector(URI discoveryAddress) throws Exception {
                DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(discoveryAddress);
                try {
                    Map props = URISupport.parseParameters((URI)discoveryAddress);
                    if (!props.containsKey("skipConnector")) {
                        IntrospectionSupport.setProperties((Object)connector, (Map)props);
                    }
                }
                catch (URISyntaxException e) {
                    Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).getChildLogger("service").debug(e.getMessage());
                }
                return this.addNetworkConnector((NetworkConnector)connector);
            }
        };
    }

    private BrokerPlugin[] createPlugins(Map<String, String> params) {
        String plugins = params.remove("amq.plugins");
        if (plugins == null) {
            return null;
        }
        LinkedList instances = new LinkedList();
        for (String p : plugins.split(" *, *")) {
            if (p.isEmpty()) continue;
            String prefix = p + ".";
            ObjectRecipe recipe = new ObjectRecipe(params.remove(prefix + "class"));
            Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                recipe.setProperty(key.substring(prefix.length()), (Object)entry.getValue());
                iterator.remove();
            }
            instances.add(BrokerPlugin.class.cast(recipe.create()));
        }
        return instances.toArray(new BrokerPlugin[instances.size()]);
    }

    private static String cleanUpUri(String schemeSpecificPart, Map<String, String> parameters, Map<String, String> params) {
        String uri = schemeSpecificPart;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (params.containsKey(entry.getKey())) continue;
            String kv = entry.getKey() + "=" + ActiveMQ5Factory.encodeURI(entry.getValue());
            int idx = uri.indexOf(kv);
            if (idx < 0) {
                kv = entry.getKey() + "=" + entry.getValue();
                idx = uri.indexOf(kv);
            }
            if (idx < 0) continue;
            int andIdx = idx + kv.length();
            if (andIdx < uri.length() && uri.charAt(andIdx) == '&') {
                uri = uri.replace(kv + "&", "");
                continue;
            }
            uri = uri.replace(kv, "");
        }
        return uri;
    }

    private static String encodeURI(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private static PersistenceAdapter createPersistenceAdapter(String clazz, String prefix, Map<String, String> params) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Class<?> aClass;
        PersistenceAdapter persistenceAdapter = (PersistenceAdapter)PersistenceAdapter.class.cast(aClass.newInstance());
        for (aClass = Thread.currentThread().getContextClassLoader().loadClass(clazz); aClass != null; aClass = aClass.getSuperclass()) {
            for (Method m : aClass.getDeclaredMethods()) {
                String key;
                String field;
                if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1 || !Modifier.isPublic(m.getModifiers()) || (field = params.remove(key = prefix + "." + m.getName().substring(3).toLowerCase(Locale.ENGLISH))) == null) continue;
                try {
                    Object toSet = propertyEditorRegistry.getValue(m.getParameterTypes()[0], field.toString());
                    m.invoke((Object)persistenceAdapter, toSet);
                }
                catch (PropertyEditorException cantConvertException) {
                    throw new IllegalArgumentException("can't convert " + field + " for " + m.getName(), cantConvertException);
                }
            }
        }
        return persistenceAdapter;
    }

    private void tomeeConfig(BrokerService broker) {
        broker.setUseLoggingForShutdownErrors(Logger.getInstance(LogCategory.OPENEJB_STARTUP, ActiveMQ5Factory.class).isErrorEnabled());
    }

    private Properties getLowerCaseProperties() {
        Properties newProperties = new Properties();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    key = ((String)key).toLowerCase();
                }
                newProperties.put(key, entry.getValue());
            }
        }
        return newProperties;
    }

    public Collection<BrokerService> getBrokers() {
        return brokers.values();
    }

    static {
        brokers = new HashMap<URI, BrokerService>();
        started = new AtomicBoolean(false);
        propertyEditorRegistry = new PropertyEditorRegistry().registerDefaults();
    }

    private static class ProvidedPersistenceAdapterPersistenceAdapterFactory
    implements PersistenceAdapterFactory {
        private final PersistenceAdapter instance;

        public ProvidedPersistenceAdapterPersistenceAdapterFactory(PersistenceAdapter persistenceAdapter) {
            this.instance = persistenceAdapter;
        }

        public PersistenceAdapter createPersistenceAdapter() throws IOException {
            return this.instance;
        }
    }
}

