/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DefinitionException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.XATerminator;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.geronimo.connector.GeronimoBootstrapContext;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.connector.work.HintsContextHandler;
import org.apache.geronimo.connector.work.TransactionContextHandler;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.XAWork;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentContext;
import org.apache.openejb.DuplicateDeploymentIdException;
import org.apache.openejb.Extensions;
import org.apache.openejb.Injection;
import org.apache.openejb.JndiConstants;
import org.apache.openejb.MethodContext;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.api.resource.DestroyableResource;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ApplicationExceptionInfo;
import org.apache.openejb.assembler.classic.AssemblerTool;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.CommonInfoObject;
import org.apache.openejb.assembler.classic.ConnectionManagerInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.DeployTimeEnhancer;
import org.apache.openejb.assembler.classic.DeploymentExceptionManager;
import org.apache.openejb.assembler.classic.DeploymentListener;
import org.apache.openejb.assembler.classic.EjbJarBuilder;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EjbResolver;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.EnvEntryInfo;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.ImportSql;
import org.apache.openejb.assembler.classic.JaccPermissionsBuilder;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.assembler.classic.JndiContextInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyBuilder;
import org.apache.openejb.assembler.classic.MethodTransactionBuilder;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.PolicyContext;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.ReloadableEntityManagerFactory;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.assembler.classic.event.AssemblerCreated;
import org.apache.openejb.assembler.classic.event.AssemblerDestroyed;
import org.apache.openejb.assembler.classic.event.BeforeStartEjbs;
import org.apache.openejb.assembler.classic.event.ContainerSystemPostCreate;
import org.apache.openejb.assembler.classic.event.ContainerSystemPreDestroy;
import org.apache.openejb.assembler.classic.event.ResourceBeforeDestroyed;
import org.apache.openejb.assembler.classic.event.ResourceCreated;
import org.apache.openejb.assembler.classic.util.ServiceInfos;
import org.apache.openejb.assembler.monitoring.JMXContainer;
import org.apache.openejb.async.AsynchronousPool;
import org.apache.openejb.batchee.BatchEEServiceManager;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiPlugin;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.CustomELAdapter;
import org.apache.openejb.cdi.ManagedSecurityService;
import org.apache.openejb.cdi.OpenEJBBeanInfoService;
import org.apache.openejb.cdi.OpenEJBJndiService;
import org.apache.openejb.cdi.OpenEJBTransactionService;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.cdi.ThreadSingletonService;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.CompositeClassLoaderConfigurer;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.core.ConnectorReference;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.SimpleTransactionSynchronizationRegistry;
import org.apache.openejb.core.TransactionSynchronizationRegistryWrapper;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.ContextHandler;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.core.ivm.naming.ContextualJndiReference;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.core.ivm.naming.IvmJndiFactory;
import org.apache.openejb.core.ivm.naming.JndiUrlReference;
import org.apache.openejb.core.ivm.naming.LazyObjectReference;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.core.security.SecurityContextHandler;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.MemoryTimerStore;
import org.apache.openejb.core.timer.NullEjbTimerServiceImpl;
import org.apache.openejb.core.timer.ScheduleData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.transaction.JtaTransactionPolicyFactory;
import org.apache.openejb.core.transaction.SimpleBootstrapContext;
import org.apache.openejb.core.transaction.SimpleWorkManager;
import org.apache.openejb.core.transaction.TransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.javaagent.Agent;
import org.apache.openejb.jpa.integration.MakeTxLookup;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.DynamicMBeanWrapper;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.MBeanPojoWrapper;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.remote.RemoteResourceMonitor;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;
import org.apache.openejb.quartz.Scheduler;
import org.apache.openejb.resource.GeronimoConnectionManagerFactory;
import org.apache.openejb.resource.PropertiesFactory;
import org.apache.openejb.resource.jdbc.DataSourceFactory;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.threads.impl.ManagedExecutorServiceImpl;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.Contexts;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.ExecutorBuilder;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEJBErrorHandler;
import org.apache.openejb.util.PropertiesHelper;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.References;
import org.apache.openejb.util.SafeToolkit;
import org.apache.openejb.util.SetAccessible;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URISupport;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.classloader.ClassLoaderAwareHandler;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.openejb.util.proxy.ProxyFactory;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.logger.JULLoggerFactory;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassLoaders;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.UnsetPropertiesRecipe;

public class Assembler
extends AssemblerTool
implements org.apache.openejb.spi.Assembler,
JndiConstants {
    public static final String OPENEJB_URL_PKG_PREFIX;
    public static final String OPENEJB_JPA_DEPLOY_TIME_ENHANCEMENT_PROP = "openejb.jpa.deploy-time-enhancement";
    public static final String PROPAGATE_APPLICATION_EXCEPTIONS = "openejb.propagate.application-exceptions";
    private static final String GLOBAL_UNIQUE_ID = "global";
    public static final String TIMER_STORE_CLASS = "timerStore.class";
    private static final ReentrantLock lock;
    public static final String OPENEJB_TIMERS_ON = "openejb.timers.on";
    static final String FORCE_READ_ONLY_APP_NAMING = "openejb.forceReadOnlyAppNamingContext";
    public static final Class<?>[] VALIDATOR_FACTORY_INTERFACES;
    public static final Class<?>[] VALIDATOR_INTERFACES;
    private final boolean skipLoaderIfPossible;
    Messages messages = new Messages(Assembler.class.getPackage().getName());
    public final Logger logger;
    public final String resourceDestroyTimeout;
    public final boolean threadStackOnTimeout;
    private final CoreContainerSystem containerSystem;
    private final PersistenceClassLoaderHandler persistenceClassLoaderHandler;
    private final JndiBuilder jndiBuilder;
    private TransactionManager transactionManager;
    private org.apache.openejb.spi.SecurityService securityService;
    protected OpenEjbConfigurationFactory configFactory;
    private final Map<String, AppInfo> deployedApplications = new HashMap<String, AppInfo>();
    private final Map<ObjectName, CreationalContext> creationalContextForAppMbeans = new HashMap<ObjectName, CreationalContext>();
    private final Set<ObjectName> containerObjectNames = new HashSet<ObjectName>();
    private final RemoteResourceMonitor remoteResourceMonitor = new RemoteResourceMonitor();
    protected SafeToolkit toolkit = SafeToolkit.getToolkit("Assembler");
    protected OpenEjbConfiguration config;
    private static final ThreadLocal<Map<String, Object>> context;

    @Override
    public ContainerSystem getContainerSystem() {
        return this.containerSystem;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public org.apache.openejb.spi.SecurityService getSecurityService() {
        return this.securityService;
    }

    public void addDeploymentListener(DeploymentListener deploymentListener) {
        ReentrantLock l = lock;
        l.lock();
        try {
            this.logger.warning("DeploymentListener API is replaced by @Observes event");
            SystemInstance.get().addObserver(new DeploymentListenerObserver(deploymentListener));
        }
        finally {
            l.unlock();
        }
    }

    public void removeDeploymentListener(DeploymentListener deploymentListener) {
        ReentrantLock l = lock;
        l.lock();
        try {
            SystemInstance.get().removeObserver(new DeploymentListenerObserver(deploymentListener));
        }
        finally {
            l.unlock();
        }
    }

    public Assembler() {
        this(new IvmJndiFactory());
    }

    public Assembler(JndiFactory jndiFactory) {
        this.logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, Assembler.class);
        this.skipLoaderIfPossible = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.classloader.skip-app-loader-if-possible", "true"));
        this.resourceDestroyTimeout = SystemInstance.get().getProperty("openejb.resources.destroy.timeout");
        this.threadStackOnTimeout = "true".equals(SystemInstance.get().getProperty("openejb.resources.destroy.stack-on-timeout", "false"));
        this.persistenceClassLoaderHandler = new PersistenceClassLoaderHandlerImpl();
        Assembler.installNaming();
        SystemInstance system = SystemInstance.get();
        system.setComponent(org.apache.openejb.spi.Assembler.class, this);
        system.setComponent(Assembler.class, this);
        this.containerSystem = new CoreContainerSystem(jndiFactory);
        system.setComponent(ContainerSystem.class, this.containerSystem);
        this.jndiBuilder = new JndiBuilder(this.containerSystem.getJNDIContext());
        this.setConfiguration(new OpenEjbConfiguration());
        ApplicationServer appServer = system.getComponent(ApplicationServer.class);
        if (appServer == null) {
            system.setComponent(ApplicationServer.class, new ServerFederation());
        }
        system.setComponent(EjbResolver.class, new EjbResolver(null, EjbResolver.Scope.GLOBAL, new EjbJarInfo[0]));
        this.installExtensions();
        system.fireEvent(new AssemblerCreated());
        this.initBValFiltering();
    }

    private void initBValFiltering() {
        if ("true".equals(SystemInstance.get().getProperty("openejb.cdi.bval.filter", "true"))) {
            try {
                ClassLoader loader = ParentClassLoaderFinder.Helper.get();
                Object filter = loader.loadClass("org.apache.openejb.bval.BValCdiFilter").newInstance();
                loader.loadClass("org.apache.bval.cdi.BValExtension").getMethod("setAnnotatedTypeFilter", loader.loadClass("org.apache.bval.cdi.BValExtension$AnnotatedTypeFilter")).invoke(null, filter);
            }
            catch (Throwable th) {
                this.logger.warning("Can't setup BVal filtering, this can impact negatively performances: " + th.getMessage());
            }
        }
    }

    private void installExtensions() {
        try {
            List urls = NewLoaderLogic.applyBuiltinExcludes(new UrlSet(Assembler.class.getClassLoader()).excludeJvm()).getUrls();
            Extensions.installExtensions(new Extensions.Finder("META-INF", false, urls.toArray(new URL[urls.size()])));
            return;
        }
        catch (IOException iOException) {
            Extensions.installExtensions(new Extensions.Finder("META-INF", true, new URL[0]));
            return;
        }
    }

    private void setConfiguration(OpenEjbConfiguration config) {
        this.config = config;
        if (config.containerSystem == null) {
            config.containerSystem = new ContainerSystemInfo();
        }
        if (config.facilities == null) {
            config.facilities = new FacilitiesInfo();
        }
        SystemInstance.get().setComponent(OpenEjbConfiguration.class, this.config);
    }

    @Override
    public void init(Properties props) throws OpenEJBException {
        this.props = new Properties(props);
        Options options = new Options(props, SystemInstance.get().getOptions());
        String className = options.get("openejb.configurator", "org.apache.openejb.config.ConfigurationFactory");
        this.configFactory = "org.apache.openejb.config.ConfigurationFactory".equals(className) ? new ConfigurationFactory() : (OpenEjbConfigurationFactory)this.toolkit.newInstance(className);
        this.configFactory.init(props);
        SystemInstance.get().setComponent(OpenEjbConfigurationFactory.class, this.configFactory);
    }

    public static void installNaming() {
        if (SystemInstance.get().hasProperty("openejb.geronimo")) {
            return;
        }
        Assembler.installNaming(OPENEJB_URL_PKG_PREFIX);
    }

    public static void installNaming(String prefix) {
        Assembler.installNaming(prefix, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installNaming(String prefix, boolean clean) {
        ReentrantLock l = lock;
        l.lock();
        try {
            Properties systemProperties = JavaSecurityManagers.getSystemProperties();
            String str = systemProperties.getProperty("java.naming.factory.url.pkgs");
            if (str == null || clean) {
                str = prefix;
            } else if (!str.contains(prefix)) {
                str = str + ":" + prefix;
            }
            systemProperties.setProperty("java.naming.factory.url.pkgs", str);
        }
        finally {
            l.unlock();
        }
    }

    public static void setContext(Map<String, Object> map) {
        context.set(map);
    }

    public static Map<String, Object> getContext() {
        Map<String, Object> map = context.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            context.set(map);
        }
        return map;
    }

    @Override
    public void build() throws OpenEJBException {
        Assembler.setContext(new HashMap<String, Object>());
        try {
            OpenEjbConfiguration config = this.getOpenEjbConfiguration();
            this.buildContainerSystem(config);
        }
        catch (OpenEJBException ae) {
            throw ae;
        }
        catch (Exception e) {
            OpenEJBErrorHandler.handleUnknownError(e, "Assembler");
            throw new OpenEJBException(e);
        }
        finally {
            context.set(null);
        }
    }

    protected OpenEjbConfiguration getOpenEjbConfiguration() throws OpenEJBException {
        return this.configFactory.getOpenEjbConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildContainerSystem(OpenEjbConfiguration configInfo) throws Exception {
        SystemInstance systemInstance = SystemInstance.get();
        if (systemInstance.getOptions().get(OPENEJB_JPA_DEPLOY_TIME_ENHANCEMENT_PROP, false)) {
            systemInstance.addObserver(new DeployTimeEnhancer());
        }
        if (Assembler.hasBatchEE()) {
            systemInstance.addObserver(new BatchEEServiceManager());
        }
        for (ServiceInfo serviceInfo : configInfo.facilities.services) {
            this.createService(serviceInfo);
        }
        ContainerSystemInfo containerSystemInfo = configInfo.containerSystem;
        if (configInfo.facilities.intraVmServer != null) {
            this.createProxyFactory(configInfo.facilities.intraVmServer);
        }
        for (JndiContextInfo jndiContextInfo : configInfo.facilities.remoteJndiContexts) {
            this.createExternalContext(jndiContextInfo);
        }
        this.createTransactionManager(configInfo.facilities.transactionService);
        this.createSecurityService(configInfo.facilities.securityService);
        HashSet<String> hashSet = new HashSet<String>(configInfo.facilities.resources.size());
        for (AppInfo appInfo : containerSystemInfo.applications) {
            hashSet.addAll(appInfo.resourceIds);
        }
        HashMap<AppInfo, ClassLoader> hashMap = new HashMap<AppInfo, ClassLoader>();
        HashMap<String, ClassLoader> appClassLoaders = new HashMap<String, ClassLoader>();
        for (AppInfo appInfo : containerSystemInfo.applications) {
            hashMap.put(appInfo, this.createAppClassLoader(appInfo));
            appClassLoaders.put(appInfo.appId, this.createAppClassLoader(appInfo));
        }
        HashSet<String> rIds = new HashSet<String>(configInfo.facilities.resources.size());
        for (ResourceInfo resourceInfo : configInfo.facilities.resources) {
            this.createResource(configInfo.facilities.services, resourceInfo);
            rIds.add(resourceInfo.id);
        }
        rIds.removeAll(hashSet);
        ContainerSystem containerSystem = systemInstance.getComponent(ContainerSystem.class);
        if (containerSystem == null) {
            throw new RuntimeException("ContainerSystem has not been initialzed");
        }
        this.postConstructResources(rIds, ParentClassLoaderFinder.Helper.get(), containerSystem.getJNDIContext(), null);
        HashMap<String, List> appContainers = new HashMap<String, List>();
        for (ContainerInfo containerInfo : containerSystemInfo.containers) {
            List containerInfos = appContainers.computeIfAbsent(containerInfo.originAppName, k -> new ArrayList());
            containerInfos.add(containerInfo);
        }
        for (Map.Entry entry : appContainers.entrySet()) {
            List containerInfos2 = (List)entry.getValue();
            ClassLoader classLoader = (ClassLoader)appClassLoaders.get(entry.getKey());
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                if (classLoader != null) {
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                for (ContainerInfo containerInfo : containerInfos2) {
                    this.createContainer(containerInfo);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
        this.createJavaGlobal();
        for (AppInfo appInfo : containerSystemInfo.applications) {
            try {
                this.createApplication(appInfo, (ClassLoader)hashMap.get(appInfo));
            }
            catch (DuplicateDeploymentIdException containerInfos2) {
            }
            catch (Throwable e) {
                this.logger.error("appNotDeployed", e, appInfo.path);
                DeploymentExceptionManager exceptionManager = systemInstance.getComponent(DeploymentExceptionManager.class);
                if (exceptionManager == null || !(e instanceof Exception)) continue;
                exceptionManager.saveDeploymentException(appInfo, (Exception)e);
            }
        }
        systemInstance.fireEvent(new ContainerSystemPostCreate());
    }

    private static boolean hasBatchEE() {
        try {
            Class.forName("org.apache.batchee.container.services.ServicesManager", true, Assembler.class.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private void createJavaGlobal() {
        try {
            this.containerSystem.getJNDIContext().createSubcontext(GLOBAL_UNIQUE_ID);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public AppInfo getAppInfo(String path) {
        return this.deployedApplications.get(ProvisioningUtil.realLocation(path).iterator().next());
    }

    public boolean isDeployed(String path) {
        return this.deployedApplications.containsKey(ProvisioningUtil.realLocation(path).iterator().next());
    }

    public Collection<AppInfo> getDeployedApplications() {
        return new ArrayList<AppInfo>(this.deployedApplications.values());
    }

    public AppContext createApplication(EjbJarInfo ejbJar) throws NamingException, IOException, OpenEJBException {
        return this.createEjbJar(ejbJar);
    }

    public AppContext createEjbJar(EjbJarInfo ejbJar) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = ejbJar.path;
        appInfo.appId = ejbJar.moduleName;
        appInfo.ejbJars.add(ejbJar);
        return this.createApplication(appInfo);
    }

    public AppContext createApplication(EjbJarInfo ejbJar, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        return this.createEjbJar(ejbJar, classLoader);
    }

    public AppContext createEjbJar(EjbJarInfo ejbJar, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = ejbJar.path;
        appInfo.appId = ejbJar.moduleName;
        appInfo.ejbJars.add(ejbJar);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createClient(ClientInfo clientInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = clientInfo.path;
        appInfo.appId = clientInfo.moduleId;
        appInfo.clients.add(clientInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createClient(ClientInfo clientInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = clientInfo.path;
        appInfo.appId = clientInfo.moduleId;
        appInfo.clients.add(clientInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createConnector(ConnectorInfo connectorInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = connectorInfo.path;
        appInfo.appId = connectorInfo.moduleId;
        appInfo.connectors.add(connectorInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createConnector(ConnectorInfo connectorInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = connectorInfo.path;
        appInfo.appId = connectorInfo.moduleId;
        appInfo.connectors.add(connectorInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createWebApp(WebAppInfo webAppInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = webAppInfo.path;
        appInfo.appId = webAppInfo.moduleId;
        appInfo.webApps.add(webAppInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createWebApp(WebAppInfo webAppInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = webAppInfo.path;
        appInfo.appId = webAppInfo.moduleId;
        appInfo.webApps.add(webAppInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createApplication(AppInfo appInfo) throws OpenEJBException, IOException, NamingException {
        return this.createApplication(appInfo, this.createAppClassLoader(appInfo));
    }

    public AppContext createApplication(AppInfo appInfo, ClassLoader classLoader) throws OpenEJBException, IOException, NamingException {
        return this.createApplication(appInfo, classLoader, true);
    }

    /*
     * Exception decompiling
     */
    private AppContext createApplication(AppInfo appInfo, ClassLoader classLoader, boolean start) throws OpenEJBException, IOException, NamingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean setAppNamingContextReadOnly(List<BeanContext> allDeployments) {
        if ("true".equals(SystemInstance.get().getProperty(FORCE_READ_ONLY_APP_NAMING, "false"))) {
            for (BeanContext beanContext : allDeployments) {
                Context ctx = beanContext.getJndiContext();
                if (IvmContext.class.isInstance(ctx)) {
                    ((IvmContext)IvmContext.class.cast(ctx)).setReadOnly(true);
                    continue;
                }
                if (!ContextHandler.class.isInstance(ctx)) continue;
                ((ContextHandler)ContextHandler.class.cast(ctx)).setReadOnly();
            }
            return true;
        }
        return false;
    }

    private List<String> getDuplicates(AppInfo appInfo) {
        ArrayList<String> used = new ArrayList<String>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                if (this.containerSystem.getBeanContext(beanInfo.ejbDeploymentId) == null) continue;
                used.add(beanInfo.ejbDeploymentId);
            }
        }
        return used;
    }

    private boolean shouldStartCdi(AppInfo appInfo) {
        if (!"true".equalsIgnoreCase(appInfo.properties.getProperty("openejb.cdi.activated", "true"))) {
            return false;
        }
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            if (ejbJarInfo.beans == null || ejbJarInfo.beans.bdas.isEmpty() && ejbJarInfo.beans.noDescriptorBdas.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void validateCdiResourceProducers(AppContext appContext, AppInfo info) {
        if (appContext.getWebBeansContext() == null) {
            return;
        }
        if (appContext.isStandaloneModule() && !appContext.getProperties().containsKey("openejb.cdi.skip-resource-validation")) {
            Map<String, Object> bindings;
            Map<String, Object> map = bindings = appContext.getWebContexts().isEmpty() ? appContext.getBindings() : appContext.getWebContexts().iterator().next().getBindings();
            if (bindings != null && appContext.getWebBeansContext() != null && appContext.getWebBeansContext().getBeanManagerImpl().isInUse()) {
                for (Bean bean : appContext.getWebBeansContext().getBeanManagerImpl().getBeans()) {
                    Object lookup;
                    ResourceReference reference;
                    block18: {
                        Resource r;
                        CdiPlugin plugin;
                        if (!ResourceBean.class.isInstance(bean)) continue;
                        reference = ((ResourceBean)ResourceBean.class.cast(bean)).getReference();
                        String jndi = reference.getJndiName().replace("java:", "");
                        if (reference.getJndiName().startsWith("java:/")) {
                            jndi = jndi.substring(1);
                        }
                        if ((lookup = bindings.get(jndi)) == null && reference.getAnnotation(EJB.class) != null && !(plugin = (CdiPlugin)((Object)CdiPlugin.class.cast(appContext.getWebBeansContext().getPluginLoader().getEjbPlugin()))).isSessionBean(reference.getResourceType())) {
                            boolean ok = false;
                            for (BeanContext bc : appContext.getBeanContexts()) {
                                if (!bc.getBusinessLocalInterfaces().contains(reference.getResourceType()) && !bc.getBusinessRemoteInterfaces().contains(reference.getResourceType())) continue;
                                ok = true;
                                break;
                            }
                            if (!ok) {
                                throw new DefinitionException("EJB " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to " + reference.getResourceType());
                            }
                        }
                        if (Reference.class.isInstance(lookup)) {
                            try {
                                lookup = ((Reference)((Object)Reference.class.cast(lookup))).getContent();
                                break block18;
                            }
                            catch (Exception e) {
                                if (!JndiUrlReference.class.isInstance(lookup)) continue;
                                this.checkBuiltInResourceTypes(reference, ((JndiUrlReference)((Object)JndiUrlReference.class.cast(lookup))).getJndiName());
                                continue;
                            }
                        }
                        if (lookup == null && (r = (Resource)Resource.class.cast(reference.getAnnotation(Resource.class))) != null) {
                            if (!r.lookup().isEmpty()) {
                                this.checkBuiltInResourceTypes(reference, r.lookup());
                            } else if (!r.name().isEmpty()) {
                                String name = "comp/env/" + r.name();
                                boolean done = false;
                                for (WebAppInfo w : info.webApps) {
                                    for (EnvEntryInfo e : w.jndiEnc.envEntries) {
                                        if (!name.equals(e.referenceName)) continue;
                                        if (e.type != null && !reference.getResourceType().getName().equals(e.type)) {
                                            throw new DefinitionException("Env Entry " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to " + reference.getResourceType());
                                        }
                                        done = true;
                                        break;
                                    }
                                    if (!done) continue;
                                    break;
                                }
                            }
                        }
                    }
                    if (lookup == null || reference.getResourceType().isInstance(lookup)) continue;
                    throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast, instance is " + lookup);
                }
            }
        }
    }

    private void checkBuiltInResourceTypes(ResourceReference reference, String jndi) {
        Class resourceType = reference.getResourceType();
        if ("java:comp/BeanManager".equals(jndi) && resourceType != BeanManager.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a BeanManager");
        }
        if ("java:comp/TransactionSynchronizationRegistry".equals(jndi) && resourceType != TransactionSynchronizationRegistry.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a TransactionSynchronizationRegistry");
        }
        if ("java:comp/TransactionManager".equals(jndi) && resourceType != TransactionManager.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a TransactionManager");
        }
        if ("java:comp/ValidatorFactory".equals(jndi) && resourceType != ValidatorFactory.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a ValidatorFactory");
        }
        if ("java:comp/Validator".equals(jndi) && resourceType != Validator.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a Validator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void postConstructResources(Set<String> resourceIds, ClassLoader classLoader, Context containerSystemContext, AppContext appContext) throws NamingException, OpenEJBException {
        Thread thread = Thread.currentThread();
        ClassLoader oldCl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(classLoader);
            List<ResourceInfo> resourceList = this.config.facilities.resources;
            for (ResourceInfo resourceInfo : resourceList) {
                if (!resourceIds.contains(resourceInfo.id) || Assembler.isTemplatizedResource(resourceInfo)) continue;
                try {
                    Class<?> clazz;
                    try {
                        clazz = classLoader.loadClass(resourceInfo.className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        clazz = containerSystemContext.lookup("openejb/Resource/" + resourceInfo.id).getClass();
                    }
                    boolean initialize = "true".equalsIgnoreCase(String.valueOf(resourceInfo.properties.remove("InitializeAfterDeployment")));
                    AnnotationFinder finder = Proxy.isProxyClass(clazz) ? null : new AnnotationFinder((Archive)new ClassesArchive(Classes.ancestors(clazz)));
                    List postConstructs = finder == null ? Collections.emptyList() : finder.findAnnotatedMethods(PostConstruct.class);
                    List preDestroys = finder == null ? Collections.emptyList() : finder.findAnnotatedMethods(PreDestroy.class);
                    resourceInfo.postConstructMethods = new ArrayList<String>();
                    resourceInfo.preDestroyMethods = new ArrayList<String>();
                    this.addMethodsToResourceInfo(resourceInfo.postConstructMethods, PostConstruct.class, postConstructs);
                    this.addMethodsToResourceInfo(resourceInfo.preDestroyMethods, PreDestroy.class, preDestroys);
                    CreationalContextImpl creationalContext = null;
                    Object originalResource = null;
                    if (!postConstructs.isEmpty() || initialize) {
                        originalResource = containerSystemContext.lookup("openejb/Resource/" + resourceInfo.id);
                        Object resource = originalResource;
                        if (resource instanceof Reference) {
                            resource = Assembler.unwrapReference(resource);
                            this.bindResource(resourceInfo.id, resource, true);
                        }
                        try {
                            BeanManagerImpl beanManager;
                            if (appContext != null && appContext.getWebBeansContext() != null && (beanManager = appContext.getWebBeansContext().getBeanManagerImpl()).isInUse()) {
                                creationalContext = beanManager.createCreationalContext(null);
                                OWBInjector.inject((BeanManager)beanManager, (Object)resource, (CreationalContext)creationalContext);
                            }
                            if (!"none".equals(resourceInfo.postConstruct)) {
                                if (resourceInfo.postConstruct != null) {
                                    Method p = clazz.getDeclaredMethod(resourceInfo.postConstruct, new Class[0]);
                                    if (!p.isAccessible()) {
                                        SetAccessible.on(p);
                                    }
                                    p.invoke(resource, new Object[0]);
                                }
                                for (Method m : postConstructs) {
                                    if (!m.isAccessible()) {
                                        SetAccessible.on(m);
                                    }
                                    m.invoke(resource, new Object[0]);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logger.fatal("Error calling @PostConstruct method on " + resource.getClass().getName());
                            throw new OpenEJBException(e);
                        }
                    }
                    if (!"none".equals(resourceInfo.preDestroy)) {
                        if (resourceInfo.preDestroy != null) {
                            Method p = clazz.getDeclaredMethod(resourceInfo.preDestroy, new Class[0]);
                            if (!p.isAccessible()) {
                                SetAccessible.on(p);
                            }
                            preDestroys.add(p);
                        }
                        if (!preDestroys.isEmpty() || creationalContext != null) {
                            String name = "openejb/Resource/" + resourceInfo.id;
                            if (originalResource == null) {
                                originalResource = containerSystemContext.lookup(name);
                            }
                            this.bindResource(resourceInfo.id, new ResourceInstance(name, originalResource, preDestroys, (CreationalContext<?>)creationalContext), true);
                        }
                    }
                    if (resourceInfo.unsetProperties == null || Assembler.isPassthroughType(resourceInfo)) continue;
                    Set<String> unsetKeys = resourceInfo.unsetProperties.stringPropertyNames();
                    for (String key : unsetKeys) {
                        Assembler.unusedProperty(resourceInfo.id, this.logger, key);
                    }
                }
                catch (Exception e) {
                    this.logger.fatal("Error calling PostConstruct method on " + resourceInfo.id);
                    this.logger.fatal("Resource " + resourceInfo.id + " could not be initialized. Application will be undeployed.");
                    throw new OpenEJBException(e);
                    return;
                }
            }
        }
        finally {
            thread.setContextClassLoader(oldCl);
        }
    }

    private void addMethodsToResourceInfo(List<String> list, Class type, List<Method> methodList) throws OpenEJBException {
        for (Method method : methodList) {
            if (method.getParameterTypes().length > 0) {
                throw new OpenEJBException(type.getSimpleName() + " method " + method.getDeclaringClass().getName() + "." + method.getName() + " should have zero arguments");
            }
            list.add(method.getName());
        }
    }

    private static boolean isTemplatizedResource(ResourceInfo resourceInfo) {
        return resourceInfo.className == null || resourceInfo.className.isEmpty();
    }

    public static void mergeServices(AppInfo appInfo) throws URISyntaxException {
        for (ServiceInfo si : appInfo.services) {
            if (appInfo.properties.containsKey(si.id)) continue;
            HashMap<String, String> query = new HashMap<String, String>();
            if (si.types != null && !si.types.isEmpty()) {
                query.put("type", si.types.iterator().next());
            }
            if (si.className != null) {
                query.put("class-name", si.className);
            }
            if (si.factoryMethod != null) {
                query.put("factory-name", si.factoryMethod);
            }
            if (si.constructorArgs != null && !si.constructorArgs.isEmpty()) {
                query.put("constructor", Join.join(",", si.constructorArgs));
            }
            appInfo.properties.put(si.id, "new://Service?" + URISupport.createQueryString(query));
            if (si.properties == null) continue;
            for (String k : si.properties.stringPropertyNames()) {
                appInfo.properties.setProperty(si.id + "." + k, si.properties.getProperty(k));
            }
        }
    }

    private static List<CommonInfoObject> listCommonInfoObjectsForAppInfo(AppInfo appInfo) {
        ArrayList<CommonInfoObject> vfs = new ArrayList<CommonInfoObject>(appInfo.clients.size() + appInfo.connectors.size() + appInfo.ejbJars.size() + appInfo.webApps.size());
        vfs.addAll(appInfo.clients);
        vfs.addAll(appInfo.connectors);
        vfs.addAll(appInfo.ejbJars);
        vfs.addAll(appInfo.webApps);
        return vfs;
    }

    public void bindGlobals(Map<String, Object> bindings) throws NamingException {
        Context containerSystemContext = this.containerSystem.getJNDIContext();
        for (Map.Entry<String, Object> value : bindings.entrySet()) {
            String path = value.getKey();
            if (path.startsWith("module/") || path.startsWith("app/") || path.startsWith("comp/") || path.equalsIgnoreCase("global/dummy")) continue;
            Context lastContext = Contexts.createSubcontexts(containerSystemContext, path);
            try {
                lastContext.rebind(path.substring(path.lastIndexOf(47) + 1, path.length()), value.getValue());
            }
            catch (NameAlreadyBoundException nabe) {
                nabe.printStackTrace();
            }
            containerSystemContext.rebind(path, value.getValue());
        }
    }

    private void propagateApplicationExceptions(AppInfo appInfo, ClassLoader classLoader, List<BeanContext> allDeployments) {
        for (BeanContext context : allDeployments) {
            if (BeanContext.Comp.class.equals((Object)context.getBeanClass())) continue;
            for (EjbJarInfo jar : appInfo.ejbJars) {
                for (ApplicationExceptionInfo exception : jar.applicationException) {
                    try {
                        Class<?> exceptionClass = classLoader.loadClass(exception.exceptionClass);
                        context.addApplicationException(exceptionClass, exception.rollback, exception.inherited);
                    }
                    catch (Exception exception2) {}
                }
            }
        }
    }

    private void resumePersistentSchedulers(AppContext appContext) {
        try {
            Scheduler globalScheduler = SystemInstance.get().getComponent(Scheduler.class);
            ArrayList<Scheduler> schedulers = new ArrayList<Scheduler>();
            for (BeanContext ejb : appContext.getBeanContexts()) {
                Scheduler scheduler = ejb.get(Scheduler.class);
                if (scheduler == null || scheduler == globalScheduler || schedulers.contains(scheduler)) continue;
                schedulers.add(scheduler);
                try {
                    scheduler.resumeAll();
                }
                catch (Exception e) {
                    this.logger.warning("Can't resume scheduler for " + ejb.getEjbName(), e);
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public List<BeanContext> initEjbs(ClassLoader classLoader, AppInfo appInfo, AppContext appContext, Set<Injection> injections, List<BeanContext> allDeployments, String webappId) throws OpenEJBException {
        String globalTimersOn = SystemInstance.get().getProperty(OPENEJB_TIMERS_ON, "true");
        EjbJarBuilder ejbJarBuilder = new EjbJarBuilder(this.props, appContext);
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            if (this.isSkip(appInfo, webappId, ejbJar)) continue;
            HashMap<String, BeanContext> deployments = ejbJarBuilder.build(ejbJar, injections, classLoader);
            JaccPermissionsBuilder jaccPermissionsBuilder = new JaccPermissionsBuilder();
            PolicyContext policyContext = jaccPermissionsBuilder.build(ejbJar, deployments);
            jaccPermissionsBuilder.install(policyContext);
            TransactionPolicyFactory transactionPolicyFactory = this.createTransactionPolicyFactory(ejbJar, classLoader);
            for (BeanContext beanContext : deployments.values()) {
                beanContext.setTransactionPolicyFactory(transactionPolicyFactory);
            }
            MethodTransactionBuilder methodTransactionBuilder = new MethodTransactionBuilder();
            methodTransactionBuilder.build(deployments, ejbJar.methodTransactions);
            MethodConcurrencyBuilder methodConcurrencyBuilder = new MethodConcurrencyBuilder();
            methodConcurrencyBuilder.build(deployments, ejbJar.methodConcurrency);
            for (BeanContext beanContext : deployments.values()) {
                this.containerSystem.addDeployment(beanContext);
            }
            this.jndiBuilder.build(ejbJar, deployments);
            for (BeanContext beanContext : deployments.values()) {
                if (beanContext.getComponentType() != BeanType.STATEFUL) {
                    Method ejbTimeout = beanContext.getEjbTimeout();
                    boolean timerServiceRequired = false;
                    if (ejbTimeout != null) {
                        if (beanContext.getTransactionType(ejbTimeout) == TransactionType.RequiresNew) {
                            beanContext.setMethodTransactionAttribute(ejbTimeout, TransactionType.Required);
                        }
                        timerServiceRequired = true;
                    }
                    Iterator<Map.Entry<Method, MethodContext>> it = beanContext.iteratorMethodContext();
                    while (it.hasNext()) {
                        Map.Entry<Method, MethodContext> entry = it.next();
                        MethodContext methodContext = entry.getValue();
                        if (methodContext.getSchedules().size() <= 0) continue;
                        timerServiceRequired = true;
                        Method method = entry.getKey();
                        if (beanContext.getTransactionType(method) != TransactionType.RequiresNew) continue;
                        beanContext.setMethodTransactionAttribute(method, TransactionType.Required);
                    }
                    if (timerServiceRequired && "true".equalsIgnoreCase(appInfo.properties.getProperty(OPENEJB_TIMERS_ON, globalTimersOn))) {
                        EjbTimerServiceImpl timerService = new EjbTimerServiceImpl(beanContext, this.newTimerStore(beanContext));
                        TimerStore timerStore = timerService.getTimerStore();
                        Iterator<Map.Entry<Method, MethodContext>> it2 = beanContext.iteratorMethodContext();
                        while (it2.hasNext()) {
                            Map.Entry<Method, MethodContext> entry = it2.next();
                            MethodContext methodContext = entry.getValue();
                            for (ScheduleData scheduleData : methodContext.getSchedules()) {
                                timerStore.createCalendarTimer(timerService, (String)beanContext.getDeploymentID(), null, entry.getKey(), scheduleData.getExpression(), scheduleData.getConfig(), true);
                            }
                        }
                        beanContext.setEjbTimerService(timerService);
                    } else {
                        beanContext.setEjbTimerService(new NullEjbTimerServiceImpl());
                    }
                }
                Iterator<Map.Entry<Method, MethodContext>> it = beanContext.iteratorMethodContext();
                while (it.hasNext()) {
                    Map.Entry<Method, MethodContext> entry = it.next();
                    if (!entry.getValue().isAsynchronous() || beanContext.getTransactionType(entry.getKey()) != TransactionType.RequiresNew) continue;
                    beanContext.setMethodTransactionAttribute(entry.getKey(), TransactionType.Required);
                }
                if (!beanContext.isLocalbean() || beanContext.getComponentType().isMessageDriven() || beanContext.isDynamicallyImplemented()) continue;
                ArrayList<Class<BeanContext.Removable>> interfaces = new ArrayList<Class<BeanContext.Removable>>(3);
                interfaces.add(Serializable.class);
                interfaces.add(IntraVmProxy.class);
                BeanType type = beanContext.getComponentType();
                if (BeanType.STATEFUL.equals((Object)type) || BeanType.MANAGED.equals((Object)type)) {
                    interfaces.add(BeanContext.Removable.class);
                }
                beanContext.set(BeanContext.ProxyClass.class, new BeanContext.ProxyClass(beanContext, interfaces.toArray(new Class[interfaces.size()])));
            }
            for (ApplicationExceptionInfo exceptionInfo : ejbJar.applicationException) {
                try {
                    Class<?> exceptionClass = classLoader.loadClass(exceptionInfo.exceptionClass);
                    for (BeanContext beanContext : deployments.values()) {
                        beanContext.addApplicationException(exceptionClass, exceptionInfo.rollback, exceptionInfo.inherited);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("createApplication.invalidClass", e, exceptionInfo.exceptionClass, e.getMessage());
                }
            }
            allDeployments.addAll(deployments.values());
        }
        List<BeanContext> ejbs = Assembler.sort(allDeployments);
        for (BeanContext b : ejbs) {
            if (appContext.getBeanContexts().contains(b)) continue;
            appContext.getBeanContexts().add(b);
        }
        return ejbs;
    }

    private boolean isSkip(AppInfo appInfo, String webappId, EjbJarInfo ejbJar) {
        boolean skip = false;
        if (!appInfo.webAppAlone) {
            if (webappId == null) {
                skip = ejbJar.webapp;
            } else if (!ejbJar.webapp || !ejbJar.moduleId.equals(webappId) && !ejbJar.properties.getProperty("openejb.ejbmodule.webappId", "-").equals(webappId)) {
                skip = true;
            }
        }
        return skip;
    }

    private TimerStore newTimerStore(BeanContext beanContext) {
        for (DeploymentContext context : Arrays.asList(beanContext, beanContext.getModuleContext(), beanContext.getModuleContext().getAppContext())) {
            String timerStoreClass = context.getProperties().getProperty(TIMER_STORE_CLASS);
            if (timerStoreClass == null) continue;
            this.logger.info("Found timer class: " + timerStoreClass);
            try {
                Class<?> clazz = beanContext.getClassLoader().loadClass(timerStoreClass);
                try {
                    Constructor<?> constructor = clazz.getConstructor(TransactionManager.class);
                    return (TimerStore)TimerStore.class.cast(constructor.newInstance(EjbTimerServiceImpl.getDefaultTransactionManager()));
                }
                catch (Exception ignored) {
                    return (TimerStore)TimerStore.class.cast(clazz.newInstance());
                }
            }
            catch (Exception e) {
                this.logger.error("Can't instantiate " + timerStoreClass + ", using default memory timer store");
            }
        }
        return new MemoryTimerStore(EjbTimerServiceImpl.getDefaultTransactionManager());
    }

    public void startEjbs(boolean start, List<BeanContext> allDeployments) throws OpenEJBException {
        if (start) {
            Container container;
            SystemInstance.get().fireEvent(new BeforeStartEjbs(allDeployments));
            ArrayList<BeanContext> toStart = new ArrayList<BeanContext>();
            for (BeanContext deployment : allDeployments) {
                try {
                    container = deployment.getContainer();
                    if (container.getBeanContext(deployment.getDeploymentID()) != null) continue;
                    container.deploy(deployment);
                    if (!((String)deployment.getDeploymentID()).endsWith(".Comp") && !deployment.isHidden()) {
                        this.logger.info("createApplication.createdEjb", deployment.getDeploymentID(), deployment.getEjbName(), container.getContainerID());
                    }
                    if (this.logger.isDebugEnabled()) {
                        for (Map.Entry<Object, Object> entry : deployment.getProperties().entrySet()) {
                            this.logger.info("createApplication.createdEjb.property", deployment.getEjbName(), entry.getKey(), entry.getValue());
                        }
                    }
                    toStart.add(deployment);
                }
                catch (Throwable t) {
                    throw new OpenEJBException("Error deploying '" + deployment.getEjbName() + "'.  Exception: " + t.getClass() + ": " + t.getMessage(), t);
                }
            }
            for (BeanContext deployment : toStart) {
                try {
                    container = deployment.getContainer();
                    container.start(deployment);
                    if (((String)deployment.getDeploymentID()).endsWith(".Comp") || deployment.isHidden()) continue;
                    this.logger.info("createApplication.startedEjb", deployment.getDeploymentID(), deployment.getEjbName(), container.getContainerID());
                }
                catch (Throwable t) {
                    throw new OpenEJBException("Error starting '" + deployment.getEjbName() + "'.  Exception: " + t.getClass() + ": " + t.getMessage(), t);
                }
            }
        }
    }

    private void deployMBean(WebBeansContext wc, ClassLoader cl, String mbeanClass, Properties appMbeans, String id) {
        if (LocalMBeanServer.isJMXActive()) {
            CreationalContext creationalContext;
            Object instance;
            Bean bean;
            BeanManagerImpl bm;
            Class<?> clazz;
            try {
                clazz = cl.loadClass(mbeanClass);
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBRuntimeException(e);
            }
            if (wc == null) {
                bm = null;
                bean = null;
            } else {
                bm = wc.getBeanManagerImpl();
                Set beans = bm.getBeans(clazz, new Annotation[0]);
                bean = bm.resolve(beans);
            }
            if (bean == null) {
                try {
                    instance = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    this.logger.error("the mbean " + mbeanClass + " can't be registered because it can't be instantiated", e);
                    return;
                }
                catch (IllegalAccessException e) {
                    this.logger.error("the mbean " + mbeanClass + " can't be registered because it can't be accessed", e);
                    return;
                }
                creationalContext = null;
            } else {
                creationalContext = bm.createCreationalContext(bean);
                instance = bm.getReference(bean, clazz, creationalContext);
            }
            MBeanServer server = LocalMBeanServer.get();
            try {
                MBean annotation = clazz.getAnnotation(MBean.class);
                ObjectName leaf = annotation == null || annotation.objectName().isEmpty() ? new ObjectNameBuilder("openejb.user.mbeans").set("application", id).set("group", clazz.getPackage().getName()).set("name", clazz.getSimpleName()).build() : new ObjectName(annotation.objectName());
                server.registerMBean(new DynamicMBeanWrapper(wc, instance), leaf);
                appMbeans.put(mbeanClass, leaf.getCanonicalName());
                if (creationalContext != null && (bean.getScope() == null || Dependent.class.equals((Object)bean.getScope()))) {
                    this.creationalContextForAppMbeans.put(leaf, creationalContext);
                }
                this.logger.info("Deployed MBean(" + leaf.getCanonicalName() + ")");
            }
            catch (Exception e) {
                this.logger.error("the mbean " + mbeanClass + " can't be registered", e);
            }
        }
    }

    private void ensureWebBeansContext(AppContext appContext) {
        WebBeansContext webBeansContext = appContext.get(WebBeansContext.class);
        if (webBeansContext != null) {
            if (null == appContext.getWebBeansContext()) {
                appContext.setWebBeansContext(webBeansContext);
            }
            return;
        }
        webBeansContext = appContext.getWebBeansContext();
        if (webBeansContext == null) {
            HashMap<Class<LoaderService>, Object> services = new HashMap<Class<LoaderService>, Object>();
            services.put(Executor.class, new ManagedExecutorServiceImpl(ForkJoinPool.commonPool()));
            services.put(JNDIService.class, new OpenEJBJndiService());
            services.put(AppContext.class, appContext);
            services.put(ScannerService.class, new CdiScanner());
            services.put(BeanArchiveService.class, new OpenEJBBeanInfoService());
            services.put(ELAdaptor.class, new CustomELAdapter(appContext));
            services.put(LoaderService.class, new OptimizedLoaderService(appContext.getProperties()));
            Properties properties = new Properties();
            properties.setProperty(SecurityService.class.getName(), ManagedSecurityService.class.getName());
            properties.setProperty(ContextsService.class.getName(), CdiAppContextsService.class.getName());
            properties.setProperty(ResourceInjectionService.class.getName(), CdiResourceInjectionService.class.getName());
            properties.setProperty(TransactionService.class.getName(), OpenEJBTransactionService.class.getName());
            webBeansContext = new WebBeansContext(services, properties);
            appContext.setCdiEnabled(false);
            appContext.set(WebBeansContext.class, webBeansContext);
            appContext.setWebBeansContext(webBeansContext);
        }
    }

    private TransactionPolicyFactory createTransactionPolicyFactory(EjbJarInfo ejbJar, ClassLoader classLoader) {
        TransactionPolicyFactory factory = null;
        Object value = ejbJar.properties.get(TransactionPolicyFactory.class.getName());
        if (value instanceof TransactionPolicyFactory) {
            factory = (TransactionPolicyFactory)value;
        } else if (value instanceof String) {
            try {
                String[] parts = ((String)value).split(":", 2);
                ResourceFinder finder = new ResourceFinder("META-INF", classLoader);
                Map plugins = finder.mapAvailableImplementations(TransactionPolicyFactory.class);
                Class clazz = (Class)plugins.get(parts[0]);
                if (clazz != null) {
                    factory = parts.length == 1 ? (TransactionPolicyFactory)clazz.getConstructor(String.class).newInstance(parts[1]) : (TransactionPolicyFactory)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (factory == null) {
            factory = new JtaTransactionPolicyFactory(this.transactionManager);
        }
        return factory;
    }

    private static List<BeanContext> sort(List<BeanContext> deployments) {
        deployments.sort(new Comparator<BeanContext>(){

            @Override
            public int compare(BeanContext a, BeanContext b) {
                int aa = a.getComponentType() == BeanType.SINGLETON ? 1 : 0;
                int bb = b.getComponentType() == BeanType.SINGLETON ? 1 : 0;
                return aa - bb;
            }
        });
        deployments = References.sort(deployments, new References.Visitor<BeanContext>(){

            @Override
            public String getName(BeanContext t) {
                return (String)t.getDeploymentID();
            }

            @Override
            public Set<String> getReferences(BeanContext t) {
                return t.getDependsOn();
            }
        });
        deployments.sort(new Comparator<BeanContext>(){

            @Override
            public int compare(BeanContext a, BeanContext b) {
                int aa = a.getComponentType() == BeanType.MESSAGE_DRIVEN ? 1 : 0;
                int bb = b.getComponentType() == BeanType.MESSAGE_DRIVEN ? 1 : 0;
                return aa - bb;
            }
        });
        return deployments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ReentrantLock l = lock;
        l.lock();
        try {
            SystemInstance systemInstance = SystemInstance.get();
            systemInstance.fireEvent(new ContainerSystemPreDestroy());
            try {
                EjbTimerServiceImpl.shutdown();
            }
            catch (Exception e) {
                this.logger.warning("Unable to shutdown scheduler", e);
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            this.logger.debug("Undeploying Applications");
            Assembler assembler = this;
            ArrayList<AppInfo> deployedApps = new ArrayList<AppInfo>(assembler.getDeployedApplications());
            Collections.reverse(deployedApps);
            for (AppInfo appInfo : deployedApps) {
                try {
                    assembler.destroyApplication(appInfo.path);
                }
                catch (UndeployException e) {
                    this.logger.error("Undeployment failed: " + appInfo.path, e);
                }
                catch (NoSuchApplicationException e) {}
            }
            Iterator<ObjectName> it = this.containerObjectNames.iterator();
            MBeanServer server = LocalMBeanServer.get();
            while (it.hasNext()) {
                try {
                    server.unregisterMBean(it.next());
                }
                catch (Exception e) {
                    // empty catch block
                }
                it.remove();
            }
            try {
                this.remoteResourceMonitor.unregister();
            }
            catch (Exception e) {
                // empty catch block
            }
            NamingEnumeration<Binding> namingEnumeration = null;
            try {
                namingEnumeration = this.containerSystem.getJNDIContext().listBindings("openejb/Resource");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.destroyResourceTree("", namingEnumeration);
            try {
                this.containerSystem.getJNDIContext().unbind("java:global");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            systemInstance.removeComponent(OpenEjbConfiguration.class);
            systemInstance.removeComponent(JtaEntityManagerRegistry.class);
            systemInstance.removeComponent(TransactionSynchronizationRegistry.class);
            systemInstance.removeComponent(EjbResolver.class);
            systemInstance.removeComponent(ThreadSingletonService.class);
            systemInstance.fireEvent(new AssemblerDestroyed());
            systemInstance.removeObservers();
            if (DestroyableResource.class.isInstance(this.securityService)) {
                ((DestroyableResource)DestroyableResource.class.cast(this.securityService)).destroyResource();
            }
            if (DestroyableResource.class.isInstance(this.transactionManager)) {
                ((DestroyableResource)DestroyableResource.class.cast(this.transactionManager)).destroyResource();
            }
            for (Container c : this.containerSystem.containers()) {
                if (!DestroyableResource.class.isInstance(c)) continue;
                ((DestroyableResource)DestroyableResource.class.cast(c)).destroyResource();
            }
            SystemInstance.reset();
        }
        finally {
            l.unlock();
        }
    }

    private Collection<DestroyingResource> destroyResourceTree(String base, NamingEnumeration<Binding> namingEnumeration) {
        LinkedList<DestroyingResource> resources = new LinkedList<DestroyingResource>();
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            Object object = binding.getObject();
            if (Context.class.isInstance(object)) {
                try {
                    resources.addAll(this.destroyResourceTree(IvmContext.class.isInstance(object) ? ((IvmContext)IvmContext.class.cast((Object)object)).mynode.getAtomicName() : "", ((Context)Context.class.cast(object)).listBindings("")));
                }
                catch (Exception exception) {}
                continue;
            }
            resources.add(new DestroyingResource((base == null || base.isEmpty() ? "" : base + '/') + binding.getName(), binding.getClassName(), object));
        }
        resources.sort(new Comparator<DestroyingResource>(){

            @Override
            public int compare(DestroyingResource o1, DestroyingResource o2) {
                boolean ra1 = this.isRa(o1.instance);
                boolean ra2 = this.isRa(o2.instance);
                if (ra2 && !ra1) {
                    return -1;
                }
                if (ra1 && !ra2) {
                    return 1;
                }
                return o1.name.compareTo(o2.name);
            }

            private boolean isRa(Object instance) {
                return ResourceAdapter.class.isInstance(instance) || ResourceAdapterReference.class.isInstance(instance);
            }
        });
        for (DestroyingResource resource : resources) {
            try {
                this.destroyResource(resource.name, resource.clazz, resource.instance);
            }
            catch (Throwable th) {
                this.logger.debug(th.getMessage(), th);
            }
        }
        return resources;
    }

    /*
     * Unable to fully structure code
     */
    private void destroyResource(final String name, final String className, Object inObject) {
        try {
            object = LazyResource.class.isInstance(inObject) != false && ((LazyResource)LazyResource.class.cast(inObject)).isInitialized() != false ? ((LazyResource)LazyResource.class.cast(inObject)).getObject() : inObject;
        }
        catch (NamingException e) {
            object = inObject;
        }
        preDestroy = null;
        if (this.resourceDestroyTimeout != null) {
            d = new Duration(this.resourceDestroyTimeout);
            es = Executors.newSingleThreadExecutor(new DaemonThreadFactory(new Object[]{"openejb-resource-destruction-" + name}));
            o = object;
            try {
                es.submit(new Runnable(){

                    @Override
                    public void run() {
                        Assembler.this.doResourceDestruction(name, className, o);
                    }
                }).get(d.getTime(), d.getUnit());
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            catch (ExecutionException e) {
                throw (RuntimeException)RuntimeException.class.cast(e.getCause());
            }
            catch (TimeoutException e) {
                this.logger.error("Can't destroy " + name + " in " + this.resourceDestroyTimeout + ", giving up.", e);
                if (!this.threadStackOnTimeout) ** GOTO lbl38
                dump = ManagementFactory.getThreadMXBean().dumpAllThreads(false, false);
                writer = new ByteArrayOutputStream();
                stream = new PrintStream(writer);
                for (ThreadInfo info : dump) {
                    stream.println('\"' + info.getThreadName() + "\" suspended=" + info.isSuspended() + " state=" + (Object)info.getThreadState());
                    for (StackTraceElement traceElement : info.getStackTrace()) {
                        stream.println("\tat " + traceElement);
                    }
                }
                this.logger.info("Dump on " + name + " destruction timeout:\n" + new String(writer.toByteArray()));
            }
        } else {
            this.doResourceDestruction(name, className, object);
        }
lbl38:
        // 5 sources

        this.callPreDestroy(name, object);
        this.removeResourceInfo(name);
    }

    private void callPreDestroy(String name, Object object) {
        if (object == null) {
            return;
        }
        if (ResourceInstance.class.isInstance(object)) {
            ((ResourceInstance)ResourceInstance.class.cast(object)).destroyResource();
            return;
        }
        Class<?> objectClass = object.getClass();
        ResourceInfo ri = this.findResourceInfo(name);
        if (ri == null) {
            return;
        }
        HashSet<String> destroyMethods = new HashSet<String>();
        if (ri.preDestroy != null) {
            destroyMethods.add(ri.preDestroy);
        }
        if (ri.preDestroyMethods != null && ri.preDestroyMethods.size() > 0) {
            destroyMethods.addAll(ri.preDestroyMethods);
        }
        for (String destroyMethod : destroyMethods) {
            try {
                Method p = objectClass.getDeclaredMethod(destroyMethod, new Class[0]);
                if (!p.isAccessible()) {
                    SetAccessible.on(p);
                }
                p.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                this.logger.error("Unable to call pre destroy method " + destroyMethod + " on " + objectClass.getName() + ". Continuing with resource destruction.", e);
            }
        }
    }

    private ResourceInfo findResourceInfo(String name) {
        List<ResourceInfo> resourceInfos = this.config.facilities.resources;
        for (ResourceInfo resourceInfo : resourceInfos) {
            if (!resourceInfo.id.equals(name)) continue;
            return resourceInfo;
        }
        return null;
    }

    private void doResourceDestruction(String name, String className, Object jndiObject) {
        Object object;
        ResourceBeforeDestroyed event = new ResourceBeforeDestroyed(jndiObject, name);
        SystemInstance.get().fireEvent(event);
        Object object2 = object = event.getReplacement() == null ? jndiObject : event.getReplacement();
        if (object instanceof ResourceAdapterReference) {
            ResourceAdapterReference resourceAdapter = (ResourceAdapterReference)((Object)object);
            try {
                this.logger.info("Stopping ResourceAdapter: " + name);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Stopping ResourceAdapter: " + className);
                }
                if (resourceAdapter.pool != null && ExecutorService.class.isInstance(resourceAdapter.pool)) {
                    ((ExecutorService)ExecutorService.class.cast(resourceAdapter.pool)).shutdownNow();
                }
                resourceAdapter.ra.stop();
            }
            catch (Throwable t) {
                this.logger.fatal("ResourceAdapter Shutdown Failed: " + name, t);
            }
            this.removeResourceMBean(name, "ResourceAdapter");
        } else if (object instanceof ResourceAdapter) {
            ResourceAdapter resourceAdapter = (ResourceAdapter)object;
            try {
                this.logger.info("Stopping ResourceAdapter: " + name);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Stopping ResourceAdapter: " + className);
                }
                resourceAdapter.stop();
            }
            catch (Throwable t) {
                this.logger.fatal("ResourceAdapter Shutdown Failed: " + name, t);
            }
            this.removeResourceMBean(name, "ResourceAdapter");
        } else if (DataSourceFactory.knows(object)) {
            this.logger.info("Closing DataSource: " + name);
            try {
                DataSourceFactory.destroy(object);
            }
            catch (Throwable resourceAdapter) {}
        } else if (object instanceof ConnectorReference) {
            ConnectorReference cr = (ConnectorReference)((Object)object);
            try {
                ConnectionManager cm = cr.getConnectionManager();
                if (cm != null && cm instanceof AbstractConnectionManager) {
                    ((AbstractConnectionManager)cm).doStop();
                }
            }
            catch (Exception e) {
                this.logger.debug("Not processing resource on destroy: " + className, e);
            }
            this.removeResourceMBean(name, "ConnectionFactory");
        } else if (DestroyableResource.class.isInstance(object)) {
            try {
                ((DestroyableResource)DestroyableResource.class.cast(object)).destroyResource();
            }
            catch (RuntimeException e) {
                this.logger.error(e.getMessage(), e);
            }
            this.removeResourceMBean(name, "Resource");
        } else if (!DataSource.class.isInstance(object)) {
            this.removeResourceMBean(name, "Resource");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Not processing resource on destroy: " + className);
            }
        }
    }

    private void removeResourceMBean(String name, String type) {
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("J2EEServer", "openejb");
        jmxName.set("J2EEApplication", null);
        jmxName.set("j2eeType", "");
        jmxName.set("name", name);
        MBeanServer server = LocalMBeanServer.get();
        try {
            ObjectName objectName = jmxName.set("j2eeType", type).build();
            if (server.isRegistered(objectName)) {
                server.unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to unregister MBean ", e);
        }
    }

    public ResourceInfo removeResourceInfo(String name) {
        try {
            Iterator<ResourceInfo> iterator;
            OpenEjbConfiguration configuration = SystemInstance.get().getComponent(OpenEjbConfiguration.class);
            if (configuration != null) {
                iterator = configuration.facilities.resources.iterator();
            } else {
                throw new Exception("OpenEjbConfiguration has not been initialized");
            }
            while (iterator.hasNext()) {
                ResourceInfo info = iterator.next();
                if (!name.equals(info.id)) continue;
                iterator.remove();
                return info;
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to purge resource on destroy: " + e.getMessage());
        }
        return null;
    }

    private static Object unwrapReference(Object object) {
        Object o = object;
        while (o != null && Reference.class.isInstance(o)) {
            try {
                o = ((Reference)((Object)Reference.class.cast(o))).getObject();
            }
            catch (NamingException namingException) {}
        }
        if (o == null) {
            o = object;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApplication(String filePath) throws UndeployException, NoSuchApplicationException {
        ReentrantLock l = lock;
        l.lock();
        try {
            AppInfo appInfo = this.deployedApplications.remove(filePath);
            if (appInfo == null) {
                throw new NoSuchApplicationException(filePath);
            }
            this.destroyApplication(appInfo);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void destroyApplication(AppContext appContext) throws UndeployException {
        ReentrantLock l = lock;
        l.lock();
        try {
            AppInfo appInfo = this.deployedApplications.remove(appContext.getId());
            if (appInfo == null) {
                throw new IllegalStateException(String.format("Cannot find AppInfo for app: %s", appContext.getId()));
            }
            this.destroyApplication(appInfo);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApplication(AppInfo appInfo) throws UndeployException {
        ReentrantLock l = lock;
        l.lock();
        try {
            String name;
            this.deployedApplications.remove(appInfo.path);
            this.logger.info("destroyApplication.start", appInfo.path);
            Context globalContext = this.containerSystem.getJNDIContext();
            AppContext appContext = this.containerSystem.getAppContext(appInfo.appId);
            if (null == appContext) {
                this.logger.warning("Application id '" + appInfo.appId + "' not found in: " + Arrays.toString(this.containerSystem.getAppContextKeys()));
                return;
            }
            ClassLoader classLoader = appContext.getClassLoader();
            SystemInstance.get().fireEvent(new AssemblerBeforeApplicationDestroyed(appInfo, appContext));
            WebBeansContext webBeansContext = appContext.getWebBeansContext();
            if (webBeansContext != null) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    Iterator<Map.Entry<String, Object>> context = appContext.isStandaloneModule() && appContext.getWebContexts().iterator().hasNext() ? appContext.getWebContexts().iterator().next().getServletContext() : null;
                    ((ContainerLifecycle)webBeansContext.getService(ContainerLifecycle.class)).stopApplication(context);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            Map<String, Object> cb = appContext.getBindings();
            for (Map.Entry<String, Object> value : cb.entrySet()) {
                String path = value.getKey();
                if (path.startsWith(GLOBAL_UNIQUE_ID)) {
                    path = "java:" + path;
                }
                if (!path.startsWith("java:global")) continue;
                if (IvmContext.class.isInstance(globalContext)) {
                    ((IvmContext)IvmContext.class.cast(globalContext)).setReadOnly(false);
                }
                this.unbind(globalContext, path);
                this.unbind(globalContext, "openejb/global/" + path.substring("java:".length()));
                this.unbind(globalContext, path.substring("java:global".length()));
            }
            if (appInfo.appId != null && !appInfo.appId.isEmpty() && !"openejb".equals(appInfo.appId)) {
                this.unbind(globalContext, "global/" + appInfo.appId);
                this.unbind(globalContext, appInfo.appId);
            }
            EjbResolver globalResolver = new EjbResolver(null, EjbResolver.Scope.GLOBAL, new EjbJarInfo[0]);
            for (AppInfo info : this.deployedApplications.values()) {
                globalResolver.addAll(info.ejbJars);
            }
            SystemInstance.get().setComponent(EjbResolver.class, globalResolver);
            UndeployException undeployException = new UndeployException(this.messages.format("destroyApplication.failed", appInfo.path));
            WebAppBuilder webAppBuilder = SystemInstance.get().getComponent(WebAppBuilder.class);
            if (webAppBuilder != null && !appInfo.webAppAlone) {
                try {
                    webAppBuilder.undeployWebApps(appInfo);
                }
                catch (Exception e) {
                    undeployException.getCauses().add(new Exception("App: " + appInfo.path + ": " + e.getMessage(), e));
                }
            }
            List<BeanContext> deployments = new ArrayList<BeanContext>();
            for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
                for (EnterpriseBeanInfo enterpriseBeanInfo : ejbJarInfo.enterpriseBeans) {
                    String string = enterpriseBeanInfo.ejbDeploymentId;
                    BeanContext beanContext = this.containerSystem.getBeanContext(string);
                    if (beanContext == null) {
                        undeployException.getCauses().add(new Exception("deployment not found: " + string));
                        continue;
                    }
                    deployments.add(beanContext);
                }
            }
            deployments = Assembler.sort(deployments);
            Collections.reverse(deployments);
            for (BeanContext beanContext : deployments) {
                String string = String.valueOf(beanContext.getDeploymentID());
                try {
                    Container container = beanContext.getContainer();
                    container.stop(beanContext);
                }
                catch (Throwable throwable) {
                    undeployException.getCauses().add(new Exception("bean: " + string + ": " + throwable.getMessage(), throwable));
                }
            }
            for (BeanContext beanContext : deployments) {
                String string = String.valueOf(beanContext.getDeploymentID());
                try {
                    Container container = beanContext.getContainer();
                    container.undeploy(beanContext);
                    beanContext.setContainer(null);
                }
                catch (Throwable throwable) {
                    undeployException.getCauses().add(new Exception("bean: " + string + ": " + throwable.getMessage(), throwable));
                }
                finally {
                    beanContext.setDestroyed(true);
                }
            }
            if (webAppBuilder != null && appInfo.webAppAlone) {
                try {
                    webAppBuilder.undeployWebApps(appInfo);
                }
                catch (Exception e) {
                    undeployException.getCauses().add(new Exception("App: " + appInfo.path + ": " + e.getMessage(), e));
                }
            }
            ArrayList<String> clientIds = new ArrayList<String>();
            for (ClientInfo clientInfo : appInfo.clients) {
                clientIds.add(clientInfo.moduleId);
                clientIds.addAll(clientInfo.localClients);
                clientIds.addAll(clientInfo.remoteClients);
            }
            for (WebContext webContext : appContext.getWebContexts()) {
                this.containerSystem.removeWebContext(webContext);
            }
            TldScanner.forceCompleteClean(classLoader);
            for (BeanContext beanContext : deployments) {
                JndiBuilder.Bindings bindings;
                String string = String.valueOf(beanContext.getDeploymentID());
                try {
                    this.containerSystem.removeBeanContext(beanContext);
                }
                catch (Throwable throwable) {
                    undeployException.getCauses().add(new Exception(string, throwable));
                }
                if ((bindings = beanContext.get(JndiBuilder.Bindings.class)) == null) continue;
                for (String name2 : bindings.getBindings()) {
                    try {
                        globalContext.unbind(name2);
                    }
                    catch (Throwable t) {
                        undeployException.getCauses().add(new Exception("bean: " + string + ": " + t.getMessage(), t));
                    }
                }
            }
            AsynchronousPool asynchronousPool = appContext.get(AsynchronousPool.class);
            if (asynchronousPool != null) {
                asynchronousPool.stop();
            }
            for (CommonInfoObject commonInfoObject : Assembler.listCommonInfoObjectsForAppInfo(appInfo)) {
                try {
                    globalContext.unbind("openejb/ValidatorFactory/" + commonInfoObject.uniqueId);
                    globalContext.unbind("openejb/Validator/" + commonInfoObject.uniqueId);
                }
                catch (NamingException namingException) {
                    if (!EjbJarInfo.class.isInstance(commonInfoObject)) continue;
                    undeployException.getCauses().add(new Exception("validator: " + commonInfoObject.uniqueId + ": " + namingException.getMessage(), namingException));
                }
            }
            try {
                if (globalContext instanceof IvmContext) {
                    IvmContext ivmContext = (IvmContext)globalContext;
                    ivmContext.prune("openejb/Deployment");
                    ivmContext.prune("openejb/local");
                    ivmContext.prune("openejb/remote");
                    ivmContext.prune("openejb/global");
                }
            }
            catch (NamingException namingException) {
                undeployException.getCauses().add(new Exception("Unable to prune openejb/Deployments and openejb/local namespaces, this could cause future deployments to fail.", namingException));
            }
            deployments.clear();
            for (String string : clientIds) {
                try {
                    globalContext.unbind("/openejb/client/" + string);
                }
                catch (Throwable throwable) {
                    undeployException.getCauses().add(new Exception("client: " + string + ": " + throwable.getMessage(), throwable));
                }
            }
            MBeanServer mBeanServer = LocalMBeanServer.get();
            for (Object object : appInfo.jmx.values()) {
                try {
                    CreationalContext cc;
                    ObjectName on = new ObjectName((String)object);
                    if (mBeanServer.isRegistered(on)) {
                        mBeanServer.unregisterMBean(on);
                    }
                    if ((cc = this.creationalContextForAppMbeans.remove(on)) == null) continue;
                    cc.release();
                }
                catch (InstanceNotFoundException e) {
                    this.logger.warning("can't unregister " + object + " because the mbean was not found", e);
                }
                catch (MBeanRegistrationException e) {
                    this.logger.warning("can't unregister " + object, e);
                }
                catch (MalformedObjectNameException mone) {
                    this.logger.warning("can't unregister because the ObjectName is malformed: " + object, mone);
                }
            }
            for (PersistenceUnitInfo persistenceUnitInfo : appInfo.persistenceUnits) {
                try {
                    Object object = globalContext.lookup("openejb/PersistenceUnit/" + persistenceUnitInfo.id);
                    globalContext.unbind("openejb/PersistenceUnit/" + persistenceUnitInfo.id);
                    ReloadableEntityManagerFactory remf = (ReloadableEntityManagerFactory)object;
                    remf.close();
                    this.persistenceClassLoaderHandler.destroy(persistenceUnitInfo.id);
                    remf.unregister();
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("persistence-unit: " + persistenceUnitInfo.id + ": " + t.getMessage(), t));
                }
            }
            for (String string : appInfo.resourceAliases) {
                name = "openejb/Resource/" + string;
                ContextualJndiReference.followReference.set(false);
                try {
                    Object object;
                    try {
                        object = globalContext.lookup(name);
                    }
                    finally {
                        ContextualJndiReference.followReference.remove();
                    }
                    if (object instanceof ContextualJndiReference) {
                        ContextualJndiReference contextualJndiReference = (ContextualJndiReference)((Object)ContextualJndiReference.class.cast(object));
                        contextualJndiReference.removePrefix(appContext.getId());
                        if (!contextualJndiReference.hasNoMorePrefix()) continue;
                        globalContext.unbind(name);
                        continue;
                    }
                    globalContext.unbind(name);
                }
                catch (NamingException e) {
                    this.logger.warning("can't unbind resource '{0}'", string);
                }
            }
            for (String string : appInfo.resourceIds) {
                name = "openejb/Resource/" + string;
                try {
                    this.destroyLookedUpResource(globalContext, string, name);
                }
                catch (NamingException e) {
                    this.logger.warning("can't unbind resource '{0}'", string);
                }
            }
            for (ConnectorInfo connectorInfo : appInfo.connectors) {
                if (connectorInfo.resourceAdapter == null || connectorInfo.resourceAdapter.id == null) continue;
                name = "openejb/Resource/" + connectorInfo.resourceAdapter.id;
                try {
                    this.destroyLookedUpResource(globalContext, connectorInfo.resourceAdapter.id, name);
                }
                catch (NamingException e) {
                    this.logger.warning("can't unbind resource '{0}'", connectorInfo);
                }
                for (ResourceInfo outbound : connectorInfo.outbound) {
                    try {
                        this.destroyLookedUpResource(globalContext, outbound.id, "openejb/Resource/" + outbound.id);
                    }
                    catch (Exception exception) {}
                }
                for (ResourceInfo outbound : connectorInfo.adminObject) {
                    try {
                        this.destroyLookedUpResource(globalContext, outbound.id, "openejb/Resource/" + outbound.id);
                    }
                    catch (Exception exception) {}
                }
                for (MdbContainerInfo container2 : connectorInfo.inbound) {
                    try {
                        this.containerSystem.removeContainer(container2.id);
                        this.config.containerSystem.containers.remove(container2);
                        this.containerSystem.getJNDIContext().unbind("openejb/" + container2.service + "/" + container2.id);
                    }
                    catch (Exception exception) {}
                }
            }
            for (ContainerInfo containerInfo : appInfo.containers) {
                if (containerInfo.applicationWide) continue;
                this.removeContainer(containerInfo.id);
            }
            this.containerSystem.removeAppContext(appInfo.appId);
            if (!appInfo.properties.containsKey("tomee.destroying")) {
                try {
                    Method method = classLoader.getClass().getMethod("internalStop", new Class[0]);
                    method.invoke((Object)classLoader, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (Exception exception) {
                    this.logger.error("error stopping classloader of webapp " + appInfo.appId, exception);
                }
                ClassLoaderUtil.cleanOpenJPACache(classLoader);
            }
            ClassLoaderUtil.destroyClassLoader(appInfo.appId, appInfo.path);
            if (undeployException.getCauses().size() > 0) {
                for (Throwable throwable : undeployException.getCauses()) {
                    this.logger.error("undeployException original cause", throwable);
                }
                throw undeployException;
            }
            this.logger.debug("destroyApplication.success", appInfo.path);
        }
        finally {
            l.unlock();
        }
    }

    private void destroyLookedUpResource(Context globalContext, String id, String name) throws NamingException {
        Object object;
        try {
            object = globalContext.lookup(name);
        }
        catch (NamingException e) {
            String ctx = name.substring(0, name.lastIndexOf(47));
            String objName = name.substring(ctx.length() + 1);
            NamingEnumeration<Binding> bindings = globalContext.listBindings(ctx);
            while (bindings.hasMoreElements()) {
                LazyObjectReference ref;
                Binding binding = (Binding)bindings.nextElement();
                if (!binding.getName().equals(objName) || !LazyObjectReference.class.isInstance(binding.getObject()) || (ref = (LazyObjectReference)((Object)LazyObjectReference.class.cast(binding.getObject()))).isInitialized()) continue;
                globalContext.unbind(name);
                this.removeResourceInfo(name);
                return;
            }
            throw e;
        }
        String clazz = object == null ? "?" : object.getClass().getName();
        this.destroyResource(id, clazz, object);
        globalContext.unbind(name);
    }

    private void unbind(Context context, String name) {
        try {
            context.unbind(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public ClassLoader createAppClassLoader(AppInfo appInfo) throws OpenEJBException, IOException {
        ClassLoaderEnricher component;
        if ("openejb".equals(appInfo.appId)) {
            return ParentClassLoaderFinder.Helper.get();
        }
        HashSet<URL> jars = new HashSet<URL>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            if (ejbJarInfo.path == null) continue;
            jars.add(this.toUrl(ejbJarInfo.path));
        }
        for (ClientInfo clientInfo : appInfo.clients) {
            if (clientInfo.path == null) continue;
            jars.add(this.toUrl(clientInfo.path));
        }
        for (ConnectorInfo connectorInfo : appInfo.connectors) {
            for (String jarPath : connectorInfo.libs) {
                jars.add(this.toUrl(jarPath));
            }
        }
        for (String string : appInfo.libs) {
            jars.add(this.toUrl(string));
        }
        if (appInfo.libs.size() > 0) {
            try {
                File jpaIntegrationFile = JarLocation.jarLocation(MakeTxLookup.class);
                URL uRL = jpaIntegrationFile.toURI().toURL();
                if (!jars.contains(uRL)) {
                    jars.add(uRL);
                }
            }
            catch (RuntimeException re) {
                this.logger.warning("Unable to find the open-jpa-integration jar");
            }
        }
        if ((component = SystemInstance.get().getComponent(ClassLoaderEnricher.class)) != null) {
            jars.addAll(Arrays.asList(component.applicationEnrichment()));
        } else {
            this.logger.warning("Unable to find open-jpa-integration jar");
        }
        ClassLoader classLoader = ParentClassLoaderFinder.Helper.get();
        String prefix = appInfo.webAppAlone ? "WEB-INF/" : "META-INF/";
        ClassLoaderConfigurer configurer1 = QuickJarsTxtParser.parse(new File(appInfo.path, prefix + "jars.txt"));
        ClassLoaderConfigurer configurer2 = ClassLoaderUtil.configurer(appInfo.appId);
        if (configurer1 != null || configurer2 != null) {
            CompositeClassLoaderConfigurer configurer = new CompositeClassLoaderConfigurer(configurer1, configurer2);
            ClassLoaderConfigurer.Helper.configure(jars, configurer);
        }
        URL[] filtered = jars.toArray(new URL[jars.size()]);
        if (this.skipLoaderIfPossible) {
            if ("classpath.ear".equals(appInfo.appId)) {
                return classLoader;
            }
            HashSet<File> urls = new HashSet<File>();
            for (URL url : ClassLoaders.findUrls((ClassLoader)classLoader)) {
                try {
                    urls.add(URLs.toFile(url).getCanonicalFile());
                }
                catch (Exception error) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Can't determine url for: " + url.toExternalForm(), error);
                }
            }
            boolean allIsIntheClasspath = true;
            for (URL url : filtered) {
                try {
                    if (urls.contains(URLs.toFile(url).getCanonicalFile())) continue;
                    allIsIntheClasspath = false;
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug(url.toExternalForm() + " (" + URLs.toFile(url) + ") is not in the classloader so we'll create a dedicated classloader for this app");
                }
                catch (Exception ignored) {
                    allIsIntheClasspath = false;
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug(url.toExternalForm() + " (" + URLs.toFile(url) + ") is not in the classloader", ignored);
                }
                break;
            }
            if (allIsIntheClasspath) {
                this.logger.info("Not creating another application classloader for " + appInfo.appId);
                return classLoader;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Logging all urls from the app since we don't skip the app classloader creation:");
                for (URL url : filtered) {
                    this.logger.debug(" -> " + url.toExternalForm());
                }
                this.logger.debug("Logging all urls from the classloader since we don't skip the app classloader creation:");
                for (File url : urls) {
                    this.logger.debug(" -> " + url.getAbsolutePath());
                }
            }
        }
        this.logger.info("Creating dedicated application classloader for " + appInfo.appId);
        if (!appInfo.delegateFirst) {
            return ClassLoaderUtil.createClassLoader(appInfo.path, filtered, classLoader);
        }
        return ClassLoaderUtil.createClassLoaderFirst(appInfo.path, filtered, classLoader);
    }

    public void createExternalContext(JndiContextInfo contextInfo) throws OpenEJBException {
        InitialContext initialContext;
        this.logger.getChildLogger("service").info("createService", contextInfo.service, contextInfo.id, contextInfo.className);
        try {
            initialContext = new InitialContext(contextInfo.properties);
        }
        catch (NamingException ne) {
            throw new OpenEJBException(String.format("JndiProvider(id=\"%s\") could not be created.  Failed to create the InitialContext using the supplied properties", contextInfo.id), ne);
        }
        try {
            this.containerSystem.getJNDIContext().bind("openejb/remote_jndi_contexts/" + contextInfo.id, (Object)initialContext);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + contextInfo.service + " with id " + contextInfo.id, e);
        }
        this.config.facilities.remoteJndiContexts.add(contextInfo);
        this.logger.getChildLogger("service").debug("createService.success", contextInfo.service, contextInfo.id, contextInfo.className);
    }

    public void createContainer(ContainerInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(Collections.emptyList(), serviceInfo);
        serviceRecipe.setProperty("id", (Object)serviceInfo.id);
        serviceRecipe.setProperty("transactionManager", this.props.get(TransactionManager.class.getName()));
        serviceRecipe.setProperty("securityService", this.props.get(org.apache.openejb.spi.SecurityService.class.getName()));
        serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe());
        this.replaceResourceAdapterProperty(serviceRecipe);
        Object service = serviceRecipe.create();
        serviceRecipe.getUnsetProperties().remove("id");
        serviceRecipe.getUnsetProperties().remove("securityService");
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.containerSystem.addContainer(serviceInfo.id, (Container)service);
        this.config.containerSystem.containers.add(serviceInfo);
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
        if (Container.class.isInstance(service) && LocalMBeanServer.isJMXActive()) {
            ObjectName objectName = ObjectNameBuilder.uniqueName("containers", serviceInfo.id, service);
            try {
                LocalMBeanServer.get().registerMBean(new DynamicMBeanWrapper(new JMXContainer(serviceInfo, (Container)service)), objectName);
                this.containerObjectNames.add(objectName);
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
    }

    private void bindService(ServiceInfo serviceInfo, Object service) throws OpenEJBException {
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service + "/" + serviceInfo.id, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException(this.messages.format("assembler.cannotBindServiceWithId", serviceInfo.service, serviceInfo.id), e);
        }
    }

    public void removeContainer(String containerId) {
        this.containerSystem.removeContainer(containerId);
        Iterator<ContainerInfo> iterator = this.config.containerSystem.containers.iterator();
        while (iterator.hasNext()) {
            ContainerInfo containerInfo = iterator.next();
            if (!containerInfo.id.equals(containerId)) continue;
            iterator.remove();
            try {
                this.containerSystem.getJNDIContext().unbind("openejb/" + containerInfo.service + "/" + containerInfo.id);
            }
            catch (Exception e) {
                this.logger.error("removeContainer.unbindFailed", containerId);
            }
        }
    }

    public void createService(ServiceInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(Collections.emptyList(), serviceInfo);
        serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe());
        Object service = serviceRecipe.create();
        SystemInstance.get().addObserver(service);
        Assembler.logUnusedProperties(serviceRecipe, serviceInfo);
        Class<?> serviceClass = service.getClass();
        Assembler.getContext().put(serviceClass.getName(), service);
        this.props.put(serviceClass.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.services.add(serviceInfo);
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createProxyFactory(ProxyFactoryInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(Collections.emptyList(), serviceInfo);
        Object service = serviceRecipe.create();
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        ProxyManager.registerFactory(serviceInfo.id, (ProxyFactory)service);
        ProxyManager.setDefaultFactory(serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.intraVmServer = serviceInfo;
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    private void replaceResourceAdapterProperty(ObjectRecipe serviceRecipe) throws OpenEJBException {
        Object resourceAdapterId = serviceRecipe.getProperty("ResourceAdapter");
        if (resourceAdapterId instanceof String) {
            String id = (String)resourceAdapterId;
            id = id.trim();
            Object resourceAdapter = null;
            try {
                resourceAdapter = this.containerSystem.getJNDIContext().lookup("openejb/Resource/" + id);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (Reference.class.isInstance(resourceAdapter)) {
                try {
                    resourceAdapter = ((Reference)((Object)Reference.class.cast(resourceAdapter))).getContent();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if (resourceAdapter == null) {
                throw new OpenEJBException("No existing resource adapter defined with id '" + id + "'.");
            }
            if (ResourceAdapterReference.class.isInstance(resourceAdapter)) {
                resourceAdapter = ((ResourceAdapterReference)((Object)ResourceAdapterReference.class.cast(resourceAdapter))).getRa();
            }
            if (!(resourceAdapter instanceof ResourceAdapter)) {
                throw new OpenEJBException(this.messages.format("assembler.resourceAdapterNotResourceAdapter", id, resourceAdapter.getClass()));
            }
            serviceRecipe.setProperty("ResourceAdapter", resourceAdapter);
        }
    }

    @Deprecated
    public void createResource(ResourceInfo serviceInfo) throws OpenEJBException {
        this.createResource(null, serviceInfo);
    }

    public void createResource(Collection<ServiceInfo> infos, ResourceInfo serviceInfo) throws OpenEJBException {
        Object service;
        boolean usesCdiPwdCipher = this.usesCdiPwdCipher(serviceInfo);
        Object object = service = "true".equalsIgnoreCase(String.valueOf(serviceInfo.properties.remove("Lazy"))) || usesCdiPwdCipher ? this.newLazyResource(infos, serviceInfo) : this.doCreateResource(infos, serviceInfo);
        if (usesCdiPwdCipher && !serviceInfo.properties.contains("InitializeAfterDeployment")) {
            serviceInfo.properties.put("InitializeAfterDeployment", "true");
        }
        this.bindResource(serviceInfo.id, service, false);
        for (String alias : serviceInfo.aliases) {
            this.bindResource(alias, service, false);
        }
        if (!(serviceInfo.originAppName == null || serviceInfo.originAppName.isEmpty() || "/".equals(serviceInfo.originAppName) || serviceInfo.id.startsWith(GLOBAL_UNIQUE_ID))) {
            String baseJndiName = serviceInfo.id.substring(serviceInfo.originAppName.length() + 1);
            serviceInfo.aliases.add(baseJndiName);
            ContextualJndiReference ref = new ContextualJndiReference(baseJndiName);
            ref.addPrefix(serviceInfo.originAppName);
            this.bindResource(baseJndiName, (Object)ref, false);
        }
        this.config.facilities.resources.add(serviceInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
        }
    }

    private boolean usesCdiPwdCipher(ResourceInfo serviceInfo) {
        for (Object val : serviceInfo.properties.values()) {
            if (!String.valueOf(val).startsWith("cipher:cdi:")) continue;
            return true;
        }
        return false;
    }

    private LazyResource newLazyResource(final Collection<ServiceInfo> infos, final ResourceInfo serviceInfo) {
        return new LazyResource(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                boolean appClassLoader = "true".equals(serviceInfo.properties.remove("UseAppClassLoader")) || serviceInfo.originAppName != null;
                Thread thread = Thread.currentThread();
                ClassLoader old = thread.getContextClassLoader();
                if (!appClassLoader) {
                    ClassLoader classLoader = Assembler.class.getClassLoader();
                    thread.setContextClassLoader(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
                }
                try {
                    Object object = Assembler.this.doCreateResource(infos, serviceInfo);
                    return object;
                }
                finally {
                    thread.setContextClassLoader(old);
                }
            }
        });
    }

    private Object doCreateResource(Collection<ServiceInfo> infos, ResourceInfo serviceInfo) throws OpenEJBException {
        String skipPropertiesFallback = (String)serviceInfo.properties.remove("SkipPropertiesFallback");
        final ObjectRecipe serviceRecipe = this.createRecipe(infos, serviceInfo);
        boolean properties = PropertiesFactory.class.getName().equals(serviceInfo.className);
        if ("false".equalsIgnoreCase(serviceInfo.properties.getProperty("SkipImplicitAttributes", "false")) && !properties) {
            serviceRecipe.setProperty("transactionManager", (Object)this.transactionManager);
            serviceRecipe.setProperty("ServiceId", (Object)serviceInfo.id);
        }
        serviceInfo.properties.remove("SkipImplicitAttributes");
        final AtomicReference<8> injectedProperties = new AtomicReference<8>();
        if (!"true".equalsIgnoreCase(skipPropertiesFallback)) {
            serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe(){

                protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
                    final Map original = serviceRecipe.getUnsetProperties();
                    SuperProperties properties = new SuperProperties(){

                        @Override
                        public Object remove(Object key) {
                            original.remove(key);
                            return super.remove(key);
                        }
                    }.caseInsensitive(true);
                    for (Map.Entry entry : original.entrySet()) {
                        ((Properties)properties).put(entry.getKey(), entry.getValue());
                    }
                    injectedProperties.set(properties);
                    return properties;
                }
            });
        } else {
            final Map unsetProperties = serviceRecipe.getUnsetProperties();
            injectedProperties.set(new Properties(){

                @Override
                public String getProperty(String key) {
                    Object obj = unsetProperties.get(key);
                    return String.class.isInstance(obj) ? String.valueOf(obj) : null;
                }

                @Override
                public Set<String> stringPropertyNames() {
                    return unsetProperties.keySet();
                }

                @Override
                public Set<Object> keySet() {
                    return (Set)Set.class.cast(unsetProperties.keySet());
                }

                @Override
                public synchronized boolean containsKey(Object key) {
                    return this.getProperty(String.valueOf(key)) != null;
                }
            });
        }
        if (serviceInfo.types.contains("DataSource") || serviceInfo.types.contains(DataSource.class.getName())) {
            Properties props = PropertyPlaceHolderHelper.simpleHolds(serviceInfo.properties);
            if (serviceInfo.properties.containsKey("Definition")) {
                Object encoding = serviceInfo.properties.remove("DefinitionEncoding");
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(serviceInfo.properties.getProperty("Definition").getBytes(encoding != null ? encoding.toString() : "ISO-8859-1"));
                    SuperProperties p = new SuperProperties();
                    IO.readProperties(is, (Properties)p);
                    for (Map.Entry<Object, Object> entry : ((Properties)p).entrySet()) {
                        String key = entry.getKey().toString();
                        if (props.containsKey(key) || key.equalsIgnoreCase("url") && props.containsKey("JdbcUrl")) continue;
                        props.put(key, entry.getValue());
                    }
                }
                catch (Exception is) {
                    // empty catch block
                }
            }
            serviceRecipe.setProperty("Definition", (Object)PropertiesHelper.propertiesToString(props));
        }
        this.replaceResourceAdapterProperty(serviceRecipe);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean customLoader = false;
        try {
            if (serviceInfo.classpath != null && serviceInfo.classpath.length > 0) {
                URL[] urls = new URL[serviceInfo.classpath.length];
                for (int i = 0; i < serviceInfo.classpath.length; ++i) {
                    urls[i] = serviceInfo.classpath[i].toURL();
                }
                loader = new URLClassLoaderFirst(urls, loader);
                customLoader = true;
                serviceRecipe.setProperty("OpenEJBResourceClasspath", (Object)"true");
            }
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException("Unable to create a classloader for " + serviceInfo.id, e);
        }
        if (!customLoader && serviceInfo.classpathAPI != null) {
            throw new IllegalArgumentException("custom-api provided but not classpath used for " + serviceInfo.id);
        }
        Object service = serviceRecipe.create(loader);
        if (customLoader) {
            ArrayList<Class<Object>> apis;
            if (serviceInfo.classpathAPI == null) {
                apis = new ArrayList(Arrays.asList(service.getClass().getInterfaces()));
            } else {
                String[] split = serviceInfo.classpathAPI.split(" *, *");
                apis = new ArrayList(split.length);
                ClassLoader apiLoader = Thread.currentThread().getContextClassLoader();
                for (String fqn : split) {
                    try {
                        apis.add(apiLoader.loadClass(fqn));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException(fqn + " not usable as API for " + serviceInfo.id, e);
                    }
                }
            }
            if (apis.size() - (apis.contains(Serializable.class) ? 1 : 0) - (apis.contains(Externalizable.class) ? 1 : 0) > 0) {
                service = Proxy.newProxyInstance(loader, apis.toArray(new Class[apis.size()]), (InvocationHandler)new ClassLoaderAwareHandler(null, service, loader));
            }
        }
        serviceInfo.unsetProperties = (Properties)injectedProperties.get();
        if (service instanceof ResourceAdapter) {
            SimpleWorkManager workManager;
            ExecutorService threadPool;
            ResourceAdapter resourceAdapter = (ResourceAdapter)service;
            int threadPoolSize = this.getIntProperty(serviceInfo.properties, "threadPoolSize", 30);
            if (threadPoolSize <= 0) {
                this.logger.warning("Thread pool for '" + serviceInfo.id + "' is (unbounded), consider setting a size using: " + serviceInfo.id + ".QueueSize=[size]");
                threadPool = Executors.newCachedThreadPool(new DaemonThreadFactory(serviceInfo.id + "-worker-"));
            } else {
                threadPool = new ExecutorBuilder().size(threadPoolSize).prefix(serviceInfo.id).threadFactory(new DaemonThreadFactory(serviceInfo.id + "-worker-")).build(new Options(serviceInfo.properties, SystemInstance.get().getOptions()));
                this.logger.info("Thread pool size for '" + serviceInfo.id + "' is (" + threadPoolSize + ")");
            }
            if (GeronimoTransactionManager.class.isInstance(this.transactionManager)) {
                GeronimoTransactionManager geronimoTransactionManager = (GeronimoTransactionManager)this.transactionManager;
                TransactionContextHandler txWorkContextHandler = new TransactionContextHandler((XAWork)geronimoTransactionManager);
                String securityRealmName = this.getStringProperty(serviceInfo.properties, "realm", serviceInfo.id);
                SecurityContextHandler securityContextHandler = new SecurityContextHandler(securityRealmName);
                HintsContextHandler hintsContextHandler = new HintsContextHandler();
                ArrayList<Object> workContextHandlers = new ArrayList<Object>();
                workContextHandlers.add(txWorkContextHandler);
                workContextHandlers.add(securityContextHandler);
                workContextHandlers.add(hintsContextHandler);
                workManager = new GeronimoWorkManager((Executor)threadPool, (Executor)threadPool, (Executor)threadPool, workContextHandlers);
            } else {
                workManager = new SimpleWorkManager(threadPool);
            }
            SimpleBootstrapContext bootstrapContext = this.transactionManager instanceof GeronimoTransactionManager ? new GeronimoBootstrapContext((GeronimoWorkManager)GeronimoWorkManager.class.cast(workManager), (XATerminator)((GeronimoTransactionManager)this.transactionManager), (TransactionSynchronizationRegistry)((GeronimoTransactionManager)this.transactionManager)) : (this.transactionManager instanceof XATerminator ? new SimpleBootstrapContext(workManager, (XATerminator)this.transactionManager) : new SimpleBootstrapContext(workManager));
            try {
                this.logger.debug("createResource.startingResourceAdapter", serviceInfo.id, service.getClass().getName());
                resourceAdapter.start((BootstrapContext)bootstrapContext);
            }
            catch (ResourceAdapterInternalException e) {
                throw new OpenEJBException(e);
            }
            Map unset = serviceRecipe.getUnsetProperties();
            unset.remove("threadPoolSize");
            Assembler.logUnusedProperties(unset, (ServiceInfo)serviceInfo);
            this.registerAsMBean(serviceInfo.id, "ResourceAdapter", resourceAdapter);
            service = new ResourceAdapterReference(resourceAdapter, threadPool, "openejb/Resource/" + serviceInfo.id);
        } else if (service instanceof ManagedConnectionFactory) {
            ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)service;
            ObjectRecipe connectionManagerRecipe = new ObjectRecipe(GeronimoConnectionManagerFactory.class, "create");
            connectionManagerRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
            connectionManagerRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            connectionManagerRecipe.setAllProperties((Map)serviceInfo.properties);
            connectionManagerRecipe.setProperty("name", (Object)serviceInfo.id);
            connectionManagerRecipe.setProperty("mcf", (Object)managedConnectionFactory);
            connectionManagerRecipe.setProperty("transactionManager", (Object)this.transactionManager);
            ClassLoader classLoader = loader;
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            connectionManagerRecipe.setProperty("classLoader", (Object)classLoader);
            this.logger.getChildLogger("service").info("createResource.createConnectionManager", serviceInfo.id, service.getClass().getName());
            ConnectionManager connectionManager = (ConnectionManager)connectionManagerRecipe.create();
            String txSupport = "xa";
            try {
                txSupport = (String)connectionManagerRecipe.getProperty("transactionSupport");
            }
            catch (Exception unset) {
                // empty catch block
            }
            if (txSupport == null || txSupport.trim().length() == 0) {
                txSupport = "xa";
            }
            if (connectionManager == null) {
                throw new OpenEJBRuntimeException(this.messages.format("assembler.invalidConnectionManager", serviceInfo.id));
            }
            Map unsetA = serviceRecipe.getUnsetProperties();
            Map unsetB = connectionManagerRecipe.getUnsetProperties();
            HashMap unset = new HashMap();
            for (Map.Entry entry : unsetA.entrySet()) {
                if (!unsetB.containsKey(entry.getKey())) continue;
                unset.put(entry.getKey(), entry.getValue());
            }
            service = new ConnectorReference(connectionManager, managedConnectionFactory);
            Object eagerInit = unset.remove("eagerInit");
            if (eagerInit != null && eagerInit instanceof String && "true".equalsIgnoreCase((String)eagerInit) && connectionManager instanceof AbstractConnectionManager) {
                try {
                    ((AbstractConnectionManager)connectionManager).doStart();
                    try {
                        Object cf = managedConnectionFactory.createConnectionFactory(connectionManager);
                        if (cf instanceof ConnectionFactory) {
                            Connection connection = ((ConnectionFactory)cf).getConnection();
                            connection.getMetaData();
                            connection.close();
                        }
                    }
                    catch (Exception cf) {}
                }
                catch (Exception e) {
                    this.logger.warning("Can't start connection manager", e);
                }
            }
            Assembler.logUnusedProperties(unset, (ServiceInfo)serviceInfo);
        } else if (service instanceof DataSource) {
            Properties prop;
            String url;
            ObjectRecipe recipe;
            ImportSql importer;
            ClassLoader classLoader = loader;
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if ((importer = new ImportSql(classLoader, serviceInfo.id, (DataSource)service)).hasSomethingToImport()) {
                importer.doImport();
            }
            if ((recipe = DataSourceFactory.forgetRecipe(service, serviceRecipe)) != serviceRecipe || !serviceInfo.properties.containsKey("XaDataSource")) {
                Assembler.logUnusedProperties(recipe, (ServiceInfo)serviceInfo);
            }
            if ((url = (prop = serviceInfo.properties).getProperty("JdbcUrl", prop.getProperty("url"))) == null) {
                url = prop.getProperty("jdbcUrl");
            }
            if (url == null) {
                this.logger.debug("Unable to find url for " + serviceInfo.id + " will not monitor it");
            } else {
                String host = Assembler.extractHost(url);
                if (host != null) {
                    this.remoteResourceMonitor.addHost(host);
                    this.remoteResourceMonitor.registerIfNot();
                }
            }
        } else if (!Properties.class.isInstance(service)) {
            if (serviceInfo.unsetProperties == null || Assembler.isTemplatizedResource(serviceInfo)) {
                Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
            }
            this.registerAsMBean(serviceInfo.id, "Resource", service);
        }
        ResourceCreated event = new ResourceCreated(service, serviceInfo.id);
        SystemInstance.get().fireEvent(event);
        return event.getReplacement() == null ? service : event.getReplacement();
    }

    private void registerAsMBean(String name, String type, Object resource) {
        MBeanServer server = LocalMBeanServer.get();
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("J2EEServer", "openejb");
        jmxName.set("J2EEApplication", null);
        jmxName.set("j2eeType", "");
        jmxName.set("name", name);
        try {
            ObjectName objectName = jmxName.set("j2eeType", type).build();
            if (server.isRegistered(objectName)) {
                server.unregisterMBean(objectName);
            }
            if (DynamicMBean.class.isInstance(resource)) {
                server.registerMBean(resource, objectName);
            } else {
                server.registerMBean(new MBeanPojoWrapper(name, resource), objectName);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to register MBean ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindResource(String id, Object service, boolean canReplace) throws OpenEJBException {
        String name = "openejb/Resource/" + id;
        Context jndiContext = this.containerSystem.getJNDIContext();
        Object existing = null;
        try {
            ContextualJndiReference.followReference.set(false);
            existing = jndiContext.lookup(name);
        }
        catch (Exception exception) {
        }
        finally {
            ContextualJndiReference.followReference.remove();
        }
        boolean rebind = false;
        if (existing != null) {
            boolean existingIsContextual = ContextualJndiReference.class.isInstance(existing);
            boolean serviceIsExisting = ContextualJndiReference.class.isInstance(service);
            if (!existingIsContextual && serviceIsExisting) {
                ((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(service))).setDefaultValue(existing);
                rebind = true;
            } else if (existingIsContextual && !serviceIsExisting) {
                ((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(existing))).setDefaultValue(service);
            } else if (existingIsContextual) {
                ContextualJndiReference contextual = (ContextualJndiReference)((Object)ContextualJndiReference.class.cast(existing));
                if (canReplace && contextual.prefixesSize() == 1) {
                    contextual.removePrefix(contextual.lastPrefix());
                    contextual.setDefaultValue(service);
                } else {
                    contextual.addPrefix(((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(service))).lastPrefix());
                }
                return;
            }
        }
        try {
            if (canReplace && existing != null) {
                jndiContext.unbind(name);
            }
            if (rebind) {
                jndiContext.rebind(name, service);
            } else {
                jndiContext.bind(name, service);
            }
        }
        catch (NameAlreadyBoundException nabe) {
            this.logger.warning("unbounding resource " + name + " can happen because of a redeployment or because of a duplicated id");
            try {
                jndiContext.unbind(name);
                jndiContext.bind(name, service);
            }
            catch (NamingException e) {
                throw new OpenEJBException("Cannot bind resource adapter with id " + id, e);
            }
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind resource adapter with id " + id, e);
        }
    }

    private static String extractHost(String url) {
        if (url == null || !url.contains("://")) {
            return null;
        }
        int idx = url.indexOf("://");
        String subUrl = url.substring(idx + 3);
        int port = subUrl.indexOf(58);
        int slash = subUrl.indexOf(47);
        int end = port;
        if (end < 0 || slash > 0 && slash < end) {
            end = slash;
        }
        if (end > 0) {
            return subUrl.substring(0, end);
        }
        return subUrl;
    }

    private int getIntProperty(Properties properties, String propertyName, int defaultValue) {
        String propertyValue = this.getStringProperty(properties, propertyName, Integer.toString(defaultValue));
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(propertyName + " is not an integer " + propertyValue, e);
        }
    }

    private String getStringProperty(Properties properties, String propertyName, String defaultValue) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    public void createConnectionManager(ConnectionManagerInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(Collections.emptyList(), serviceInfo);
        Object object = this.props.get("TransactionManager");
        serviceRecipe.setProperty("transactionManager", object);
        Object service = serviceRecipe.create();
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.connectionManagers.add(serviceInfo);
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createSecurityService(SecurityServiceInfo serviceInfo) throws OpenEJBException {
        Object service = SystemInstance.get().getComponent(org.apache.openejb.spi.SecurityService.class);
        if (service == null) {
            ObjectRecipe serviceRecipe = this.createRecipe(Collections.emptyList(), serviceInfo);
            service = serviceRecipe.create();
            Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        }
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + serviceInfo.service + " with id " + serviceInfo.id, e);
        }
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.securityService = (org.apache.openejb.spi.SecurityService)service;
        this.config.facilities.securityService = serviceInfo;
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createTransactionManager(TransactionServiceInfo serviceInfo) throws OpenEJBException {
        Object service = SystemInstance.get().getComponent(TransactionManager.class);
        if (service == null) {
            ObjectRecipe serviceRecipe = this.createRecipe(Collections.emptyList(), serviceInfo);
            service = serviceRecipe.create();
            Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        } else {
            this.logger.info("Reusing provided TransactionManager " + service);
        }
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service, service);
            this.containerSystem.getJNDIContext().bind("comp/UserTransaction", (Object)new CoreUserTransaction((TransactionManager)service));
            this.containerSystem.getJNDIContext().bind("comp/TransactionManager", service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + serviceInfo.service + " with id " + serviceInfo.id, e);
        }
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.transactionManager = (TransactionManager)service;
        this.config.facilities.transactionService = serviceInfo;
        Object synchronizationRegistry = this.transactionManager instanceof TransactionSynchronizationRegistry ? (TransactionSynchronizationRegistry)this.transactionManager : new SimpleTransactionSynchronizationRegistry(this.transactionManager);
        Assembler.getContext().put(TransactionSynchronizationRegistry.class.getName(), synchronizationRegistry);
        SystemInstance.get().setComponent(TransactionSynchronizationRegistry.class, synchronizationRegistry);
        try {
            this.containerSystem.getJNDIContext().bind("comp/TransactionSynchronizationRegistry", (Object)new TransactionSynchronizationRegistryWrapper());
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind java:comp/TransactionSynchronizationRegistry", e);
        }
        JtaEntityManagerRegistry jtaEntityManagerRegistry = new JtaEntityManagerRegistry((TransactionSynchronizationRegistry)synchronizationRegistry);
        Assembler.getContext().put(JtaEntityManagerRegistry.class.getName(), jtaEntityManagerRegistry);
        SystemInstance.get().setComponent(JtaEntityManagerRegistry.class, jtaEntityManagerRegistry);
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public static void logUnusedProperties(ObjectRecipe serviceRecipe, ServiceInfo info) {
        Map unsetProperties = serviceRecipe.getUnsetProperties();
        Assembler.logUnusedProperties(unsetProperties, info);
    }

    private static void logUnusedProperties(Map<String, ?> unsetProperties, ServiceInfo info) {
        if (Assembler.isPassthroughType(info)) {
            return;
        }
        boolean ignoreJdbcDefault = "Annotation".equalsIgnoreCase(info.properties.getProperty("Origin"));
        Logger logger = null;
        for (String property : unsetProperties.keySet()) {
            if (ignoreJdbcDefault && ("JdbcUrl".equals(property) || "UserName".equals(property) || "Password".equals(property) || "PasswordCipher".equals(property)) || property.equalsIgnoreCase("Definition") || property.equalsIgnoreCase("SkipImplicitAttributes") || property.equalsIgnoreCase("JndiName") || property.equalsIgnoreCase("Origin") || property.equalsIgnoreCase("DatabaseName")) continue;
            if (property.equalsIgnoreCase("connectionAttributes")) {
                return;
            }
            if (property.equalsIgnoreCase("properties")) {
                return;
            }
            if (property.equalsIgnoreCase("ApplicationWide") || property.equalsIgnoreCase("OpenEJBResourceClasspath") || Assembler.isInternalProperty(property) || info.types.isEmpty() && "class".equalsIgnoreCase(property) || "destination".equalsIgnoreCase(property) && info.id.equals(unsetProperties.get("destination"))) continue;
            if (logger == null) {
                Assembler assembler = SystemInstance.get().getComponent(Assembler.class);
                if (assembler != null) {
                    logger = assembler.logger;
                } else {
                    System.err.println("Assembler has not been initialized");
                }
            }
            Assembler.unusedProperty(info.id, logger, property);
        }
    }

    private static boolean isPassthroughType(ServiceInfo info) {
        return info.types.contains("javax.mail.Session");
    }

    private static void unusedProperty(String id, Logger parentLogger, String property) {
        if (Assembler.isInternalProperty(property)) {
            return;
        }
        String msg = "unused property '" + property + "' for resource '" + id + "'";
        if (null != parentLogger) {
            parentLogger.getChildLogger("service").warning(msg);
        } else {
            System.out.println(msg);
        }
    }

    private static boolean isInternalProperty(String property) {
        return property.equalsIgnoreCase("ServiceId") || property.equalsIgnoreCase("transactionManager");
    }

    private static void unusedProperty(String id, String property) {
        Assembler component = SystemInstance.get().getComponent(Assembler.class);
        Logger logger = component != null ? component.logger : null;
        Assembler.unusedProperty(id, logger, property);
    }

    public static ObjectRecipe prepareRecipe(ServiceInfo info) {
        String[] constructorArgs = info.constructorArgs.toArray(new String[info.constructorArgs.size()]);
        ObjectRecipe serviceRecipe = new ObjectRecipe(info.className, info.factoryMethod, constructorArgs, null);
        serviceRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        serviceRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        serviceRecipe.allow(Option.PRIVATE_PROPERTIES);
        return serviceRecipe;
    }

    private ObjectRecipe createRecipe(Collection<ServiceInfo> services, ServiceInfo info) {
        Logger serviceLogger = this.logger.getChildLogger("service");
        if (info instanceof ResourceInfo) {
            List<String> aliasesList = ((ResourceInfo)info).aliases;
            if (!aliasesList.isEmpty()) {
                String aliases = Join.join(", ", aliasesList);
                serviceLogger.info("createServiceWithAliases", info.service, info.id, aliases);
            } else {
                serviceLogger.info("createService", info.service, info.id);
            }
        } else {
            serviceLogger.info("createService", info.service, info.id);
        }
        ObjectRecipe serviceRecipe = Assembler.prepareRecipe(info);
        Object value = info.properties.remove("SkipImplicitAttributes");
        Properties allProperties = PropertyPlaceHolderHelper.simpleHolds(info.properties);
        allProperties.remove("SkipPropertiesFallback");
        if (services == null) {
            serviceRecipe.setAllProperties((Map)allProperties);
        } else {
            info.properties = allProperties;
            ServiceInfos.setProperties(services, info, serviceRecipe);
        }
        if (value != null) {
            info.properties.put("SkipImplicitAttributes", value);
        }
        if (serviceLogger.isDebugEnabled()) {
            for (Map.Entry entry : serviceRecipe.getProperties().entrySet()) {
                serviceLogger.debug("createService.props", entry.getKey(), entry.getValue());
            }
        }
        return serviceRecipe;
    }

    private void setSystemInstanceComponent(Class interfce, Object service) {
        SystemInstance.get().setComponent(interfce, service);
    }

    private URL toUrl(String jarPath) throws OpenEJBException {
        try {
            return new File(jarPath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException(this.messages.format("cl0001", jarPath, e.getMessage()), e);
        }
    }

    static {
        JULLoggerFactory.class.getName();
        OPENEJB_URL_PKG_PREFIX = IvmContext.class.getPackage().getName();
        lock = new ReentrantLock(true);
        VALIDATOR_FACTORY_INTERFACES = new Class[]{ValidatorFactory.class, Serializable.class};
        VALIDATOR_INTERFACES = new Class[]{Validator.class};
        context = new ThreadLocal();
    }

    public static class ResourceInstance
    extends Reference
    implements Serializable,
    DestroyableResource {
        private final String name;
        private final Object delegate;
        private final transient Collection<Method> preDestroys;
        private final transient CreationalContext<?> context;
        private volatile boolean destroyed = false;

        public ResourceInstance(String name, Object delegate, Collection<Method> preDestroys, CreationalContext<?> context) {
            this.name = name;
            this.delegate = delegate;
            this.preDestroys = preDestroys;
            this.context = context;
        }

        @Override
        public Object getObject() throws NamingException {
            return this.delegate;
        }

        public synchronized void destroyResource() {
            if (this.destroyed) {
                return;
            }
            Object o = Assembler.unwrapReference(this.delegate);
            for (Method m : this.preDestroys) {
                try {
                    if (!m.isAccessible()) {
                        SetAccessible.on(m);
                    }
                    m.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    Assembler component = SystemInstance.get().getComponent(Assembler.class);
                    if (component != null) {
                        component.logger.error(e.getMessage(), e);
                        continue;
                    }
                    System.err.println("" + e.getMessage());
                }
            }
            try {
                if (this.context != null) {
                    this.context.release();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.destroyed = true;
        }

        Object readResolve() throws ObjectStreamException {
            try {
                ContainerSystem component = SystemInstance.get().getComponent(ContainerSystem.class);
                if (component != null) {
                    return component.getJNDIContext().lookup(this.name);
                }
                throw new Exception("ContainerSystem is not initialized");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class LazyResource
    extends LazyObjectReference<Object> {
        public LazyResource(Callable<Object> creator) {
            super(creator);
        }

        Object writeReplace() throws ObjectStreamException {
            try {
                return this.getObject();
            }
            catch (NamingException e) {
                return null;
            }
        }
    }

    public static final class ResourceAdapterReference
    extends Reference {
        private final transient ResourceAdapter ra;
        private final transient Executor pool;
        private final String jndi;

        public ResourceAdapterReference(ResourceAdapter ra, Executor pool, String jndi) {
            this.ra = ra;
            this.pool = pool;
            this.jndi = jndi;
        }

        public Executor getPool() {
            return this.pool;
        }

        public ResourceAdapter getRa() {
            return this.ra;
        }

        public String getJndi() {
            return this.jndi;
        }

        @Override
        public Object getObject() throws NamingException {
            return this.ra;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                ContainerSystem component = SystemInstance.get().getComponent(ContainerSystem.class);
                if (component != null) {
                    return component.getJNDIContext().lookup(this.jndi);
                }
                throw new NamingException("ContainerSystem has not been initialized");
            }
            catch (NamingException e) {
                InvalidObjectException objectException = new InvalidObjectException("name not found: " + this.jndi);
                objectException.initCause(e);
                throw objectException;
            }
        }
    }

    private static final class DestroyingResource {
        private final String name;
        private final String clazz;
        private final Object instance;

        private DestroyingResource(String name, String clazz, Object instance) {
            this.name = name;
            this.clazz = clazz;
            this.instance = instance;
        }
    }

    public static class DeploymentListenerObserver {
        private final DeploymentListener delegate;

        public DeploymentListenerObserver(DeploymentListener deploymentListener) {
            this.delegate = deploymentListener;
        }

        public void afterApplicationCreated(@Observes AssemblerAfterApplicationCreated event) {
            this.delegate.afterApplicationCreated(event.getApp());
        }

        public void beforeApplicationDestroyed(@Observes AssemblerBeforeApplicationDestroyed event) {
            this.delegate.beforeApplicationDestroyed(event.getApp());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeploymentListenerObserver)) {
                return false;
            }
            DeploymentListenerObserver that = (DeploymentListenerObserver)o;
            return Objects.equals(this.delegate, that.delegate);
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }

    private static class PersistenceClassLoaderHandlerImpl
    implements PersistenceClassLoaderHandler {
        private static final AtomicBoolean logged = new AtomicBoolean(false);
        private final Map<String, List<ClassFileTransformer>> transformers = new TreeMap<String, List<ClassFileTransformer>>();

        private PersistenceClassLoaderHandlerImpl() {
        }

        @Override
        public void addTransformer(String unitId, ClassLoader classLoader, ClassFileTransformer classFileTransformer) {
            Instrumentation instrumentation = Agent.getInstrumentation();
            if (instrumentation != null) {
                instrumentation.addTransformer(classFileTransformer);
                if (unitId != null) {
                    List transformers = this.transformers.computeIfAbsent(unitId, k -> new ArrayList(1));
                    transformers.add(classFileTransformer);
                }
            } else if (!logged.getAndSet(true)) {
                Assembler assembler = SystemInstance.get().getComponent(Assembler.class);
                if (assembler != null) {
                    assembler.logger.info("assembler.noAgent");
                } else {
                    System.err.println("addTransformer: Assembler not initialized: JAVA AGENT NOT INSTALLED");
                }
            }
        }

        @Override
        public void destroy(String unitId) {
            List<ClassFileTransformer> transformers = this.transformers.remove(unitId);
            if (transformers != null) {
                Instrumentation instrumentation = Agent.getInstrumentation();
                if (instrumentation != null) {
                    for (ClassFileTransformer transformer : transformers) {
                        instrumentation.removeTransformer(transformer);
                    }
                } else {
                    Assembler assembler = SystemInstance.get().getComponent(Assembler.class);
                    if (assembler != null) {
                        assembler.logger.info("assembler.noAgent");
                    } else {
                        System.err.println("destroy: Assembler not initialized: JAVA AGENT NOT INSTALLED");
                    }
                }
            }
        }

        @Override
        public ClassLoader getNewTempClassLoader(ClassLoader classLoader) {
            return ClassLoaderUtil.createTempClassLoader(classLoader);
        }
    }
}

