/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd.part;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpRequestImpl;
import org.apache.openejb.server.httpd.part.CommonsFileUploadPart;

public final class CommonsFileUploadPartFactory {
    private static final File REPO;

    private CommonsFileUploadPartFactory() {
    }

    public static Collection<Part> read(HttpRequestImpl request) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(REPO);
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileItemFactory((FileItemFactory)factory);
        ArrayList<Part> parts = new ArrayList<Part>();
        try {
            List items = upload.parseRequest((RequestContext)new ServletRequestContext((HttpServletRequest)request));
            String enc = request.getCharacterEncoding();
            for (FileItem item : items) {
                CommonsFileUploadPart part = new CommonsFileUploadPart(item, null);
                parts.add(part);
                if (part.getSubmittedFileName() != null) continue;
                String name = part.getName();
                String value = null;
                try {
                    String encoding = request.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = enc == null ? "UTF-8" : enc;
                    }
                    value = part.getString(encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    try {
                        value = part.getString("UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
                request.addInternalParameter(name, value);
            }
            return parts;
        }
        catch (FileUploadException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        String repo = SystemInstance.get().getProperty("tomee.embedded.http.file.repository");
        if (repo == null) {
            for (String potential : Arrays.asList("work", "temp", "target", "build")) {
                try {
                    File directory = SystemInstance.get().getBase().getDirectory(potential);
                    if (!directory.isDirectory()) continue;
                    repo = directory.getAbsolutePath();
                    break;
                }
                catch (IOException iOException) {
                }
            }
        }
        REPO = new File(repo == null ? "." : repo);
    }
}

