/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.loader.Options;
import org.apache.openejb.monitoring.Event;
import org.apache.openejb.monitoring.Managed;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.discovery.MultipointServer;
import org.apache.openejb.server.discovery.Tracker;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.OptionsLog;

public class MultipointDiscoveryAgent
implements DiscoveryAgent,
ServerService,
SelfManaging {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("discovery").createChild("multipoint"), MultipointDiscoveryAgent.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    @Managed
    private String host = "127.0.0.1";
    @Managed
    private int port = 4212;
    private String initialServers = "";
    private long heartRate = 500L;
    @Managed(append=false)
    private Tracker tracker;
    private MultipointServer multipointServer;
    private boolean debug = true;
    private String name;
    private String discoveryHost;
    private Set<URI> roots;
    private Duration reconnectDelay;
    @Managed
    private final Event restarts = new Event();

    public MultipointDiscoveryAgent() {
    }

    public MultipointDiscoveryAgent(boolean debug, String name) {
        this.debug = debug;
        this.name = name;
    }

    public void init(Properties props) {
        Options options = new Options(props);
        options.setLogger((Options.Log)new OptionsLog(LOGGER));
        this.host = props.getProperty("bind", this.host);
        this.port = options.get("port", this.port);
        this.initialServers = options.get("initialServers", this.initialServers);
        this.heartRate = options.get("heart_rate", this.heartRate);
        this.discoveryHost = options.get("discoveryHost", this.host);
        this.name = this.name != null ? this.name : options.get("discoveryName", MultipointServer.randomColor());
        this.reconnectDelay = (Duration)options.get("reconnectDelay", (Object)new Duration("30 seconds"));
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        StringTokenizer st = new StringTokenizer(this.initialServers, ",");
        while (st.hasMoreTokens()) {
            URI uri;
            String string = st.nextToken().trim();
            if (string.startsWith("conn://")) {
                uri = URI.create(string);
                uris.add(uri);
                continue;
            }
            uri = URI.create("conn://" + string);
            uris.add(uri);
        }
        this.roots = uris;
        Tracker.Builder builder = new Tracker.Builder();
        builder.setHeartRate(this.heartRate);
        builder.setGroup(props.getProperty("group", builder.getGroup()));
        builder.setMaxMissedHeartbeats(options.get("max_missed_heartbeats", builder.getMaxMissedHeartbeats()));
        builder.setMaxReconnectDelay(options.get("max_reconnect_delay", builder.getMaxReconnectDelay()));
        builder.setReconnectDelay(options.get("reconnect_delay", builder.getReconnectDelay()));
        builder.setExponentialBackoff(options.get("exponential_backoff", builder.getExponentialBackoff()));
        builder.setMaxReconnectAttempts(options.get("max_reconnect_attempts", builder.getMaxReconnectAttempts()));
        builder.setDebug(this.debug);
        this.tracker = builder.build();
    }

    public String getIP() {
        return this.host;
    }

    public String getName() {
        return "multipoint";
    }

    public int getPort() {
        return this.port;
    }

    public String getInitialServers() {
        return this.initialServers;
    }

    public void setDiscoveryListener(DiscoveryListener listener) {
        this.tracker.setDiscoveryListener(listener);
    }

    public void registerService(URI serviceUri) throws IOException {
        this.tracker.registerService(serviceUri);
    }

    public void unregisterService(URI serviceUri) throws IOException {
        this.tracker.unregisterService(serviceUri);
    }

    public void reportFailed(URI serviceUri) {
        this.tracker.reportFailed(serviceUri);
    }

    public static void main(String[] args) throws Exception {
    }

    @Managed
    public void start() throws ServiceException {
        try {
            if (this.running.compareAndSet(false, true)) {
                LOGGER.info("MultipointDiscoveryAgent Starting");
                this.multipointServer = new MultipointServer(this.host, this.discoveryHost, this.port, this.tracker, this.name, this.debug, this.roots, this.reconnectDelay).start();
                LOGGER.info("MultipointDiscoveryAgent Started");
                this.port = this.multipointServer.getPort();
            }
        }
        catch (Exception e) {
            throw new ServiceException(this.port + "", (Throwable)e);
        }
    }

    @Managed
    public void restart() throws ServiceException {
        this.stop();
        this.start();
        this.restarts.record();
    }

    @Managed
    public void stop() throws ServiceException {
        if (this.running.compareAndSet(true, false)) {
            LOGGER.info("MultipointDiscoveryAgent Stopping");
            this.multipointServer.stop();
        }
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public void service(Socket socket) throws ServiceException, IOException {
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Managed
    public URI getURI() {
        return this.multipointServer.getMe();
    }

    @Managed
    public Set<URI> getRoots() {
        return this.multipointServer.getRoots();
    }

    @Managed
    public long getRuns() {
        return this.multipointServer.getRuns().get();
    }

    @Managed
    public String getRunsLatest() {
        return this.multipointServer.getRuns().getLatest();
    }

    @Managed
    public long getRunsLatestTime() {
        return this.multipointServer.getRuns().getLatestTime();
    }

    @Managed
    public long getHeartbeats() {
        return this.multipointServer.getHeartbeats().get();
    }

    @Managed
    public String getHeartbeatsLatest() {
        return this.multipointServer.getHeartbeats().getLatest();
    }

    @Managed
    public long getHeartbeatsLatestTime() {
        return this.multipointServer.getHeartbeats().getLatestTime();
    }

    @Managed
    public long getSessionsCreated() {
        return this.multipointServer.getSessionsCreated().get();
    }

    @Managed
    public String getSessionsCreatedLatest() {
        return this.multipointServer.getSessionsCreated().getLatest();
    }

    @Managed
    public long getSessionsCreatedLatestTime() {
        return this.multipointServer.getSessionsCreated().getLatestTime();
    }

    @Managed
    public long getReconnects() {
        return this.multipointServer.getReconnects().get();
    }

    @Managed
    public String getReconnectsLatest() {
        return this.multipointServer.getReconnects().getLatest();
    }

    @Managed
    public long getReconnectsLatestTime() {
        return this.multipointServer.getReconnects().getLatestTime();
    }

    @Managed
    public long getJoined() {
        return this.multipointServer.getJoined();
    }

    @Managed
    public List<URI> getSessions() {
        return this.multipointServer.getSessions();
    }

    @Managed
    public List<URI> getConnectionsQueued() {
        return this.multipointServer.getConnectionsQueued();
    }

    @Managed
    public long getReconnectDelay() {
        return this.multipointServer.getReconnectDelay();
    }
}

