/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.identitystore;

import java.lang.annotation.Annotation;
import java.security.Permission;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.el.ELProcessor;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.UsernamePasswordCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.IdentityStorePermission;
import javax.security.enterprise.identitystore.PasswordHash;
import javax.sql.DataSource;

@ApplicationScoped
public class TomEEDatabaseIdentityStore
implements IdentityStore {
    private final Pattern elExpressionPattern = Pattern.compile("^[#$]\\{(.+)}$");
    @Inject
    private BeanManager beanManager;
    @Inject
    private Supplier<DatabaseIdentityStoreDefinition> definitionSupplier;
    private DatabaseIdentityStoreDefinition definition;
    private Set<IdentityStore.ValidationType> validationTypes;
    private PasswordHash passwordHash;

    @PostConstruct
    private void init() throws Exception {
        this.definition = this.definitionSupplier.get();
        this.validationTypes = new HashSet<IdentityStore.ValidationType>(Arrays.asList(this.definition.useFor()));
        this.passwordHash = this.getInstance(this.definition.hashAlgorithm());
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(this.beanManager.getELResolver());
        this.passwordHash.initialize(Arrays.stream(this.definition.hashAlgorithmParameters()).flatMap(s -> this.toStream(this.eval(elProcessor, (String)s, String.class))).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> (String)this.eval(elProcessor, s.substring(s.indexOf(61) + 1), String.class))));
    }

    public CredentialValidationResult validate(Credential credential) {
        if (!(credential instanceof UsernamePasswordCredential)) {
            return CredentialValidationResult.NOT_VALIDATED_RESULT;
        }
        UsernamePasswordCredential usernamePasswordCredential = (UsernamePasswordCredential)credential;
        List<String> passwords = this.query(this.definition.callerQuery(), usernamePasswordCredential.getCaller());
        if (passwords.isEmpty()) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        if (this.passwordHash.verify(usernamePasswordCredential.getPassword().getValue(), passwords.get(0))) {
            Set groups = Collections.emptySet();
            if (this.validationTypes.contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) {
                groups = new HashSet<String>(this.getGroups(usernamePasswordCredential.getCaller()));
            }
            return new CredentialValidationResult(usernamePasswordCredential.getCaller(), groups);
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new IdentityStorePermission("getGroups"));
        }
        return this.getGroups(validationResult.getCallerPrincipal().getName());
    }

    private Set<String> getGroups(String username) {
        if (username == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.query(this.definition.groupsQuery(), username));
    }

    public int priority() {
        return this.definition.priority();
    }

    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.validationTypes;
    }

    private List<String> query(String query, String parameter) {
        ArrayList<String> result = new ArrayList<String>();
        DataSource dataSource = TomEEDatabaseIdentityStore.lookup(this.definition.dataSourceLookup());
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, parameter);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    public static DataSource lookup(String name) {
        if (name == null || name.trim().equals("")) {
            throw new RuntimeException("Can't lookup datasource because dataSourceLookup is null/empty in DatabaseIdentityStoreDefinition.");
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            DataSource dataSource = (DataSource)ctx.lookup("java:openejb/Resource/" + name);
            return dataSource;
        }
        catch (NamingException ne) {
            throw new RuntimeException("Can't find datasource with name in DatabaseIdentityStoreDefinition.", ne);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private Object eval(ELProcessor processor, String expression, Class<?> expectedType) {
        Matcher matcher = this.elExpressionPattern.matcher(expression);
        if (!matcher.matches()) {
            return expression;
        }
        String sanitizedExpression = matcher.replaceAll("$1");
        return processor.getValue(sanitizedExpression, expectedType);
    }

    private Stream<String> toStream(Object raw) {
        if (raw instanceof String[]) {
            return Arrays.stream((String[])raw);
        }
        if (raw instanceof Stream) {
            return ((Stream)raw).map(String::toString);
        }
        return Stream.of(raw.toString());
    }

    private <T extends PasswordHash> T getInstance(Class<T> beanType) {
        Bean bean = (Bean)this.beanManager.getBeans(beanType, new Annotation[0]).iterator().next();
        return (T)((PasswordHash)this.beanManager.getReference(bean, beanType, this.beanManager.createCreationalContext((Contextual)bean)));
    }
}

