/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.service;

import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.DefiningClassService;

public class ClassLoaderProxyService
implements DefiningClassService {
    private final ProxiesClassLoader loader;

    public ClassLoaderProxyService(WebBeansContext context) {
        this.loader = new ProxiesClassLoader(context.getApplicationBoundaryService().getApplicationClassLoader());
    }

    public ClassLoader getProxyClassLoader(Class<?> forClass) {
        return this.loader;
    }

    public <T> Class<T> defineAndLoad(String name, byte[] bytecode, Class<T> proxiedClass) {
        return this.loader.getOrRegister(name, bytecode, proxiedClass.getPackage(), proxiedClass.getProtectionDomain());
    }

    private static class ProxiesClassLoader
    extends ClassLoader {
        private final ConcurrentMap<String, Class<?>> classes = new ConcurrentHashMap();

        private ProxiesClassLoader(ClassLoader applicationClassLoader) {
            super(applicationClassLoader);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class clazz = (Class)this.classes.get(name);
            if (clazz == null) {
                return this.getParent().loadClass(name);
            }
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> getOrRegister(String proxyClassName, byte[] proxyBytes, Package pck, ProtectionDomain protectionDomain) {
            String key = proxyClassName.replace('/', '.');
            Class<?> existing = (Class<?>)this.classes.get(key);
            if (existing == null) {
                ProxiesClassLoader proxiesClassLoader = this;
                synchronized (proxiesClassLoader) {
                    existing = (Class)this.classes.get(key);
                    if (existing == null) {
                        this.definePackageFor(pck, protectionDomain);
                        existing = super.defineClass(proxyClassName, proxyBytes, 0, proxyBytes.length);
                        this.resolveClass(existing);
                        this.classes.put(key, existing);
                    }
                }
            }
            return existing;
        }

        private void definePackageFor(Package model, ProtectionDomain protectionDomain) {
            if (model == null) {
                return;
            }
            if (this.getPackage(model.getName()) == null) {
                if (model.isSealed() && protectionDomain != null && protectionDomain.getCodeSource() != null && protectionDomain.getCodeSource().getLocation() != null) {
                    this.definePackage(model.getName(), model.getSpecificationTitle(), model.getSpecificationVersion(), model.getSpecificationVendor(), model.getImplementationTitle(), model.getImplementationVersion(), model.getImplementationVendor(), protectionDomain.getCodeSource().getLocation());
                } else {
                    this.definePackage(model.getName(), model.getSpecificationTitle(), model.getSpecificationVersion(), model.getSpecificationVendor(), model.getImplementationTitle(), model.getImplementationVersion(), model.getImplementationVendor(), null);
                }
            }
        }
    }
}

