/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq.jms2;

import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.TransactionSupport;
import org.apache.activemq.ra.ActiveMQConnectionFactory;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.ActiveMQManagedConnectionFactory;
import org.apache.openejb.resource.activemq.jms2.JMS2;
import org.apache.openejb.resource.activemq.jms2.JMSContextImpl;

public class TomEERAConnectionFactory
extends ActiveMQConnectionFactory {
    private static final long serialVersionUID = 1L;
    private TransactionSupport.TransactionSupportLevel transactionSupportLevel = TransactionSupport.TransactionSupportLevel.XATransaction;

    public TomEERAConnectionFactory(ActiveMQManagedConnectionFactory factory, ConnectionManager manager, ActiveMQConnectionRequestInfo connectionRequestInfo) {
        super(factory, manager, connectionRequestInfo);
    }

    public JMSContext createContext() {
        boolean xa;
        int mode;
        switch (this.transactionSupportLevel) {
            case XATransaction: {
                if (JMS2.inTx()) {
                    mode = -1;
                    xa = true;
                    break;
                }
            }
            case NoTransaction: {
                mode = 1;
                xa = false;
                break;
            }
            case LocalTransaction: {
                mode = 0;
                xa = false;
                break;
            }
            default: {
                throw new IllegalStateException("transactionSupportLevel mode not supported:" + this.transactionSupportLevel);
            }
        }
        return new JMSContextImpl((ConnectionFactory)this, mode, null, null, xa);
    }

    public JMSContext createContext(int sessionMode) {
        boolean xa;
        int mode;
        switch (this.transactionSupportLevel) {
            case XATransaction: {
                if (JMS2.inTx()) {
                    mode = -1;
                    xa = true;
                    break;
                }
            }
            case NoTransaction: {
                mode = sessionMode;
                xa = false;
                break;
            }
            case LocalTransaction: {
                mode = 0;
                xa = false;
                break;
            }
            default: {
                throw new IllegalStateException("transactionSupportLevel mode not supported:" + this.transactionSupportLevel);
            }
        }
        return new JMSContextImpl((ConnectionFactory)this, mode, null, null, xa);
    }

    public JMSContext createContext(String userName, String password) {
        boolean xa;
        int mode;
        switch (this.transactionSupportLevel) {
            case XATransaction: {
                if (JMS2.inTx()) {
                    mode = -1;
                    xa = true;
                    break;
                }
            }
            case NoTransaction: {
                mode = 1;
                xa = false;
                break;
            }
            case LocalTransaction: {
                mode = 0;
                xa = false;
                break;
            }
            default: {
                throw new IllegalStateException("transactionSupportLevel mode not supported:" + this.transactionSupportLevel);
            }
        }
        return new JMSContextImpl((ConnectionFactory)this, mode, userName, password, xa);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        boolean xa;
        int mode;
        switch (this.transactionSupportLevel) {
            case XATransaction: {
                if (JMS2.inTx()) {
                    mode = -1;
                    xa = true;
                    break;
                }
            }
            case NoTransaction: {
                mode = sessionMode;
                xa = false;
                break;
            }
            case LocalTransaction: {
                mode = 0;
                xa = false;
                break;
            }
            default: {
                throw new IllegalStateException("transactionSupportLevel mode not supported:" + this.transactionSupportLevel);
            }
        }
        return new JMSContextImpl((ConnectionFactory)this, mode, userName, password, xa);
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return this.transactionSupportLevel;
    }

    public void setTransactionSupport(TransactionSupport.TransactionSupportLevel transactionSupportLevel) {
        if (transactionSupportLevel == null) {
            throw new IllegalArgumentException("transactionSupportLevel cannot be null");
        }
        this.transactionSupportLevel = transactionSupportLevel;
    }
}

